/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal.security;

public class SimpleBase64Encoder {
    private static final String PWDCHARS_STRING = "./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final char[] PWDCHARS_ARRAY = "./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();

    public static String encode(byte[] bytes) {
        int len = bytes.length;
        StringBuffer encoded = new StringBuffer((len + 2) / 3 * 4);
        int i2 = 0;
        int j2 = len;
        while (j2 >= 3) {
            encoded.append(SimpleBase64Encoder.to64((bytes[i2] & 0xFF) << 16 | (bytes[i2 + 1] & 0xFF) << 8 | bytes[i2 + 2] & 0xFF, 4));
            i2 += 3;
            j2 -= 3;
        }
        if (j2 == 2) {
            encoded.append(SimpleBase64Encoder.to64((bytes[i2] & 0xFF) << 8 | bytes[i2 + 1] & 0xFF, 3));
        }
        if (j2 == 1) {
            encoded.append(SimpleBase64Encoder.to64(bytes[i2] & 0xFF, 2));
        }
        return encoded.toString();
    }

    public static byte[] decode(String string) {
        int l2;
        long d2;
        byte[] encoded = string.getBytes();
        int len = encoded.length;
        byte[] decoded = new byte[len * 3 / 4];
        int i2 = 0;
        int j2 = len;
        int k2 = 0;
        while (j2 >= 4) {
            d2 = SimpleBase64Encoder.from64(encoded, i2, 4);
            j2 -= 4;
            i2 += 4;
            l2 = 2;
            while (l2 >= 0) {
                decoded[k2 + l2] = (byte)(d2 & 0xFFL);
                d2 >>= 8;
                --l2;
            }
            k2 += 3;
        }
        if (j2 == 3) {
            d2 = SimpleBase64Encoder.from64(encoded, i2, 3);
            l2 = 1;
            while (l2 >= 0) {
                decoded[k2 + l2] = (byte)(d2 & 0xFFL);
                d2 >>= 8;
                --l2;
            }
        }
        if (j2 == 2) {
            d2 = SimpleBase64Encoder.from64(encoded, i2, 2);
            decoded[k2] = (byte)(d2 & 0xFFL);
        }
        return decoded;
    }

    private static final String to64(long input, int size) {
        StringBuffer result = new StringBuffer(size);
        while (size > 0) {
            --size;
            result.append(PWDCHARS_ARRAY[(int)(input & 0x3FL)]);
            input >>= 6;
        }
        return result.toString();
    }

    private static final long from64(byte[] encoded, int idx, int size) {
        long res = 0L;
        int f2 = 0;
        while (size > 0) {
            byte d2;
            --size;
            long r = 0L;
            if ((d2 = encoded[idx++]) == 47) {
                r = 1L;
            }
            if (d2 >= 48 && d2 <= 57) {
                r = 2 + d2 - 48;
            }
            if (d2 >= 65 && d2 <= 90) {
                r = 12 + d2 - 65;
            }
            if (d2 >= 97 && d2 <= 122) {
                r = 38 + d2 - 97;
            }
            res += r << f2;
            f2 += 6;
        }
        return res;
    }
}

