/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.util.io.StreamOverflowException;

public final class Streams {
    private static int BUFFER_SIZE = 4096;

    public static void drain(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[BUFFER_SIZE];
        while (inputStream.read(byArray, 0, byArray.length) >= 0) {
        }
    }

    public static byte[] readAll(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Streams.pipeAll(inputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] readAllLimited(InputStream inputStream, int n2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Streams.pipeAllLimited(inputStream, n2, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static int readFully(InputStream inputStream, byte[] byArray) throws IOException {
        return Streams.readFully(inputStream, byArray, 0, byArray.length);
    }

    public static int readFully(InputStream inputStream, byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        int n5;
        for (n4 = 0; n4 < n3 && (n5 = inputStream.read(byArray, n2 + n4, n3 - n4)) >= 0; n4 += n5) {
        }
        return n4;
    }

    public static void pipeAll(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n2;
        byte[] byArray = new byte[BUFFER_SIZE];
        while ((n2 = inputStream.read(byArray, 0, byArray.length)) >= 0) {
            outputStream.write(byArray, 0, n2);
        }
    }

    public static long pipeAllLimited(InputStream inputStream, long l2, OutputStream outputStream) throws IOException {
        int n2;
        long l3 = 0L;
        byte[] byArray = new byte[BUFFER_SIZE];
        while ((n2 = inputStream.read(byArray, 0, byArray.length)) >= 0) {
            if (l2 - l3 < (long)n2) {
                throw new StreamOverflowException("Data Overflow");
            }
            l3 += (long)n2;
            outputStream.write(byArray, 0, n2);
        }
        return l3;
    }

    public static void writeBufTo(ByteArrayOutputStream byteArrayOutputStream, OutputStream outputStream) throws IOException {
        byteArrayOutputStream.writeTo(outputStream);
    }
}

