/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tsp;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataGroup {
    private List<byte[]> dataObjects;
    private byte[] groupHash;
    private TreeSet<byte[]> hashes;

    public DataGroup(List<byte[]> list) {
        this.dataObjects = list;
    }

    public DataGroup(byte[] byArray) {
        this.dataObjects = new ArrayList<byte[]>();
        this.dataObjects.add(byArray);
    }

    public TreeSet<byte[]> getHashes(DigestCalculator digestCalculator) {
        return this.getHashes(digestCalculator, null);
    }

    private TreeSet<byte[]> getHashes(DigestCalculator digestCalculator, byte[] byArray) {
        if (this.hashes == null) {
            this.hashes = new TreeSet(new ByteArrayComparator());
            for (int i2 = 0; i2 != this.dataObjects.size(); ++i2) {
                byte[] byArray2 = this.dataObjects.get(i2);
                if (byArray != null) {
                    this.hashes.add(DataGroup.calcDigest(digestCalculator, Arrays.concatenate(DataGroup.calcDigest(digestCalculator, byArray2), byArray)));
                    continue;
                }
                this.hashes.add(DataGroup.calcDigest(digestCalculator, byArray2));
            }
        }
        return this.hashes;
    }

    public byte[] getHash(DigestCalculator digestCalculator) {
        if (this.groupHash == null) {
            TreeSet<byte[]> treeSet = this.getHashes(digestCalculator);
            if (treeSet.size() > 1) {
                byte[] byArray = new byte[]{};
                Iterator<byte[]> iterator = treeSet.iterator();
                while (iterator.hasNext()) {
                    byArray = Arrays.concatenate(byArray, iterator.next());
                }
                this.groupHash = DataGroup.calcDigest(digestCalculator, byArray);
            } else {
                this.groupHash = treeSet.first();
            }
        }
        return this.groupHash;
    }

    static byte[] calcDigest(DigestCalculator digestCalculator, byte[] byArray) {
        try {
            OutputStream outputStream = digestCalculator.getOutputStream();
            outputStream.write(byArray);
            outputStream.close();
            return digestCalculator.getDigest();
        }
        catch (IOException iOException) {
            throw new IllegalStateException("digest calculator failure: " + iOException.getMessage());
        }
    }

    private class ByteArrayComparator
    implements Comparator {
        private ByteArrayComparator() {
        }

        public int compare(Object object, Object object2) {
            byte[] byArray = (byte[])object;
            byte[] byArray2 = (byte[])object2;
            int n2 = byArray.length < byArray2.length ? byArray.length : byArray2.length;
            for (int i2 = 0; i2 != n2; ++i2) {
                int n3 = byArray[i2] & 0xFF;
                int n4 = byArray2[i2] & 0xFF;
                if (n3 == n4) continue;
                return n3 - n4;
            }
            return byArray.length - byArray2.length;
        }
    }
}

