/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.util;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.util.Removal;

public class AreaReference {
    private static final char SHEET_NAME_DELIMITER = '!';
    private static final char CELL_DELIMITER = ':';
    private static final char SPECIAL_NAME_DELIMITER = '\'';
    private static final SpreadsheetVersion DEFAULT_SPREADSHEET_VERSION = SpreadsheetVersion.EXCEL97;
    private final CellReference _firstCell;
    private final CellReference _lastCell;
    private final boolean _isSingleCell;
    private final SpreadsheetVersion _version;

    public AreaReference(String reference, SpreadsheetVersion version) {
        SpreadsheetVersion spreadsheetVersion = this._version = null != version ? version : DEFAULT_SPREADSHEET_VERSION;
        if (!AreaReference.isContiguous(reference)) {
            throw new IllegalArgumentException("References passed to the AreaReference must be contiguous, use generateContiguous(ref) if you have non-contiguous references");
        }
        String[] parts = AreaReference.separateAreaRefs(reference);
        String part0 = parts[0];
        if (parts.length == 1) {
            this._lastCell = this._firstCell = new CellReference(part0);
            this._isSingleCell = true;
            return;
        }
        if (parts.length != 2) {
            throw new IllegalArgumentException("Bad area ref '" + reference + "'");
        }
        String part1 = parts[1];
        if (AreaReference.isPlainColumn(part0)) {
            if (!AreaReference.isPlainColumn(part1)) {
                throw new RuntimeException("Bad area ref '" + reference + "'");
            }
            boolean firstIsAbs = CellReference.isPartAbsolute(part0);
            boolean lastIsAbs = CellReference.isPartAbsolute(part1);
            int col0 = CellReference.convertColStringToIndex(part0);
            int col1 = CellReference.convertColStringToIndex(part1);
            this._firstCell = new CellReference(0, col0, true, firstIsAbs);
            this._lastCell = new CellReference(65535, col1, true, lastIsAbs);
            this._isSingleCell = false;
        } else {
            this._firstCell = new CellReference(part0);
            this._lastCell = new CellReference(part1);
            this._isSingleCell = part0.equals(part1);
        }
    }

    private static boolean isPlainColumn(String refPart) {
        for (int i2 = refPart.length() - 1; i2 >= 0; --i2) {
            char ch = refPart.charAt(i2);
            if (ch == '$' && i2 == 0 || ch >= 'A' && ch <= 'Z') continue;
            return false;
        }
        return true;
    }

    @Deprecated
    @Removal(version="3.19")
    public AreaReference(CellReference topLeft, CellReference botRight) {
        this(topLeft, botRight, DEFAULT_SPREADSHEET_VERSION);
    }

    public AreaReference(CellReference topLeft, CellReference botRight, SpreadsheetVersion version) {
        boolean swapCols;
        this._version = null != version ? version : DEFAULT_SPREADSHEET_VERSION;
        boolean swapRows = topLeft.getRow() > botRight.getRow();
        boolean bl = swapCols = topLeft.getCol() > botRight.getCol();
        if (swapRows || swapCols) {
            boolean lastColAbs;
            short lastColumn;
            boolean firstColAbs;
            short firstColumn;
            boolean lastRowAbs;
            int lastRow;
            boolean firstRowAbs;
            int firstRow;
            if (swapRows) {
                firstRow = botRight.getRow();
                firstRowAbs = botRight.isRowAbsolute();
                lastRow = topLeft.getRow();
                lastRowAbs = topLeft.isRowAbsolute();
            } else {
                firstRow = topLeft.getRow();
                firstRowAbs = topLeft.isRowAbsolute();
                lastRow = botRight.getRow();
                lastRowAbs = botRight.isRowAbsolute();
            }
            if (swapCols) {
                firstColumn = botRight.getCol();
                firstColAbs = botRight.isColAbsolute();
                lastColumn = topLeft.getCol();
                lastColAbs = topLeft.isColAbsolute();
            } else {
                firstColumn = topLeft.getCol();
                firstColAbs = topLeft.isColAbsolute();
                lastColumn = botRight.getCol();
                lastColAbs = botRight.isColAbsolute();
            }
            this._firstCell = new CellReference(firstRow, firstColumn, firstRowAbs, firstColAbs);
            this._lastCell = new CellReference(lastRow, lastColumn, lastRowAbs, lastColAbs);
        } else {
            this._firstCell = topLeft;
            this._lastCell = botRight;
        }
        this._isSingleCell = false;
    }

    public static boolean isContiguous(String reference) {
        int sheetRefEnd = reference.indexOf(33);
        if (sheetRefEnd != -1) {
            reference = reference.substring(sheetRefEnd);
        }
        return !reference.contains(",");
    }

    public static AreaReference getWholeRow(SpreadsheetVersion version, String start, String end) {
        if (null == version) {
            version = DEFAULT_SPREADSHEET_VERSION;
        }
        return new AreaReference("$A" + start + ":$" + version.getLastColumnName() + end, version);
    }

    public static AreaReference getWholeColumn(SpreadsheetVersion version, String start, String end) {
        if (null == version) {
            version = DEFAULT_SPREADSHEET_VERSION;
        }
        return new AreaReference(start + "$1:" + end + "$" + version.getMaxRows(), version);
    }

    public static boolean isWholeColumnReference(SpreadsheetVersion version, CellReference topLeft, CellReference botRight) {
        if (null == version) {
            version = DEFAULT_SPREADSHEET_VERSION;
        }
        return topLeft.getRow() == 0 && topLeft.isRowAbsolute() && botRight.getRow() == version.getLastRowIndex() && botRight.isRowAbsolute();
    }

    public boolean isWholeColumnReference() {
        return AreaReference.isWholeColumnReference(this._version, this._firstCell, this._lastCell);
    }

    @Deprecated
    @Removal(version="3.19")
    public static AreaReference[] generateContiguous(String reference) {
        return AreaReference.generateContiguous(DEFAULT_SPREADSHEET_VERSION, reference);
    }

    public static AreaReference[] generateContiguous(SpreadsheetVersion version, String reference) {
        if (null == version) {
            version = DEFAULT_SPREADSHEET_VERSION;
        }
        ArrayList<AreaReference> refs = new ArrayList<AreaReference>();
        StringTokenizer st = new StringTokenizer(reference, ",");
        while (st.hasMoreTokens()) {
            refs.add(new AreaReference(st.nextToken(), version));
        }
        return refs.toArray(new AreaReference[refs.size()]);
    }

    public boolean isSingleCell() {
        return this._isSingleCell;
    }

    public CellReference getFirstCell() {
        return this._firstCell;
    }

    public CellReference getLastCell() {
        return this._lastCell;
    }

    public CellReference[] getAllReferencedCells() {
        if (this._isSingleCell) {
            return new CellReference[]{this._firstCell};
        }
        int minRow = Math.min(this._firstCell.getRow(), this._lastCell.getRow());
        int maxRow = Math.max(this._firstCell.getRow(), this._lastCell.getRow());
        int minCol = Math.min(this._firstCell.getCol(), this._lastCell.getCol());
        int maxCol = Math.max(this._firstCell.getCol(), this._lastCell.getCol());
        String sheetName = this._firstCell.getSheetName();
        ArrayList<CellReference> refs = new ArrayList<CellReference>();
        for (int row = minRow; row <= maxRow; ++row) {
            for (int col = minCol; col <= maxCol; ++col) {
                CellReference ref = new CellReference(sheetName, row, col, this._firstCell.isRowAbsolute(), this._firstCell.isColAbsolute());
                refs.add(ref);
            }
        }
        return refs.toArray(new CellReference[refs.size()]);
    }

    public String formatAsString() {
        if (this.isWholeColumnReference()) {
            return CellReference.convertNumToColString(this._firstCell.getCol()) + ":" + CellReference.convertNumToColString(this._lastCell.getCol());
        }
        StringBuffer sb = new StringBuffer(32);
        sb.append(this._firstCell.formatAsString());
        if (!this._isSingleCell) {
            sb.append(':');
            if (this._lastCell.getSheetName() == null) {
                sb.append(this._lastCell.formatAsString());
            } else {
                this._lastCell.appendCellReference(sb);
            }
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append(this.getClass().getName()).append(" [");
        sb.append(this.formatAsString());
        sb.append("]");
        return sb.toString();
    }

    private static String[] separateAreaRefs(String reference) {
        int len = reference.length();
        int delimiterPos = -1;
        boolean insideDelimitedName = false;
        block4: for (int i2 = 0; i2 < len; ++i2) {
            switch (reference.charAt(i2)) {
                case ':': {
                    if (insideDelimitedName) continue block4;
                    if (delimiterPos >= 0) {
                        throw new IllegalArgumentException("More than one cell delimiter ':' appears in area reference '" + reference + "'");
                    }
                    delimiterPos = i2;
                    continue block4;
                }
                case '\'': {
                    break;
                }
                default: {
                    continue block4;
                }
            }
            if (!insideDelimitedName) {
                insideDelimitedName = true;
                continue;
            }
            if (i2 >= len - 1) {
                throw new IllegalArgumentException("Area reference '" + reference + "' ends with special name delimiter '" + '\'' + "'");
            }
            if (reference.charAt(i2 + 1) == '\'') {
                ++i2;
                continue;
            }
            insideDelimitedName = false;
        }
        if (delimiterPos < 0) {
            return new String[]{reference};
        }
        String partA = reference.substring(0, delimiterPos);
        String partB = reference.substring(delimiterPos + 1);
        if (partB.indexOf(33) >= 0) {
            throw new RuntimeException("Unexpected ! in second cell reference of '" + reference + "'");
        }
        int plingPos = partA.lastIndexOf(33);
        if (plingPos < 0) {
            return new String[]{partA, partB};
        }
        String sheetName = partA.substring(0, plingPos + 1);
        return new String[]{partA, sheetName + partB};
    }
}

