/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.usermodel.helpers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.poi.ss.formula.FormulaShifter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.util.Internal;

public abstract class RowShifter {
    protected final Sheet sheet;

    public RowShifter(Sheet sh) {
        this.sheet = sh;
    }

    public List<CellRangeAddress> shiftMergedRegions(int startRow, int endRow, int n2) {
        ArrayList<CellRangeAddress> shiftedRegions = new ArrayList<CellRangeAddress>();
        HashSet<Integer> removedIndices = new HashSet<Integer>();
        int size = this.sheet.getNumMergedRegions();
        for (int i2 = 0; i2 < size; ++i2) {
            boolean inEnd;
            CellRangeAddress merged = this.sheet.getMergedRegion(i2);
            if (this.removalNeeded(merged, startRow, endRow, n2)) {
                removedIndices.add(i2);
                continue;
            }
            boolean inStart = merged.getFirstRow() >= startRow || merged.getLastRow() >= startRow;
            boolean bl = inEnd = merged.getFirstRow() <= endRow || merged.getLastRow() <= endRow;
            if (!inStart || !inEnd || merged.containsRow(startRow - 1) || merged.containsRow(endRow + 1)) continue;
            merged.setFirstRow(merged.getFirstRow() + n2);
            merged.setLastRow(merged.getLastRow() + n2);
            shiftedRegions.add(merged);
            removedIndices.add(i2);
        }
        if (!removedIndices.isEmpty()) {
            this.sheet.removeMergedRegions(removedIndices);
        }
        for (CellRangeAddress region : shiftedRegions) {
            this.sheet.addMergedRegion(region);
        }
        return shiftedRegions;
    }

    private boolean removalNeeded(CellRangeAddress merged, int startRow, int endRow, int n2) {
        int movedRows = endRow - startRow + 1;
        CellRangeAddress overwrite = n2 > 0 ? new CellRangeAddress(Math.max(endRow + 1, endRow + n2 - movedRows), endRow + n2, 0, 0) : new CellRangeAddress(startRow + n2, Math.min(startRow - 1, startRow + n2 + movedRows), 0, 0);
        return merged.intersects(overwrite);
    }

    public abstract void updateNamedRanges(FormulaShifter var1);

    public abstract void updateFormulas(FormulaShifter var1);

    @Internal
    public abstract void updateRowFormulas(Row var1, FormulaShifter var2);

    public abstract void updateConditionalFormatting(FormulaShifter var1);

    public abstract void updateHyperlinks(FormulaShifter var1);
}

