/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.eventusermodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.eventusermodel.AbortableHSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFUserException;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFactory;

public class HSSFRequest {
    private final Map<Short, List<HSSFListener>> _records = new HashMap<Short, List<HSSFListener>>(50);

    public void addListener(HSSFListener lsnr, short sid) {
        List<HSSFListener> list = this._records.get(sid);
        if (list == null) {
            list = new ArrayList<HSSFListener>(1);
            this._records.put(sid, list);
        }
        list.add(lsnr);
    }

    public void addListenerForAllRecords(HSSFListener lsnr) {
        short[] rectypes;
        for (short rectype : rectypes = RecordFactory.getAllKnownRecordSIDs()) {
            this.addListener(lsnr, rectype);
        }
    }

    protected short processRecord(Record rec) throws HSSFUserException {
        List<HSSFListener> listeners = this._records.get(rec.getSid());
        short userCode2 = 0;
        if (listeners != null) {
            for (int k2 = 0; k2 < listeners.size(); ++k2) {
                HSSFListener listener;
                HSSFListener listenObj = listeners.get(k2);
                if (listenObj instanceof AbortableHSSFListener) {
                    listener = (AbortableHSSFListener)listenObj;
                    userCode2 = ((AbortableHSSFListener)listener).abortableProcessRecord(rec);
                    if (userCode2 == 0) continue;
                    break;
                }
                listener = listenObj;
                listener.processRecord(rec);
            }
        }
        return userCode2;
    }
}

