/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf.wellknown;

import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hpsf.ClassID;
import org.apache.poi.hpsf.wellknown.PropertyIDMap;
import org.apache.poi.util.Internal;

@Internal
public class SectionIDMap {
    private static ThreadLocal<Map<ClassID, PropertyIDMap>> defaultMap = new ThreadLocal();
    public static final ClassID SUMMARY_INFORMATION_ID = new ClassID("{F29F85E0-4FF9-1068-AB91-08002B27B3D9}");
    private static final ClassID DOC_SUMMARY_INFORMATION = new ClassID("{D5CDD502-2E9C-101B-9397-08002B2CF9AE}");
    private static final ClassID USER_DEFINED_PROPERTIES = new ClassID("{D5CDD505-2E9C-101B-9397-08002B2CF9AE}");
    public static final ClassID[] DOCUMENT_SUMMARY_INFORMATION_ID = new ClassID[]{DOC_SUMMARY_INFORMATION, USER_DEFINED_PROPERTIES};
    public static final String UNDEFINED = "[undefined]";

    public static SectionIDMap getInstance() {
        Map<ClassID, PropertyIDMap> m2 = defaultMap.get();
        if (m2 == null) {
            m2 = new HashMap<ClassID, PropertyIDMap>();
            m2.put(SUMMARY_INFORMATION_ID, PropertyIDMap.getSummaryInformationProperties());
            m2.put(DOCUMENT_SUMMARY_INFORMATION_ID[0], PropertyIDMap.getDocumentSummaryInformationProperties());
            defaultMap.set(m2);
        }
        return new SectionIDMap();
    }

    public static String getPIDString(ClassID sectionFormatID, long pid) {
        PropertyIDMap m2 = SectionIDMap.getInstance().get(sectionFormatID);
        if (m2 == null) {
            return UNDEFINED;
        }
        String s = m2.get(pid);
        if (s == null) {
            return UNDEFINED;
        }
        return s;
    }

    public PropertyIDMap get(ClassID sectionFormatID) {
        return SectionIDMap.getInstance().get(sectionFormatID);
    }

    public PropertyIDMap put(ClassID sectionFormatID, PropertyIDMap propertyIDMap) {
        return SectionIDMap.getInstance().put(sectionFormatID, propertyIDMap);
    }

    protected PropertyIDMap put(String key, PropertyIDMap value) {
        return this.put(new ClassID(key), value);
    }
}

