/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util.operator;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.pdmodel.graphics.color.PDCalRGB;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceCMYK;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceN;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.color.PDICCBased;
import org.apache.pdfbox.pdmodel.graphics.color.PDIndexed;
import org.apache.pdfbox.pdmodel.graphics.color.PDLab;
import org.apache.pdfbox.pdmodel.graphics.color.PDPattern;
import org.apache.pdfbox.pdmodel.graphics.color.PDSeparation;
import org.apache.pdfbox.util.PDFOperator;
import org.apache.pdfbox.util.operator.OperatorProcessor;
import org.apache.pdfbox.util.operator.SetNonStrokingCMYKColor;
import org.apache.pdfbox.util.operator.SetNonStrokingCalRGBColor;
import org.apache.pdfbox.util.operator.SetNonStrokingDeviceN;
import org.apache.pdfbox.util.operator.SetNonStrokingGrayColor;
import org.apache.pdfbox.util.operator.SetNonStrokingICCBasedColor;
import org.apache.pdfbox.util.operator.SetNonStrokingIndexed;
import org.apache.pdfbox.util.operator.SetNonStrokingLabColor;
import org.apache.pdfbox.util.operator.SetNonStrokingPattern;
import org.apache.pdfbox.util.operator.SetNonStrokingRGBColor;
import org.apache.pdfbox.util.operator.SetNonStrokingSeparation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetNonStrokingColor
extends OperatorProcessor {
    private static final Log LOG = LogFactory.getLog(SetNonStrokingColor.class);

    @Override
    public void process(PDFOperator operator2, List<COSBase> arguments) throws IOException {
        PDColorSpace colorSpace = this.context.getGraphicsState().getNonStrokingColor().getColorSpace();
        if (colorSpace != null) {
            OperatorProcessor newOperator = null;
            if (colorSpace instanceof PDDeviceGray) {
                newOperator = new SetNonStrokingGrayColor();
            } else if (colorSpace instanceof PDDeviceRGB) {
                newOperator = new SetNonStrokingRGBColor();
            } else if (colorSpace instanceof PDDeviceCMYK) {
                newOperator = new SetNonStrokingCMYKColor();
            } else if (colorSpace instanceof PDICCBased) {
                newOperator = new SetNonStrokingICCBasedColor();
            } else if (colorSpace instanceof PDCalRGB) {
                newOperator = new SetNonStrokingCalRGBColor();
            } else if (colorSpace instanceof PDSeparation) {
                newOperator = new SetNonStrokingSeparation();
            } else if (colorSpace instanceof PDDeviceN) {
                newOperator = new SetNonStrokingDeviceN();
            } else if (colorSpace instanceof PDPattern) {
                newOperator = new SetNonStrokingPattern();
            } else if (colorSpace instanceof PDIndexed) {
                newOperator = new SetNonStrokingIndexed();
            } else if (colorSpace instanceof PDLab) {
                newOperator = new SetNonStrokingLabColor();
            }
            if (newOperator != null) {
                newOperator.setContext(this.getContext());
                ((OperatorProcessor)newOperator).process(operator2, arguments);
            } else {
                LOG.warn("Not supported colorspace " + colorSpace.getName() + " within operator " + operator2.getOperation());
            }
        } else {
            LOG.warn("Colorspace not found in " + this.getClass().getName() + ".process!!");
        }
    }
}

