/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.measurement;

import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.interactive.measurement.PDMeasureDictionary;
import org.apache.pdfbox.pdmodel.interactive.measurement.PDNumberFormatDictionary;

public class PDRectlinearMeasureDictionary
extends PDMeasureDictionary {
    public static final String SUBTYPE = "RL";

    public PDRectlinearMeasureDictionary() {
        this.setSubtype(SUBTYPE);
    }

    public PDRectlinearMeasureDictionary(COSDictionary dictionary) {
        super(dictionary);
    }

    public String getScaleRatio() {
        return this.getDictionary().getString(COSName.R);
    }

    public void setScaleRatio(String scaleRatio) {
        this.getDictionary().setString(COSName.R, scaleRatio);
    }

    public PDNumberFormatDictionary[] getChangeXs() {
        COSArray x = (COSArray)this.getDictionary().getDictionaryObject("X");
        if (x != null) {
            PDNumberFormatDictionary[] retval = new PDNumberFormatDictionary[x.size()];
            for (int i2 = 0; i2 < x.size(); ++i2) {
                COSDictionary dic = (COSDictionary)x.get(i2);
                retval[i2] = new PDNumberFormatDictionary(dic);
            }
            return retval;
        }
        return null;
    }

    public void setChangeXs(PDNumberFormatDictionary[] changeXs) {
        COSArray array = new COSArray();
        for (int i2 = 0; i2 < changeXs.length; ++i2) {
            array.add(changeXs[i2]);
        }
        this.getDictionary().setItem("X", (COSBase)array);
    }

    public PDNumberFormatDictionary[] getChangeYs() {
        COSArray y = (COSArray)this.getDictionary().getDictionaryObject("Y");
        if (y != null) {
            PDNumberFormatDictionary[] retval = new PDNumberFormatDictionary[y.size()];
            for (int i2 = 0; i2 < y.size(); ++i2) {
                COSDictionary dic = (COSDictionary)y.get(i2);
                retval[i2] = new PDNumberFormatDictionary(dic);
            }
            return retval;
        }
        return null;
    }

    public void setChangeYs(PDNumberFormatDictionary[] changeYs) {
        COSArray array = new COSArray();
        for (int i2 = 0; i2 < changeYs.length; ++i2) {
            array.add(changeYs[i2]);
        }
        this.getDictionary().setItem("Y", (COSBase)array);
    }

    public PDNumberFormatDictionary[] getDistances() {
        COSArray d2 = (COSArray)this.getDictionary().getDictionaryObject("D");
        if (d2 != null) {
            PDNumberFormatDictionary[] retval = new PDNumberFormatDictionary[d2.size()];
            for (int i2 = 0; i2 < d2.size(); ++i2) {
                COSDictionary dic = (COSDictionary)d2.get(i2);
                retval[i2] = new PDNumberFormatDictionary(dic);
            }
            return retval;
        }
        return null;
    }

    public void setDistances(PDNumberFormatDictionary[] distances) {
        COSArray array = new COSArray();
        for (int i2 = 0; i2 < distances.length; ++i2) {
            array.add(distances[i2]);
        }
        this.getDictionary().setItem("D", (COSBase)array);
    }

    public PDNumberFormatDictionary[] getAreas() {
        COSArray a2 = (COSArray)this.getDictionary().getDictionaryObject(COSName.A);
        if (a2 != null) {
            PDNumberFormatDictionary[] retval = new PDNumberFormatDictionary[a2.size()];
            for (int i2 = 0; i2 < a2.size(); ++i2) {
                COSDictionary dic = (COSDictionary)a2.get(i2);
                retval[i2] = new PDNumberFormatDictionary(dic);
            }
            return retval;
        }
        return null;
    }

    public void setAreas(PDNumberFormatDictionary[] areas) {
        COSArray array = new COSArray();
        for (int i2 = 0; i2 < areas.length; ++i2) {
            array.add(areas[i2]);
        }
        this.getDictionary().setItem(COSName.A, (COSBase)array);
    }

    public PDNumberFormatDictionary[] getAngles() {
        COSArray t = (COSArray)this.getDictionary().getDictionaryObject("T");
        if (t != null) {
            PDNumberFormatDictionary[] retval = new PDNumberFormatDictionary[t.size()];
            for (int i2 = 0; i2 < t.size(); ++i2) {
                COSDictionary dic = (COSDictionary)t.get(i2);
                retval[i2] = new PDNumberFormatDictionary(dic);
            }
            return retval;
        }
        return null;
    }

    public void setAngles(PDNumberFormatDictionary[] angles) {
        COSArray array = new COSArray();
        for (int i2 = 0; i2 < angles.length; ++i2) {
            array.add(angles[i2]);
        }
        this.getDictionary().setItem("T", (COSBase)array);
    }

    public PDNumberFormatDictionary[] getLineSloaps() {
        COSArray s = (COSArray)this.getDictionary().getDictionaryObject("S");
        if (s != null) {
            PDNumberFormatDictionary[] retval = new PDNumberFormatDictionary[s.size()];
            for (int i2 = 0; i2 < s.size(); ++i2) {
                COSDictionary dic = (COSDictionary)s.get(i2);
                retval[i2] = new PDNumberFormatDictionary(dic);
            }
            return retval;
        }
        return null;
    }

    public void setLineSloaps(PDNumberFormatDictionary[] lineSloaps) {
        COSArray array = new COSArray();
        for (int i2 = 0; i2 < lineSloaps.length; ++i2) {
            array.add(lineSloaps[i2]);
        }
        this.getDictionary().setItem("S", (COSBase)array);
    }

    public float[] getCoordSystemOrigin() {
        COSArray o2 = (COSArray)this.getDictionary().getDictionaryObject("O");
        if (o2 != null) {
            return o2.toFloatArray();
        }
        return null;
    }

    public void setCoordSystemOrigin(float[] coordSystemOrigin) {
        COSArray array = new COSArray();
        array.setFloatArray(coordSystemOrigin);
        this.getDictionary().setItem("O", (COSBase)array);
    }

    public float getCYX() {
        return this.getDictionary().getFloat("CYX");
    }

    public void setCYX(float cyx) {
        this.getDictionary().setFloat("CYX", cyx);
    }
}

