/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.form;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.fdf.FDFCatalog;
import org.apache.pdfbox.pdmodel.fdf.FDFDictionary;
import org.apache.pdfbox.pdmodel.fdf.FDFDocument;
import org.apache.pdfbox.pdmodel.fdf.FDFField;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDFieldFactory;
import org.apache.pdfbox.pdmodel.interactive.form.PDXFA;

public class PDAcroForm
implements COSObjectable {
    private COSDictionary acroForm;
    private PDDocument document;
    private Map fieldCache;

    public PDAcroForm(PDDocument doc) {
        this.document = doc;
        this.acroForm = new COSDictionary();
        COSArray fields = new COSArray();
        this.acroForm.setItem(COSName.getPDFName("Fields"), (COSBase)fields);
    }

    public PDAcroForm(PDDocument doc, COSDictionary form) {
        this.document = doc;
        this.acroForm = form;
    }

    public PDDocument getDocument() {
        return this.document;
    }

    public COSDictionary getDictionary() {
        return this.acroForm;
    }

    public void importFDF(FDFDocument fdf) throws IOException {
        List fields = fdf.getCatalog().getFDF().getFields();
        if (fields != null) {
            for (int i2 = 0; i2 < fields.size(); ++i2) {
                FDFField fdfField = (FDFField)fields.get(i2);
                PDField docField = this.getField(fdfField.getPartialFieldName());
                if (docField == null) continue;
                docField.importFDF(fdfField);
            }
        }
    }

    public FDFDocument exportFDF() throws IOException {
        FDFDocument fdf = new FDFDocument();
        FDFCatalog catalog = fdf.getCatalog();
        FDFDictionary fdfDict = new FDFDictionary();
        catalog.setFDF(fdfDict);
        ArrayList fdfFields = new ArrayList();
        List fields = this.getFields();
        for (PDField docField : fields) {
            this.addFieldAndChildren(docField, fdfFields);
        }
        fdfDict.setID(this.document.getDocument().getDocumentID());
        if (fdfFields.size() > 0) {
            fdfDict.setFields(fdfFields);
        }
        return fdf;
    }

    private void addFieldAndChildren(PDField docField, List fdfFields) throws IOException {
        String fieldValue = docField.getValue();
        FDFField fdfField = new FDFField();
        fdfField.setPartialFieldName(docField.getPartialName());
        fdfField.setValue(fieldValue);
        List<COSObjectable> kids = docField.getKids();
        ArrayList<FDFField> childFDFFields = new ArrayList<FDFField>();
        if (kids != null) {
            for (int i2 = 0; i2 < kids.size(); ++i2) {
                this.addFieldAndChildren((PDField)kids.get(i2), childFDFFields);
            }
            if (childFDFFields.size() > 0) {
                fdfField.setKids(childFDFFields);
            }
        }
        if (fieldValue != null || childFDFFields.size() > 0) {
            fdfFields.add(fdfField);
        }
    }

    public List getFields() throws IOException {
        COSArrayList retval = null;
        COSArray fields = (COSArray)this.acroForm.getDictionaryObject(COSName.getPDFName("Fields"));
        if (fields != null) {
            ArrayList<PDField> actuals = new ArrayList<PDField>();
            for (int i2 = 0; i2 < fields.size(); ++i2) {
                PDField field;
                COSDictionary element = (COSDictionary)fields.getObject(i2);
                if (element == null || (field = PDFieldFactory.createField(this, element)) == null) continue;
                actuals.add(field);
            }
            retval = new COSArrayList(actuals, fields);
        }
        return retval;
    }

    public void setFields(List fields) {
        this.acroForm.setItem("Fields", (COSBase)COSArrayList.converterToCOSArray(fields));
    }

    public void setCacheFields(boolean cache) throws IOException {
        if (cache) {
            this.fieldCache = new HashMap();
            List fields = this.getFields();
            for (PDField next : fields) {
                this.fieldCache.put(next.getFullyQualifiedName(), next);
            }
        } else {
            this.fieldCache = null;
        }
    }

    public boolean isCachingFields() {
        return this.fieldCache != null;
    }

    public PDField getField(String name) throws IOException {
        PDField retval = null;
        if (this.fieldCache != null) {
            retval = (PDField)this.fieldCache.get(name);
        } else {
            String[] nameSubSection = name.split("\\.");
            COSArray fields = (COSArray)this.acroForm.getDictionaryObject(COSName.getPDFName("Fields"));
            for (int i2 = 0; i2 < fields.size() && retval == null; ++i2) {
                COSString fieldName;
                COSDictionary element = (COSDictionary)fields.getObject(i2);
                if (element == null || !(fieldName = (COSString)element.getDictionaryObject(COSName.getPDFName("T"))).getString().equals(name) && !fieldName.getString().equals(nameSubSection[0])) continue;
                PDField root = PDFieldFactory.createField(this, element);
                if (nameSubSection.length > 1) {
                    PDField kid = root.findKid(nameSubSection, 1);
                    if (kid != null) {
                        retval = kid;
                        continue;
                    }
                    retval = root;
                    continue;
                }
                retval = root;
            }
        }
        return retval;
    }

    public PDResources getDefaultResources() {
        PDResources retval = null;
        COSDictionary dr = (COSDictionary)this.acroForm.getDictionaryObject(COSName.getPDFName("DR"));
        if (dr != null) {
            retval = new PDResources(dr);
        }
        return retval;
    }

    public void setDefaultResources(PDResources dr) {
        COSDictionary drDict = null;
        if (dr != null) {
            drDict = dr.getCOSDictionary();
        }
        this.acroForm.setItem(COSName.getPDFName("DR"), (COSBase)drDict);
    }

    public COSBase getCOSObject() {
        return this.acroForm;
    }

    public PDXFA getXFA() {
        PDXFA xfa = null;
        COSBase base = this.acroForm.getDictionaryObject("XFA");
        if (base != null) {
            xfa = new PDXFA(base);
        }
        return xfa;
    }

    public void setXFA(PDXFA xfa) {
        this.acroForm.setItem("XFA", (COSObjectable)xfa);
    }
}

