/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.shading;

import java.awt.geom.Point2D;

public class GouraudTriangle {
    protected final Point2D pointA;
    protected final Point2D pointB;
    protected final Point2D pointC;
    protected final float[] colorA;
    protected final float[] colorB;
    protected final float[] colorC;
    private final double xBminusA;
    private final double yBminusA;
    private final double xCminusA;
    private final double yCminusA;
    private final double xCminusB;
    private final double yCminusB;
    private final double area;

    public GouraudTriangle(Point2D a2, float[] aColor, Point2D b2, float[] bColor, Point2D c2, float[] cColor) {
        this.pointA = a2;
        this.pointB = b2;
        this.pointC = c2;
        this.colorA = aColor;
        this.colorB = bColor;
        this.colorC = cColor;
        this.xBminusA = this.pointB.getX() - this.pointA.getX();
        this.yBminusA = this.pointB.getY() - this.pointA.getY();
        this.xCminusA = this.pointC.getX() - this.pointA.getX();
        this.yCminusA = this.pointC.getY() - this.pointA.getY();
        this.xCminusB = this.pointC.getX() - this.pointB.getX();
        this.yCminusB = this.pointC.getY() - this.pointB.getY();
        this.area = this.getArea(this.pointA, this.pointB, this.pointC);
    }

    public boolean contains(Point2D p) {
        boolean signAB;
        double yPminusA;
        double xPminusA = p.getX() - this.pointA.getX();
        if (this.xCminusA * yPminusA - this.yCminusA * xPminusA > 0.0 == (signAB = this.xBminusA * (yPminusA = p.getY() - this.pointA.getY()) - this.yBminusA * xPminusA > 0.0)) {
            return false;
        }
        return this.xCminusB * (p.getY() - this.pointB.getY()) - this.yCminusB * (p.getX() - this.pointB.getX()) > 0.0 == signAB;
    }

    private double getArea(Point2D a2, Point2D b2, Point2D c2) {
        return Math.abs((a2.getX() - c2.getX()) * (b2.getY() - a2.getY()) - (a2.getX() - b2.getX()) * (c2.getY() - a2.getY())) / 2.0;
    }

    boolean isEmpty() {
        return this.area == 0.0;
    }

    public double[] getWeights(Point2D p) {
        return new double[]{this.getArea(this.pointB, this.pointC, p) / this.area, this.getArea(this.pointA, this.pointC, p) / this.area, this.getArea(this.pointA, this.pointB, p) / this.area};
    }
}

