/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.predictor;

import java.util.Random;
import org.apache.pdfbox.pdmodel.graphics.predictor.Average;
import org.apache.pdfbox.pdmodel.graphics.predictor.None;
import org.apache.pdfbox.pdmodel.graphics.predictor.Optimum;
import org.apache.pdfbox.pdmodel.graphics.predictor.Paeth;
import org.apache.pdfbox.pdmodel.graphics.predictor.Sub;
import org.apache.pdfbox.pdmodel.graphics.predictor.Up;

public abstract class PredictorAlgorithm {
    private int width;
    private int height;
    private int bpp;

    public void checkBufsiz(byte[] src, byte[] dest) {
        if (src.length != dest.length) {
            throw new IllegalArgumentException("src.length != dest.length");
        }
        if (src.length != this.getWidth() * this.getHeight() * this.getBpp()) {
            throw new IllegalArgumentException("src.length != width * height * bpp");
        }
    }

    public abstract void encodeLine(byte[] var1, byte[] var2, int var3, int var4, int var5, int var6);

    public abstract void decodeLine(byte[] var1, byte[] var2, int var3, int var4, int var5, int var6);

    public static void main(String[] args) {
        Random rnd = new Random();
        int width = 5;
        int height = 5;
        int bpp = 3;
        byte[] raw = new byte[width * height * bpp];
        rnd.nextBytes(raw);
        System.out.println("raw:   ");
        PredictorAlgorithm.dump(raw);
        for (int i2 = 10; i2 < 15; ++i2) {
            byte[] decoded = new byte[width * height * bpp];
            byte[] encoded = new byte[width * height * bpp];
            PredictorAlgorithm filter = PredictorAlgorithm.getFilter(i2);
            filter.setWidth(width);
            filter.setHeight(height);
            filter.setBpp(bpp);
            filter.encode(raw, encoded);
            filter.decode(encoded, decoded);
            System.out.println(filter.getClass().getName());
            PredictorAlgorithm.dump(decoded);
        }
    }

    public int leftPixel(byte[] buf, int offset, int dy, int x) {
        return x >= this.getBpp() ? buf[offset + x - this.getBpp()] : 0;
    }

    public int abovePixel(byte[] buf, int offset, int dy, int x) {
        return offset >= dy ? buf[offset + x - dy] : 0;
    }

    public int aboveLeftPixel(byte[] buf, int offset, int dy, int x) {
        return offset >= dy && x >= this.getBpp() ? buf[offset + x - dy - this.getBpp()] : 0;
    }

    private static void dump(byte[] raw) {
        for (int i2 = 0; i2 < raw.length; ++i2) {
            System.out.print(raw[i2] + " ");
        }
        System.out.println();
    }

    public int getBpp() {
        return this.bpp;
    }

    public void setBpp(int newBpp) {
        this.bpp = newBpp;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int newHeight) {
        this.height = newHeight;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int newWidth) {
        this.width = newWidth;
    }

    public void encode(byte[] src, byte[] dest) {
        this.checkBufsiz(dest, src);
        int dy = this.getWidth() * this.getBpp();
        for (int y = 0; y < this.height; ++y) {
            int yoffset = y * dy;
            this.encodeLine(src, dest, dy, yoffset, dy, yoffset);
        }
    }

    public void decode(byte[] src, byte[] dest) {
        this.checkBufsiz(src, dest);
        int dy = this.width * this.bpp;
        for (int y = 0; y < this.height; ++y) {
            int yoffset = y * dy;
            this.decodeLine(src, dest, dy, yoffset, dy, yoffset);
        }
    }

    public static PredictorAlgorithm getFilter(int predictor) {
        PredictorAlgorithm filter;
        switch (predictor) {
            case 10: {
                filter = new None();
                break;
            }
            case 11: {
                filter = new Sub();
                break;
            }
            case 12: {
                filter = new Up();
                break;
            }
            case 13: {
                filter = new Average();
                break;
            }
            case 14: {
                filter = new Paeth();
                break;
            }
            case 15: {
                filter = new Optimum();
                break;
            }
            default: {
                filter = new None();
            }
        }
        return filter;
    }
}

