/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.predictor;

import org.apache.pdfbox.pdmodel.graphics.predictor.PredictorAlgorithm;

public class Paeth
extends PredictorAlgorithm {
    public int paethPredictor(int a2, int b2, int c2) {
        int p = a2 + b2 - c2;
        int pa = Math.abs(p - a2);
        int pb = Math.abs(p - b2);
        int pc = Math.abs(p - c2);
        if (pa <= pb && pa <= pc) {
            return a2;
        }
        if (pb <= pc) {
            return b2;
        }
        return c2;
    }

    public void encodeLine(byte[] src, byte[] dest, int srcDy, int srcOffset, int destDy, int destOffset) {
        int bpl = this.getWidth() * this.getBpp();
        for (int x = 0; x < bpl; ++x) {
            dest[x + destOffset] = (byte)(src[x + srcOffset] - this.paethPredictor(this.leftPixel(src, srcOffset, srcDy, x), this.abovePixel(src, srcOffset, srcDy, x), this.aboveLeftPixel(src, srcOffset, srcDy, x)));
        }
    }

    public void decodeLine(byte[] src, byte[] dest, int srcDy, int srcOffset, int destDy, int destOffset) {
        int bpl = this.getWidth() * this.getBpp();
        for (int x = 0; x < bpl; ++x) {
            dest[x + destOffset] = (byte)(src[x + srcOffset] + this.paethPredictor(this.leftPixel(dest, destOffset, destDy, x), this.abovePixel(dest, destOffset, destDy, x), this.aboveLeftPixel(dest, destOffset, destDy, x)));
        }
    }
}

