/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.optionalcontent;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.graphics.optionalcontent.PDOptionalContentGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDOptionalContentProperties
implements COSObjectable {
    private COSDictionary dict;

    public PDOptionalContentProperties() {
        this.dict = new COSDictionary();
        this.dict.setItem(COSName.OCGS, (COSBase)new COSArray());
        this.dict.setItem(COSName.D, (COSBase)new COSDictionary());
    }

    public PDOptionalContentProperties(COSDictionary props) {
        this.dict = props;
    }

    @Override
    public COSBase getCOSObject() {
        return this.dict;
    }

    private COSArray getOCGs() {
        COSArray ocgs = (COSArray)this.dict.getItem(COSName.OCGS);
        if (ocgs == null) {
            ocgs = new COSArray();
            this.dict.setItem(COSName.OCGS, (COSBase)ocgs);
        }
        return ocgs;
    }

    private COSDictionary getD() {
        COSDictionary d2 = (COSDictionary)this.dict.getDictionaryObject(COSName.D);
        if (d2 == null) {
            d2 = new COSDictionary();
            this.dict.setItem(COSName.D, (COSBase)d2);
        }
        return d2;
    }

    public PDOptionalContentGroup getGroup(String name) {
        COSArray ocgs = this.getOCGs();
        for (COSBase o2 : ocgs) {
            COSDictionary ocg = this.toDictionary(o2);
            String groupName = ocg.getString(COSName.NAME);
            if (!groupName.equals(name)) continue;
            return new PDOptionalContentGroup(ocg);
        }
        return null;
    }

    public void addGroup(PDOptionalContentGroup ocg) {
        COSArray ocgs = this.getOCGs();
        ocgs.add(ocg.getCOSObject());
        COSArray order = (COSArray)this.getD().getDictionaryObject(COSName.ORDER);
        if (order == null) {
            order = new COSArray();
            this.getD().setItem(COSName.ORDER, (COSBase)order);
        }
        order.add(ocg);
    }

    public Collection<PDOptionalContentGroup> getOptionalContentGroups() {
        ArrayList<PDOptionalContentGroup> coll = new ArrayList<PDOptionalContentGroup>();
        COSArray ocgs = this.getOCGs();
        for (COSBase base : ocgs) {
            COSObject obj = (COSObject)base;
            coll.add(new PDOptionalContentGroup((COSDictionary)obj.getObject()));
        }
        return coll;
    }

    public BaseState getBaseState() {
        COSDictionary d2 = this.getD();
        COSName name = (COSName)d2.getItem(COSName.BASE_STATE);
        return BaseState.valueOf(name);
    }

    public void setBaseState(BaseState state) {
        COSDictionary d2 = this.getD();
        d2.setItem(COSName.BASE_STATE, (COSBase)state.getName());
    }

    public String[] getGroupNames() {
        COSArray ocgs = (COSArray)this.dict.getDictionaryObject(COSName.OCGS);
        int size = ocgs.size();
        String[] groups = new String[size];
        for (int i2 = 0; i2 < size; ++i2) {
            COSBase obj = ocgs.get(i2);
            COSDictionary ocg = this.toDictionary(obj);
            groups[i2] = ocg.getString(COSName.NAME);
        }
        return groups;
    }

    public boolean hasGroup(String groupName) {
        String[] layers;
        for (String layer : layers = this.getGroupNames()) {
            if (!layer.equals(groupName)) continue;
            return true;
        }
        return false;
    }

    public boolean isGroupEnabled(String groupName) {
        BaseState baseState;
        COSArray off;
        COSDictionary d2 = this.getD();
        COSArray on = (COSArray)d2.getDictionaryObject(COSName.ON);
        if (on != null) {
            for (COSBase o2 : on) {
                COSDictionary group = this.toDictionary(o2);
                String name = group.getString(COSName.NAME);
                if (!name.equals(groupName)) continue;
                return true;
            }
        }
        if ((off = (COSArray)d2.getDictionaryObject(COSName.OFF)) != null) {
            for (COSBase o3 : off) {
                COSDictionary group = this.toDictionary(o3);
                String name = group.getString(COSName.NAME);
                if (!name.equals(groupName)) continue;
                return false;
            }
        }
        boolean enabled = !(baseState = this.getBaseState()).equals((Object)BaseState.OFF);
        return enabled;
    }

    private COSDictionary toDictionary(COSBase o2) {
        if (o2 instanceof COSObject) {
            return (COSDictionary)((COSObject)o2).getObject();
        }
        return (COSDictionary)o2;
    }

    public boolean setGroupEnabled(String groupName, boolean enable) {
        COSArray off;
        COSDictionary d2 = this.getD();
        COSArray on = (COSArray)d2.getDictionaryObject(COSName.ON);
        if (on == null) {
            on = new COSArray();
            d2.setItem(COSName.ON, (COSBase)on);
        }
        if ((off = (COSArray)d2.getDictionaryObject(COSName.OFF)) == null) {
            off = new COSArray();
            d2.setItem(COSName.OFF, (COSBase)off);
        }
        boolean found = false;
        if (enable) {
            for (COSBase o2 : off) {
                COSDictionary group = this.toDictionary(o2);
                String name = group.getString(COSName.NAME);
                if (!name.equals(groupName)) continue;
                off.remove(group);
                on.add(group);
                found = true;
                break;
            }
        } else {
            for (COSBase o3 : on) {
                COSDictionary group = this.toDictionary(o3);
                String name = group.getString(COSName.NAME);
                if (!name.equals(groupName)) continue;
                on.remove(group);
                off.add(group);
                found = true;
                break;
            }
        }
        if (!found) {
            PDOptionalContentGroup ocg = this.getGroup(groupName);
            if (enable) {
                on.add(ocg.getCOSObject());
            } else {
                off.add(ocg.getCOSObject());
            }
        }
        return found;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BaseState {
        ON(COSName.ON),
        OFF(COSName.OFF),
        UNCHANGED(COSName.UNCHANGED);

        private COSName name;

        private BaseState(COSName value) {
            this.name = value;
        }

        public COSName getName() {
            return this.name;
        }

        public static BaseState valueOf(COSName state) {
            if (state == null) {
                return ON;
            }
            return BaseState.valueOf(state.getName().toUpperCase());
        }
    }
}

