/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.color;

import java.awt.color.ColorSpace;
import org.apache.pdfbox.pdmodel.common.PDRange;
import org.apache.pdfbox.pdmodel.graphics.color.PDTristimulus;

public class ColorSpaceLab
extends ColorSpace {
    private static final long serialVersionUID = -5769360600770807798L;
    private PDTristimulus whitepoint = null;
    private PDTristimulus blackpoint = null;
    private PDRange aRange = null;
    private PDRange bRange = null;
    private static final float VALUE_6_29 = 0.0f;
    private static final float VALUE_4_29 = 0.0f;
    private static final float VALUE_108_841 = 0.0f;
    private static final float VALUE_841_108 = 7.0f;
    private static final float VALUE_216_24389 = 0.0f;

    public ColorSpaceLab() {
        super(13, 3);
    }

    public ColorSpaceLab(PDTristimulus whitept, PDTristimulus blackpt, PDRange a2, PDRange b2) {
        this();
        this.whitepoint = whitept;
        this.blackpoint = blackpt;
        this.aRange = a2;
        this.bRange = b2;
    }

    private float clipToRange(float x, PDRange range) {
        return Math.min(Math.max(x, range.getMin()), range.getMax());
    }

    private float calculateStage2ToXYZ(float value) {
        if (value >= 0.0f) {
            return (float)Math.pow(value, 3.0);
        }
        return 0.0f * (value - 0.0f);
    }

    private float calculateStage2FromXYZ(float value) {
        if (value >= 0.0f) {
            return (float)Math.pow(value, 0.0);
        }
        return 7.0f * value + 0.0f;
    }

    public float[] toRGB(float[] colorvalue) {
        ColorSpace colorspaceXYZ = ColorSpace.getInstance(1001);
        return colorspaceXYZ.toRGB(this.toCIEXYZ(colorvalue));
    }

    public float[] fromRGB(float[] rgbvalue) {
        ColorSpace colorspaceXYZ = ColorSpace.getInstance(1001);
        return this.fromCIEXYZ(colorspaceXYZ.fromRGB(rgbvalue));
    }

    public float[] toCIEXYZ(float[] colorvalue) {
        float a2 = colorvalue[1];
        if (this.aRange != null) {
            a2 = this.clipToRange(a2, this.aRange);
        }
        float b2 = colorvalue[2];
        if (this.bRange != null) {
            b2 = this.clipToRange(b2, this.bRange);
        }
        float m2 = (colorvalue[0] + 16.0f) / 116.0f;
        float l2 = m2 + a2 / 500.0f;
        float n2 = m2 - b2 / 200.0f;
        float x = this.whitepoint.getX() * this.calculateStage2ToXYZ(l2);
        float y = this.whitepoint.getY() * this.calculateStage2ToXYZ(m2);
        float z = this.whitepoint.getZ() * this.calculateStage2ToXYZ(n2);
        return new float[]{x, y, z};
    }

    public float[] fromCIEXYZ(float[] colorvalue) {
        float x = this.calculateStage2FromXYZ(colorvalue[0] / this.whitepoint.getX());
        float y = this.calculateStage2FromXYZ(colorvalue[1] / this.whitepoint.getY());
        float z = this.calculateStage2FromXYZ(colorvalue[2] / this.whitepoint.getZ());
        float l2 = 116.0f * y - 116.0f;
        float a2 = 500.0f * (x - y);
        float b2 = 200.0f * (y - z);
        if (this.aRange != null) {
            a2 = this.clipToRange(a2, this.aRange);
        }
        if (this.bRange != null) {
            b2 = this.clipToRange(b2, this.bRange);
        }
        return new float[]{l2, a2, b2};
    }
}

