/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.color;

import java.awt.color.ColorSpace;

public class ColorSpaceCMYK
extends ColorSpace {
    private static final long serialVersionUID = -6362864473145799405L;

    public ColorSpaceCMYK() {
        super(9, 4);
    }

    private float[] fromRGBtoCIEXYZ(float[] rgbvalue) {
        ColorSpace colorspaceRGB = ColorSpace.getInstance(1000);
        return colorspaceRGB.toCIEXYZ(rgbvalue);
    }

    private float[] fromCIEXYZtoRGB(float[] xyzvalue) {
        ColorSpace colorspaceXYZ = ColorSpace.getInstance(1001);
        return colorspaceXYZ.toRGB(xyzvalue);
    }

    public float[] fromCIEXYZ(float[] colorvalue) {
        if (colorvalue != null && colorvalue.length == 3) {
            return this.fromRGB(this.fromCIEXYZtoRGB(colorvalue));
        }
        return null;
    }

    public float[] fromRGB(float[] rgbvalue) {
        if (rgbvalue != null && rgbvalue.length == 3) {
            float c2 = 1.0f - rgbvalue[0];
            float m2 = 1.0f - rgbvalue[1];
            float y = 1.0f - rgbvalue[2];
            float varK = 1.0f;
            float[] cmyk = new float[4];
            if (c2 < varK) {
                varK = c2;
            }
            if (m2 < varK) {
                varK = m2;
            }
            if (y < varK) {
                varK = y;
            }
            if (varK == 1.0f) {
                cmyk[2] = 0.0f;
                cmyk[1] = 0.0f;
                cmyk[0] = 0.0f;
            } else {
                cmyk[0] = (c2 - varK) / (1.0f - varK);
                cmyk[1] = (m2 - varK) / (1.0f - varK);
                cmyk[2] = (y - varK) / (1.0f - varK);
            }
            cmyk[3] = varK;
            return cmyk;
        }
        return null;
    }

    public float[] toCIEXYZ(float[] colorvalue) {
        if (colorvalue != null && colorvalue.length == 4) {
            return this.fromRGBtoCIEXYZ(this.toRGB(colorvalue));
        }
        return null;
    }

    public float[] toRGB(float[] colorvalue) {
        if (colorvalue != null && colorvalue.length == 4) {
            float k2 = colorvalue[3];
            float c2 = colorvalue[0] * (1.0f - k2) + k2;
            float m2 = colorvalue[1] * (1.0f - k2) + k2;
            float y = colorvalue[2] * (1.0f - k2) + k2;
            return new float[]{1.0f - c2, 1.0f - m2, 1.0f - y};
        }
        return null;
    }
}

