/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.fdf;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDTextStream;
import org.apache.pdfbox.pdmodel.fdf.FDFIconFit;
import org.apache.pdfbox.pdmodel.fdf.FDFNamedPageReference;
import org.apache.pdfbox.pdmodel.fdf.FDFOptionElement;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionFactory;
import org.apache.pdfbox.pdmodel.interactive.action.PDAdditionalActions;
import org.apache.pdfbox.pdmodel.interactive.action.type.PDAction;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.util.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FDFField
implements COSObjectable {
    private COSDictionary field;

    public FDFField() {
        this.field = new COSDictionary();
    }

    public FDFField(COSDictionary f2) {
        this.field = f2;
    }

    public FDFField(Element fieldXML) throws IOException {
        this();
        this.setPartialFieldName(fieldXML.getAttribute("name"));
        NodeList nodeList = fieldXML.getChildNodes();
        ArrayList<FDFField> kids = new ArrayList<FDFField>();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Node node = nodeList.item(i2);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            if (child.getTagName().equals("value")) {
                this.setValue(XMLUtil.getNodeValue(child));
                continue;
            }
            if (child.getTagName().equals("value-richtext")) {
                this.setRichText(new PDTextStream(XMLUtil.getNodeValue(child)));
                continue;
            }
            if (!child.getTagName().equals("field")) continue;
            kids.add(new FDFField(child));
        }
        if (kids.size() > 0) {
            this.setKids(kids);
        }
    }

    public void writeXML(Writer output) throws IOException {
        List<FDFField> kids;
        PDTextStream rt;
        output.write("<field name=\"" + this.getPartialFieldName() + "\">\n");
        Object value = this.getValue();
        if (value != null) {
            output.write("<value>" + value + "</value>\n");
        }
        if ((rt = this.getRichText()) != null) {
            output.write("<value-richtext>" + rt.getAsString() + "</value-richtext>\n");
        }
        if ((kids = this.getKids()) != null) {
            for (int i2 = 0; i2 < kids.size(); ++i2) {
                kids.get(i2).writeXML(output);
            }
        }
        output.write("</field>\n");
    }

    @Override
    public COSBase getCOSObject() {
        return this.field;
    }

    public COSDictionary getCOSDictionary() {
        return this.field;
    }

    public List<FDFField> getKids() {
        COSArray kids = (COSArray)this.field.getDictionaryObject(COSName.KIDS);
        COSArrayList retval = null;
        if (kids != null) {
            ArrayList<FDFField> actuals = new ArrayList<FDFField>();
            for (int i2 = 0; i2 < kids.size(); ++i2) {
                actuals.add(new FDFField((COSDictionary)kids.getObject(i2)));
            }
            retval = new COSArrayList(actuals, kids);
        }
        return retval;
    }

    public void setKids(List<FDFField> kids) {
        this.field.setItem(COSName.KIDS, (COSBase)COSArrayList.converterToCOSArray(kids));
    }

    public String getPartialFieldName() {
        return this.field.getString(COSName.T);
    }

    public void setPartialFieldName(String partial) {
        this.field.setString(COSName.T, partial);
    }

    public Object getValue() throws IOException {
        Object retval = null;
        COSBase value = this.field.getDictionaryObject(COSName.V);
        if (value instanceof COSName) {
            retval = ((COSName)value).getName();
        } else if (value instanceof COSArray) {
            retval = COSArrayList.convertCOSStringCOSArrayToList((COSArray)value);
        } else if (value instanceof COSString || value instanceof COSStream) {
            retval = PDTextStream.createTextStream(value);
        } else if (value != null) {
            throw new IOException("Error:Unknown type for field import" + value);
        }
        return retval;
    }

    public void setValue(Object value) throws IOException {
        COSBase cos = null;
        if (value instanceof List) {
            cos = COSArrayList.convertStringListToCOSStringCOSArray((List)value);
        } else if (value instanceof String) {
            cos = COSName.getPDFName((String)value);
        } else if (value instanceof COSObjectable) {
            cos = ((COSObjectable)value).getCOSObject();
        } else if (value != null) {
            throw new IOException("Error:Unknown type for field import" + value);
        }
        this.field.setItem(COSName.V, cos);
    }

    public Integer getFieldFlags() {
        Integer retval = null;
        COSNumber ff = (COSNumber)this.field.getDictionaryObject(COSName.FF);
        if (ff != null) {
            retval = new Integer(ff.intValue());
        }
        return retval;
    }

    public void setFieldFlags(Integer ff) {
        COSInteger value = null;
        if (ff != null) {
            value = COSInteger.get(ff.intValue());
        }
        this.field.setItem(COSName.FF, (COSBase)value);
    }

    public void setFieldFlags(int ff) {
        this.field.setInt(COSName.FF, ff);
    }

    public Integer getSetFieldFlags() {
        Integer retval = null;
        COSNumber ff = (COSNumber)this.field.getDictionaryObject(COSName.SET_FF);
        if (ff != null) {
            retval = new Integer(ff.intValue());
        }
        return retval;
    }

    public void setSetFieldFlags(Integer ff) {
        COSInteger value = null;
        if (ff != null) {
            value = COSInteger.get(ff.intValue());
        }
        this.field.setItem(COSName.SET_FF, (COSBase)value);
    }

    public void setSetFieldFlags(int ff) {
        this.field.setInt(COSName.SET_FF, ff);
    }

    public Integer getClearFieldFlags() {
        Integer retval = null;
        COSNumber ff = (COSNumber)this.field.getDictionaryObject(COSName.CLR_FF);
        if (ff != null) {
            retval = new Integer(ff.intValue());
        }
        return retval;
    }

    public void setClearFieldFlags(Integer ff) {
        COSInteger value = null;
        if (ff != null) {
            value = COSInteger.get(ff.intValue());
        }
        this.field.setItem(COSName.CLR_FF, (COSBase)value);
    }

    public void setClearFieldFlags(int ff) {
        this.field.setInt(COSName.CLR_FF, ff);
    }

    public Integer getWidgetFieldFlags() {
        Integer retval = null;
        COSNumber f2 = (COSNumber)this.field.getDictionaryObject("F");
        if (f2 != null) {
            retval = new Integer(f2.intValue());
        }
        return retval;
    }

    public void setWidgetFieldFlags(Integer f2) {
        COSInteger value = null;
        if (f2 != null) {
            value = COSInteger.get(f2.intValue());
        }
        this.field.setItem(COSName.F, (COSBase)value);
    }

    public void setWidgetFieldFlags(int f2) {
        this.field.setInt(COSName.F, f2);
    }

    public Integer getSetWidgetFieldFlags() {
        Integer retval = null;
        COSNumber ff = (COSNumber)this.field.getDictionaryObject(COSName.SET_F);
        if (ff != null) {
            retval = new Integer(ff.intValue());
        }
        return retval;
    }

    public void setSetWidgetFieldFlags(Integer ff) {
        COSInteger value = null;
        if (ff != null) {
            value = COSInteger.get(ff.intValue());
        }
        this.field.setItem(COSName.SET_F, (COSBase)value);
    }

    public void setSetWidgetFieldFlags(int ff) {
        this.field.setInt(COSName.SET_F, ff);
    }

    public Integer getClearWidgetFieldFlags() {
        Integer retval = null;
        COSNumber ff = (COSNumber)this.field.getDictionaryObject(COSName.CLR_F);
        if (ff != null) {
            retval = new Integer(ff.intValue());
        }
        return retval;
    }

    public void setClearWidgetFieldFlags(Integer ff) {
        COSInteger value = null;
        if (ff != null) {
            value = COSInteger.get(ff.intValue());
        }
        this.field.setItem(COSName.CLR_F, (COSBase)value);
    }

    public void setClearWidgetFieldFlags(int ff) {
        this.field.setInt(COSName.CLR_F, ff);
    }

    public PDAppearanceDictionary getAppearanceDictionary() {
        PDAppearanceDictionary retval = null;
        COSDictionary dict = (COSDictionary)this.field.getDictionaryObject(COSName.AP);
        if (dict != null) {
            retval = new PDAppearanceDictionary(dict);
        }
        return retval;
    }

    public void setAppearanceDictionary(PDAppearanceDictionary ap) {
        this.field.setItem(COSName.AP, (COSObjectable)ap);
    }

    public FDFNamedPageReference getAppearanceStreamReference() {
        FDFNamedPageReference retval = null;
        COSDictionary ref = (COSDictionary)this.field.getDictionaryObject(COSName.AP_REF);
        if (ref != null) {
            retval = new FDFNamedPageReference(ref);
        }
        return retval;
    }

    public void setAppearanceStreamReference(FDFNamedPageReference ref) {
        this.field.setItem(COSName.AP_REF, (COSObjectable)ref);
    }

    public FDFIconFit getIconFit() {
        FDFIconFit retval = null;
        COSDictionary dic = (COSDictionary)this.field.getDictionaryObject("IF");
        if (dic != null) {
            retval = new FDFIconFit(dic);
        }
        return retval;
    }

    public void setIconFit(FDFIconFit fit) {
        this.field.setItem("IF", (COSObjectable)fit);
    }

    public List getOptions() {
        COSArrayList retval = null;
        COSArray array = (COSArray)this.field.getDictionaryObject(COSName.OPT);
        if (array != null) {
            ArrayList<Object> objects = new ArrayList<Object>();
            for (int i2 = 0; i2 < array.size(); ++i2) {
                COSBase next = array.getObject(i2);
                if (next instanceof COSString) {
                    objects.add(((COSString)next).getString());
                    continue;
                }
                COSArray value = (COSArray)next;
                objects.add(new FDFOptionElement(value));
            }
            retval = new COSArrayList(objects, array);
        }
        return retval;
    }

    public void setOptions(List options) {
        COSArray value = COSArrayList.converterToCOSArray(options);
        this.field.setItem(COSName.OPT, (COSBase)value);
    }

    public PDAction getAction() {
        return PDActionFactory.createAction((COSDictionary)this.field.getDictionaryObject(COSName.A));
    }

    public void setAction(PDAction a2) {
        this.field.setItem(COSName.A, (COSObjectable)a2);
    }

    public PDAdditionalActions getAdditionalActions() {
        PDAdditionalActions retval = null;
        COSDictionary dict = (COSDictionary)this.field.getDictionaryObject(COSName.AA);
        if (dict != null) {
            retval = new PDAdditionalActions(dict);
        }
        return retval;
    }

    public void setAdditionalActions(PDAdditionalActions aa) {
        this.field.setItem(COSName.AA, (COSObjectable)aa);
    }

    public PDTextStream getRichText() {
        COSBase rv = this.field.getDictionaryObject(COSName.RV);
        return PDTextStream.createTextStream(rv);
    }

    public void setRichText(PDTextStream rv) {
        this.field.setItem(COSName.RV, (COSObjectable)rv);
    }
}

