/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.documentinterchange.taggedpdf;

import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDAttributeObject;
import org.apache.pdfbox.pdmodel.documentinterchange.taggedpdf.PDFourColours;
import org.apache.pdfbox.pdmodel.graphics.color.PDGamma;

public abstract class PDStandardAttributeObject
extends PDAttributeObject {
    protected static final float UNSPECIFIED = -1.0f;

    public PDStandardAttributeObject() {
    }

    public PDStandardAttributeObject(COSDictionary dictionary) {
        super(dictionary);
    }

    public boolean isSpecified(String name) {
        return this.getCOSDictionary().getDictionaryObject(name) != null;
    }

    protected String getString(String name) {
        return this.getCOSDictionary().getString(name);
    }

    protected void setString(String name, String value) {
        COSBase oldBase = this.getCOSDictionary().getDictionaryObject(name);
        this.getCOSDictionary().setString(name, value);
        COSBase newBase = this.getCOSDictionary().getDictionaryObject(name);
        this.potentiallyNotifyChanged(oldBase, newBase);
    }

    protected String[] getArrayOfString(String name) {
        COSBase v = this.getCOSDictionary().getDictionaryObject(name);
        if (v instanceof COSArray) {
            COSArray array = (COSArray)v;
            String[] strings = new String[array.size()];
            for (int i2 = 0; i2 < array.size(); ++i2) {
                strings[i2] = ((COSName)array.getObject(i2)).getName();
            }
            return strings;
        }
        return null;
    }

    protected void setArrayOfString(String name, String[] values) {
        COSBase oldBase = this.getCOSDictionary().getDictionaryObject(name);
        COSArray array = new COSArray();
        for (int i2 = 0; i2 < values.length; ++i2) {
            array.add(new COSString(values[i2]));
        }
        this.getCOSDictionary().setItem(name, (COSBase)array);
        COSBase newBase = this.getCOSDictionary().getDictionaryObject(name);
        this.potentiallyNotifyChanged(oldBase, newBase);
    }

    protected String getName(String name) {
        return this.getCOSDictionary().getNameAsString(name);
    }

    protected String getName(String name, String defaultValue) {
        return this.getCOSDictionary().getNameAsString(name, defaultValue);
    }

    protected Object getNameOrArrayOfName(String name, String defaultValue) {
        COSBase v = this.getCOSDictionary().getDictionaryObject(name);
        if (v instanceof COSArray) {
            COSArray array = (COSArray)v;
            String[] names = new String[array.size()];
            for (int i2 = 0; i2 < array.size(); ++i2) {
                COSBase item = array.getObject(i2);
                if (!(item instanceof COSName)) continue;
                names[i2] = ((COSName)item).getName();
            }
            return names;
        }
        if (v instanceof COSName) {
            return ((COSName)v).getName();
        }
        return defaultValue;
    }

    protected void setName(String name, String value) {
        COSBase oldBase = this.getCOSDictionary().getDictionaryObject(name);
        this.getCOSDictionary().setName(name, value);
        COSBase newBase = this.getCOSDictionary().getDictionaryObject(name);
        this.potentiallyNotifyChanged(oldBase, newBase);
    }

    protected void setArrayOfName(String name, String[] values) {
        COSBase oldBase = this.getCOSDictionary().getDictionaryObject(name);
        COSArray array = new COSArray();
        for (int i2 = 0; i2 < values.length; ++i2) {
            array.add(COSName.getPDFName(values[i2]));
        }
        this.getCOSDictionary().setItem(name, (COSBase)array);
        COSBase newBase = this.getCOSDictionary().getDictionaryObject(name);
        this.potentiallyNotifyChanged(oldBase, newBase);
    }

    protected Object getNumberOrName(String name, String defaultValue) {
        COSBase value = this.getCOSDictionary().getDictionaryObject(name);
        if (value instanceof COSNumber) {
            return Float.valueOf(((COSNumber)value).floatValue());
        }
        if (value instanceof COSName) {
            return ((COSName)value).getName();
        }
        return defaultValue;
    }

    protected int getInteger(String name, int defaultValue) {
        return this.getCOSDictionary().getInt(name, defaultValue);
    }

    protected void setInteger(String name, int value) {
        COSBase oldBase = this.getCOSDictionary().getDictionaryObject(name);
        this.getCOSDictionary().setInt(name, value);
        COSBase newBase = this.getCOSDictionary().getDictionaryObject(name);
        this.potentiallyNotifyChanged(oldBase, newBase);
    }

    protected float getNumber(String name, float defaultValue) {
        return this.getCOSDictionary().getFloat(name, defaultValue);
    }

    protected float getNumber(String name) {
        return this.getCOSDictionary().getFloat(name);
    }

    protected Object getNumberOrArrayOfNumber(String name, float defaultValue) {
        COSBase v = this.getCOSDictionary().getDictionaryObject(name);
        if (v instanceof COSArray) {
            COSArray array = (COSArray)v;
            float[] values = new float[array.size()];
            for (int i2 = 0; i2 < array.size(); ++i2) {
                COSBase item = array.getObject(i2);
                if (!(item instanceof COSNumber)) continue;
                values[i2] = ((COSNumber)item).floatValue();
            }
            return values;
        }
        if (v instanceof COSNumber) {
            return Float.valueOf(((COSNumber)v).floatValue());
        }
        if (defaultValue == -1.0f) {
            return null;
        }
        return Float.valueOf(defaultValue);
    }

    protected void setNumber(String name, float value) {
        COSBase oldBase = this.getCOSDictionary().getDictionaryObject(name);
        this.getCOSDictionary().setFloat(name, value);
        COSBase newBase = this.getCOSDictionary().getDictionaryObject(name);
        this.potentiallyNotifyChanged(oldBase, newBase);
    }

    protected void setNumber(String name, int value) {
        COSBase oldBase = this.getCOSDictionary().getDictionaryObject(name);
        this.getCOSDictionary().setInt(name, value);
        COSBase newBase = this.getCOSDictionary().getDictionaryObject(name);
        this.potentiallyNotifyChanged(oldBase, newBase);
    }

    protected void setArrayOfNumber(String name, float[] values) {
        COSArray array = new COSArray();
        for (int i2 = 0; i2 < values.length; ++i2) {
            array.add(new COSFloat(values[i2]));
        }
        COSBase oldBase = this.getCOSDictionary().getDictionaryObject(name);
        this.getCOSDictionary().setItem(name, (COSBase)array);
        COSBase newBase = this.getCOSDictionary().getDictionaryObject(name);
        this.potentiallyNotifyChanged(oldBase, newBase);
    }

    protected PDGamma getColor(String name) {
        COSArray c2 = (COSArray)this.getCOSDictionary().getDictionaryObject(name);
        if (c2 != null) {
            return new PDGamma(c2);
        }
        return null;
    }

    protected Object getColorOrFourColors(String name) {
        COSArray array = (COSArray)this.getCOSDictionary().getDictionaryObject(name);
        if (array == null) {
            return null;
        }
        if (array.size() == 3) {
            return new PDGamma(array);
        }
        if (array.size() == 4) {
            return new PDFourColours(array);
        }
        return null;
    }

    protected void setColor(String name, PDGamma value) {
        COSBase oldValue = this.getCOSDictionary().getDictionaryObject(name);
        this.getCOSDictionary().setItem(name, (COSObjectable)value);
        COSBase newValue = value == null ? null : value.getCOSObject();
        this.potentiallyNotifyChanged(oldValue, newValue);
    }

    protected void setFourColors(String name, PDFourColours value) {
        COSBase oldValue = this.getCOSDictionary().getDictionaryObject(name);
        this.getCOSDictionary().setItem(name, (COSObjectable)value);
        COSBase newValue = value == null ? null : value.getCOSObject();
        this.potentiallyNotifyChanged(oldValue, newValue);
    }
}

