/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.common.function;

import java.io.IOException;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.pdmodel.common.PDRange;
import org.apache.pdfbox.pdmodel.common.function.PDFunction;
import org.apache.pdfbox.pdmodel.common.function.type4.ExecutionContext;
import org.apache.pdfbox.pdmodel.common.function.type4.InstructionSequence;
import org.apache.pdfbox.pdmodel.common.function.type4.InstructionSequenceBuilder;
import org.apache.pdfbox.pdmodel.common.function.type4.Operators;

public class PDFunctionType4
extends PDFunction {
    private static final Operators OPERATORS = new Operators();
    private final InstructionSequence instructions = InstructionSequenceBuilder.parse(this.getPDStream().getInputStreamAsString());

    public PDFunctionType4(COSBase functionStream) throws IOException {
        super(functionStream);
    }

    public int getFunctionType() {
        return 4;
    }

    public float[] eval(float[] input) throws IOException {
        ExecutionContext context = new ExecutionContext(OPERATORS);
        for (int i2 = 0; i2 < input.length; ++i2) {
            PDRange domain = this.getDomainForInput(i2);
            float value = this.clipToRange(input[i2], domain.getMin(), domain.getMax());
            context.getStack().push(Float.valueOf(value));
        }
        this.instructions.execute(context);
        int numberOfOutputValues = this.getNumberOfOutputParameters();
        int numberOfActualOutputValues = context.getStack().size();
        if (numberOfActualOutputValues < numberOfOutputValues) {
            throw new IllegalStateException("The type 4 function returned " + numberOfActualOutputValues + " values but the Range entry indicates that " + numberOfOutputValues + " values be returned.");
        }
        float[] outputValues = new float[numberOfOutputValues];
        for (int i3 = numberOfOutputValues - 1; i3 >= 0; --i3) {
            PDRange range = this.getRangeForOutput(i3);
            outputValues[i3] = context.popReal();
            outputValues[i3] = this.clipToRange(outputValues[i3], range.getMin(), range.getMax());
        }
        return outputValues;
    }
}

