/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.common.function;

import java.io.IOException;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.PDRange;
import org.apache.pdfbox.pdmodel.common.function.PDFunction;

public class PDFunctionType0
extends PDFunction {
    private static final Log LOG = LogFactory.getLog(PDFunctionType0.class);
    private COSArray encode = null;
    private COSArray decode = null;
    private COSArray size = null;
    private int[][] samples = null;

    public PDFunctionType0(COSBase function) {
        super(function);
    }

    public int getFunctionType() {
        return 0;
    }

    public COSArray getSize() {
        if (this.size == null) {
            this.size = (COSArray)this.getDictionary().getDictionaryObject(COSName.SIZE);
        }
        return this.size;
    }

    public int[][] getSamples() {
        if (this.samples == null) {
            int arraySize = 1;
            int numberOfInputValues = this.getNumberOfInputParameters();
            int numberOfOutputValues = this.getNumberOfOutputParameters();
            COSArray sizes = this.getSize();
            for (int i2 = 0; i2 < numberOfInputValues; ++i2) {
                arraySize *= sizes.getInt(i2);
            }
            this.samples = new int[arraySize][numberOfOutputValues];
            int bitsPerSample = this.getBitsPerSample();
            int index = 0;
            try {
                MemoryCacheImageInputStream mciis = new MemoryCacheImageInputStream(this.getPDStream().createInputStream());
                for (int i3 = 0; i3 < arraySize; ++i3) {
                    for (int k2 = 0; k2 < numberOfOutputValues; ++k2) {
                        this.samples[index][k2] = (int)mciis.readBits(bitsPerSample);
                    }
                    ++index;
                }
                mciis.close();
            }
            catch (IOException exception) {
                LOG.error("IOException while reading the sample values of this function.", exception);
            }
        }
        return this.samples;
    }

    public int getBitsPerSample() {
        return this.getDictionary().getInt(COSName.BITS_PER_SAMPLE);
    }

    public int getOrder() {
        return this.getDictionary().getInt(COSName.ORDER, 1);
    }

    public void setBitsPerSample(int bps) {
        this.getDictionary().setInt(COSName.BITS_PER_SAMPLE, bps);
    }

    private COSArray getEncodeValues() {
        if (this.encode == null) {
            this.encode = (COSArray)this.getDictionary().getDictionaryObject(COSName.ENCODE);
            if (this.encode == null) {
                this.encode = new COSArray();
                COSArray sizeValues = this.getSize();
                int sizeValuesSize = sizeValues.size();
                for (int i2 = 0; i2 < sizeValuesSize; ++i2) {
                    this.encode.add(COSInteger.ZERO);
                    this.encode.add(COSInteger.get(sizeValues.getInt(i2) - 1));
                }
            }
        }
        return this.encode;
    }

    private COSArray getDecodeValues() {
        if (this.decode == null) {
            this.decode = (COSArray)this.getDictionary().getDictionaryObject(COSName.DECODE);
            if (this.decode == null) {
                this.decode = this.getRangeValues();
            }
        }
        return this.decode;
    }

    public PDRange getEncodeForParameter(int paramNum) {
        PDRange retval = null;
        COSArray encodeValues = this.getEncodeValues();
        if (encodeValues != null && encodeValues.size() >= paramNum * 2 + 1) {
            retval = new PDRange(encodeValues, paramNum);
        }
        return retval;
    }

    public void setEncodeValues(COSArray encodeValues) {
        this.encode = encodeValues;
        this.getDictionary().setItem(COSName.ENCODE, (COSBase)encodeValues);
    }

    public PDRange getDecodeForParameter(int paramNum) {
        PDRange retval = null;
        COSArray decodeValues = this.getDecodeValues();
        if (decodeValues != null && decodeValues.size() >= paramNum * 2 + 1) {
            retval = new PDRange(decodeValues, paramNum);
        }
        return retval;
    }

    public void setDecodeValues(COSArray decodeValues) {
        this.decode = decodeValues;
        this.getDictionary().setItem(COSName.DECODE, (COSBase)decodeValues);
    }

    private int calcSampleIndex(int[] vector) {
        int i2;
        float[] sizeValues = this.getSize().toFloatArray();
        int index = 0;
        int sizeProduct = 1;
        int dimension = vector.length;
        for (i2 = dimension - 2; i2 >= 0; --i2) {
            sizeProduct = (int)((float)sizeProduct * sizeValues[i2]);
        }
        for (i2 = dimension - 1; i2 >= 0; --i2) {
            index += sizeProduct * vector[i2];
            if (i2 - 1 < 0) continue;
            sizeProduct = (int)((float)sizeProduct / sizeValues[i2 - 1]);
        }
        return index;
    }

    public float[] eval(float[] input) throws IOException {
        float[] sizeValues = this.getSize().toFloatArray();
        int bitsPerSample = this.getBitsPerSample();
        float maxSample = (float)(Math.pow(2.0, bitsPerSample) - 1.0);
        int numberOfInputValues = input.length;
        int numberOfOutputValues = this.getNumberOfOutputParameters();
        int[] inputPrev = new int[numberOfInputValues];
        int[] inputNext = new int[numberOfInputValues];
        for (int i2 = 0; i2 < numberOfInputValues; ++i2) {
            PDRange domain = this.getDomainForInput(i2);
            PDRange encodeValues = this.getEncodeForParameter(i2);
            input[i2] = this.clipToRange(input[i2], domain.getMin(), domain.getMax());
            input[i2] = this.interpolate(input[i2], domain.getMin(), domain.getMax(), encodeValues.getMin(), encodeValues.getMax());
            input[i2] = this.clipToRange(input[i2], 0.0f, sizeValues[i2] - 1.0f);
            inputPrev[i2] = (int)Math.floor(input[i2]);
            inputNext[i2] = (int)Math.ceil(input[i2]);
        }
        float[] outputValues = new Rinterpol(input, inputPrev, inputNext).rinterpolate();
        for (int i3 = 0; i3 < numberOfOutputValues; ++i3) {
            PDRange range = this.getRangeForOutput(i3);
            PDRange decodeValues = this.getDecodeForParameter(i3);
            outputValues[i3] = this.interpolate(outputValues[i3], 0.0f, maxSample, decodeValues.getMin(), decodeValues.getMax());
            outputValues[i3] = this.clipToRange(outputValues[i3], range.getMin(), range.getMax());
        }
        return outputValues;
    }

    class Rinterpol {
        final float[] in;
        final int[] inPrev;
        final int[] inNext;
        final int numberOfInputValues;
        final int numberOfOutputValues;

        public Rinterpol(float[] input, int[] inputPrev, int[] inputNext) {
            this.numberOfOutputValues = PDFunctionType0.this.getNumberOfOutputParameters();
            this.in = input;
            this.inPrev = inputPrev;
            this.inNext = inputNext;
            this.numberOfInputValues = input.length;
        }

        public float[] rinterpolate() {
            return this.rinterpol(new int[this.numberOfInputValues], 0);
        }

        private float[] rinterpol(int[] coord, int step) {
            float[] resultSample = new float[this.numberOfOutputValues];
            if (step == this.in.length - 1) {
                if (this.inPrev[step] == this.inNext[step]) {
                    coord[step] = this.inPrev[step];
                    int[] tmpSample = PDFunctionType0.this.getSamples()[PDFunctionType0.this.calcSampleIndex(coord)];
                    for (int i2 = 0; i2 < this.numberOfOutputValues; ++i2) {
                        resultSample[i2] = tmpSample[i2];
                    }
                    return resultSample;
                }
                coord[step] = this.inPrev[step];
                int[] sample1 = PDFunctionType0.this.getSamples()[PDFunctionType0.this.calcSampleIndex(coord)];
                coord[step] = this.inNext[step];
                int[] sample2 = PDFunctionType0.this.getSamples()[PDFunctionType0.this.calcSampleIndex(coord)];
                for (int i3 = 0; i3 < this.numberOfOutputValues; ++i3) {
                    resultSample[i3] = PDFunctionType0.this.interpolate(this.in[step], this.inPrev[step], this.inNext[step], sample1[i3], sample2[i3]);
                }
                return resultSample;
            }
            if (this.inPrev[step] == this.inNext[step]) {
                coord[step] = this.inPrev[step];
                return this.rinterpol(coord, step + 1);
            }
            coord[step] = this.inPrev[step];
            float[] sample1 = this.rinterpol(coord, step + 1);
            coord[step] = this.inNext[step];
            float[] sample2 = this.rinterpol(coord, step + 1);
            for (int i4 = 0; i4 < this.numberOfOutputValues; ++i4) {
                resultSample[i4] = PDFunctionType0.this.interpolate(this.in[step], this.inPrev[step], this.inNext[step], sample1[i4], sample2[i4]);
            }
            return resultSample;
        }
    }
}

