/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.common;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.ICOSVisitor;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.io.RandomAccess;
import org.apache.pdfbox.pdfparser.PDFStreamParser;
import org.apache.pdfbox.pdmodel.common.PDStream;

public class COSStreamArray
extends COSStream {
    private COSArray streams;
    private COSStream firstStream;

    public COSStreamArray(COSArray array) {
        super(new COSDictionary(), null);
        this.streams = array;
        if (array.size() > 0) {
            this.firstStream = (COSStream)array.getObject(0);
        }
    }

    public COSBase get(int index) {
        return this.streams.get(index);
    }

    public int getStreamCount() {
        return this.streams.size();
    }

    public RandomAccess getScratchFile() {
        return this.firstStream.getScratchFile();
    }

    public COSBase getItem(COSName key) {
        return this.firstStream.getItem(key);
    }

    public COSBase getDictionaryObject(COSName key) {
        return this.firstStream.getDictionaryObject(key);
    }

    public String toString() {
        return "COSStream{}";
    }

    public List getStreamTokens() throws IOException {
        List<Object> retval = null;
        if (this.streams.size() > 0) {
            PDFStreamParser parser = new PDFStreamParser(this);
            parser.parse();
            retval = parser.getTokens();
        } else {
            retval = new ArrayList();
        }
        return retval;
    }

    public COSDictionary getDictionary() {
        return this.firstStream;
    }

    public InputStream getFilteredStream() throws IOException {
        throw new IOException("Error: Not allowed to get filtered stream from array of streams.");
    }

    public InputStream getUnfilteredStream() throws IOException {
        Vector<InputStream> inputStreams = new Vector<InputStream>();
        byte[] inbetweenStreamBytes = "\n".getBytes("ISO-8859-1");
        for (int i2 = 0; i2 < this.streams.size(); ++i2) {
            COSStream stream = (COSStream)this.streams.getObject(i2);
            inputStreams.add(stream.getUnfilteredStream());
            inputStreams.add(new ByteArrayInputStream(inbetweenStreamBytes));
        }
        return new SequenceInputStream(inputStreams.elements());
    }

    public Object accept(ICOSVisitor visitor) throws COSVisitorException {
        return this.streams.accept(visitor);
    }

    public COSBase getFilters() {
        return this.firstStream.getFilters();
    }

    public OutputStream createFilteredStream() throws IOException {
        return this.firstStream.createFilteredStream();
    }

    public OutputStream createFilteredStream(COSBase expectedLength) throws IOException {
        return this.firstStream.createFilteredStream(expectedLength);
    }

    public void setFilters(COSBase filters) throws IOException {
        this.firstStream.setFilters(filters);
    }

    public OutputStream createUnfilteredStream() throws IOException {
        return this.firstStream.createUnfilteredStream();
    }

    public void appendStream(COSStream streamToAppend) {
        this.streams.add(streamToAppend);
    }

    public void insertCOSStream(PDStream streamToBeInserted) {
        COSArray tmp = new COSArray();
        tmp.add(streamToBeInserted);
        tmp.addAll(this.streams);
        this.streams.clear();
        this.streams = tmp;
    }
}

