/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfwriter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class COSFilterInputStream
extends FilterInputStream {
    int[] byteRange;
    long position = 0L;

    public COSFilterInputStream(InputStream in, int[] byteRange) {
        super(in);
        this.byteRange = byteRange;
    }

    public COSFilterInputStream(byte[] in, int[] byteRange) {
        super(new ByteArrayInputStream(in));
        this.byteRange = byteRange;
    }

    public int read() throws IOException {
        this.nextAvailable();
        int i2 = super.read();
        if (i2 > -1) {
            ++this.position;
        }
        return i2;
    }

    public int read(byte[] b2) throws IOException {
        return this.read(b2, 0, b2.length);
    }

    public int read(byte[] b2, int off, int len) throws IOException {
        int i2;
        if (b2 == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b2.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int c2 = this.read();
        if (c2 == -1) {
            return -1;
        }
        b2[off] = (byte)c2;
        try {
            for (i2 = 1; i2 < len && (c2 = this.read()) != -1; ++i2) {
                b2[off + i2] = (byte)c2;
            }
        }
        catch (IOException ee) {
            // empty catch block
        }
        return i2;
    }

    private boolean inRange() throws IOException {
        long pos = this.position;
        for (int i2 = 0; i2 < this.byteRange.length / 2; ++i2) {
            if ((long)this.byteRange[i2 * 2] > pos || (long)(this.byteRange[i2 * 2] + this.byteRange[i2 * 2 + 1]) <= pos) continue;
            return true;
        }
        return false;
    }

    private void nextAvailable() throws IOException {
        while (!this.inRange()) {
            ++this.position;
            if (super.read() >= 0) continue;
            break;
        }
    }

    public byte[] toByteArray() throws IOException {
        int c2;
        ByteArrayOutputStream byteOS = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((c2 = this.read(buffer)) != -1) {
            byteOS.write(buffer, 0, c2);
        }
        return byteOS.toByteArray();
    }
}

