/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfviewer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.IOException;
import javax.swing.JPanel;
import org.apache.pdfbox.pdfviewer.PageDrawer;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;

public class PDFPagePanel
extends JPanel {
    private static final long serialVersionUID = -4629033339560890669L;
    private PDPage page;
    private PageDrawer drawer = new PageDrawer();
    private Dimension pageDimension = null;
    private Dimension drawDimension = null;

    public void setPage(PDPage pdfPage) {
        this.page = pdfPage;
        PDRectangle cropBox = this.page.findCropBox();
        this.drawDimension = cropBox.createDimension();
        int rotation = this.page.findRotation();
        this.pageDimension = rotation == 90 || rotation == 270 ? new Dimension(this.drawDimension.height, this.drawDimension.width) : this.drawDimension;
        this.setSize(this.pageDimension);
        this.setBackground(Color.white);
    }

    public void paint(Graphics g2) {
        try {
            g2.setColor(this.getBackground());
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            int rotation = this.page.findRotation();
            if (rotation == 90 || rotation == 270) {
                Graphics2D g2D = (Graphics2D)g2;
                g2D.translate(this.pageDimension.getWidth(), 0.0);
                g2D.rotate(Math.toRadians(rotation));
            } else if (rotation == 180) {
                Graphics2D g2D = (Graphics2D)g2;
                g2D.translate(this.pageDimension.getWidth(), this.pageDimension.getHeight());
                g2D.rotate(Math.toRadians(rotation));
            }
            this.drawer.drawPage(g2, this.page, this.drawDimension);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }
}

