/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import org.apache.pdfbox.io.RandomAccessRead;

public class PushBackInputStream
extends PushbackInputStream {
    private long offset = 0L;
    private final RandomAccessRead raInput;

    public PushBackInputStream(InputStream input, int size) throws IOException {
        super(input, size);
        if (input == null) {
            throw new IOException("Error: input was null");
        }
        this.raInput = input instanceof RandomAccessRead ? (RandomAccessRead)((Object)input) : null;
    }

    public int peek() throws IOException {
        int result = this.read();
        if (result != -1) {
            this.unread(result);
        }
        return result;
    }

    public long getOffset() {
        return this.offset;
    }

    public int read() throws IOException {
        int retval = super.read();
        if (retval != -1) {
            ++this.offset;
        }
        return retval;
    }

    public int read(byte[] b2) throws IOException {
        return this.read(b2, 0, b2.length);
    }

    public int read(byte[] b2, int off, int len) throws IOException {
        int retval = super.read(b2, off, len);
        if (retval != -1) {
            this.offset += (long)retval;
        }
        return retval;
    }

    public void unread(int b2) throws IOException {
        --this.offset;
        super.unread(b2);
    }

    public void unread(byte[] b2) throws IOException {
        this.unread(b2, 0, b2.length);
    }

    public void unread(byte[] b2, int off, int len) throws IOException {
        if (len > 0) {
            this.offset -= (long)len;
            super.unread(b2, off, len);
        }
    }

    public boolean isEOF() throws IOException {
        int peek = this.peek();
        return peek == -1;
    }

    public void fillBuffer() throws IOException {
        int bufferLength = this.buf.length;
        byte[] tmpBuffer = new byte[bufferLength];
        int amountRead = 0;
        int totalAmountRead = 0;
        while (amountRead != -1 && totalAmountRead < bufferLength) {
            amountRead = this.read(tmpBuffer, totalAmountRead, bufferLength - totalAmountRead);
            if (amountRead == -1) continue;
            totalAmountRead += amountRead;
        }
        this.unread(tmpBuffer, 0, totalAmountRead);
    }

    public byte[] readFully(int length) throws IOException {
        int amountRead;
        byte[] data = new byte[length];
        for (int pos = 0; pos < length; pos += amountRead) {
            amountRead = this.read(data, pos, length - pos);
            if (amountRead >= 0) continue;
            throw new EOFException("Premature end of file");
        }
        return data;
    }

    public void seek(long newOffset) throws IOException {
        if (this.raInput == null) {
            throw new IOException("Provided stream of type " + this.in.getClass().getSimpleName() + " is not seekable.");
        }
        int unreadLength = this.buf.length - this.pos;
        if (unreadLength > 0) {
            this.skip(unreadLength);
        }
        this.raInput.seek(newOffset);
        this.offset = newOffset;
    }
}

