/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.filter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class Predictor {
    static byte[] decodePredictor(int predictor, int colors, int bitsPerComponent, int columns, InputStream data) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[2048];
        if (predictor == 1) {
            int i2;
            while ((i2 = data.read(buffer)) != -1) {
                baos.write(buffer, 0, i2);
            }
        } else {
            int bitsPerPixel = colors * bitsPerComponent;
            int bytesPerPixel = (bitsPerPixel + 7) / 8;
            int rowlength = (columns * bitsPerPixel + 7) / 8;
            byte[] actline = new byte[rowlength];
            byte[] lastline = new byte[rowlength];
            boolean done = false;
            int linepredictor = predictor;
            while (!done && data.available() > 0) {
                int i3;
                if (predictor >= 10) {
                    linepredictor = data.read();
                    if (linepredictor == -1) {
                        done = true;
                        break;
                    }
                    linepredictor += 10;
                }
                for (int offset = 0; offset < rowlength && (i3 = data.read(actline, offset, rowlength - offset)) != -1; offset += i3) {
                }
                switch (linepredictor) {
                    case 2: {
                        int left;
                        int sub;
                        int p;
                        if (bitsPerComponent != 8) {
                            throw new IOException("TIFF-Predictor with " + bitsPerComponent + " bits per component not supported");
                        }
                        for (p = 0; p < rowlength; ++p) {
                            sub = actline[p] & 0xFF;
                            left = p - bytesPerPixel >= 0 ? actline[p - bytesPerPixel] & 0xFF : 0;
                            actline[p] = (byte)(sub + left);
                        }
                        break;
                    }
                    case 10: {
                        break;
                    }
                    case 11: {
                        int left;
                        int sub;
                        int p;
                        for (p = 0; p < rowlength; ++p) {
                            sub = actline[p];
                            left = p - bytesPerPixel >= 0 ? actline[p - bytesPerPixel] : 0;
                            actline[p] = (byte)(sub + left);
                        }
                        break;
                    }
                    case 12: {
                        int p;
                        for (p = 0; p < rowlength; ++p) {
                            int up = actline[p] & 0xFF;
                            int prior = lastline[p] & 0xFF;
                            actline[p] = (byte)(up + prior & 0xFF);
                        }
                        break;
                    }
                    case 13: {
                        int left;
                        int p;
                        for (p = 0; p < rowlength; ++p) {
                            int avg = actline[p] & 0xFF;
                            left = p - bytesPerPixel >= 0 ? actline[p - bytesPerPixel] & 0xFF : 0;
                            int up = lastline[p] & 0xFF;
                            actline[p] = (byte)(avg + (int)Math.floor((left + up) / 2) & 0xFF);
                        }
                        break;
                    }
                    case 14: {
                        int p;
                        for (p = 0; p < rowlength; ++p) {
                            int paeth = actline[p] & 0xFF;
                            int a2 = p - bytesPerPixel >= 0 ? actline[p - bytesPerPixel] & 0xFF : 0;
                            int b2 = lastline[p] & 0xFF;
                            int c2 = p - bytesPerPixel >= 0 ? lastline[p - bytesPerPixel] & 0xFF : 0;
                            int value = a2 + b2 - c2;
                            int absa = Math.abs(value - a2);
                            int absb = Math.abs(value - b2);
                            int absc = Math.abs(value - c2);
                            actline[p] = absa <= absb && absa <= absc ? (byte)(paeth + a2 & 0xFF) : (absb <= absc ? (byte)(paeth + b2 & 0xFF) : (byte)(paeth + c2 & 0xFF));
                        }
                        break;
                    }
                }
                lastline = (byte[])actline.clone();
                baos.write(actline, 0, actline.length);
            }
        }
        return baos.toByteArray();
    }
}

