/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.filter;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.filter.Filter;
import org.apache.pdfbox.filter.TIFFFaxDecoder;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.ccitt.CCITTFaxG31DDecodeInputStream;
import org.apache.pdfbox.io.ccitt.FillOrderChangeInputStream;

public class CCITTFaxDecodeFilter
implements Filter {
    private static final Log log = LogFactory.getLog(CCITTFaxDecodeFilter.class);

    public void decode(InputStream compressedData, OutputStream result, COSDictionary options, int filterIndex) throws IOException {
        COSBase decodeP = options.getDictionaryObject(COSName.DECODE_PARMS, COSName.DP);
        COSDictionary decodeParms = null;
        if (decodeP instanceof COSDictionary) {
            decodeParms = (COSDictionary)decodeP;
        } else if (decodeP instanceof COSArray) {
            decodeParms = (COSDictionary)((COSArray)decodeP).getObject(filterIndex);
        }
        int cols = decodeParms.getInt(COSName.COLUMNS, 1728);
        int rows = decodeParms.getInt(COSName.ROWS, 0);
        int height = options.getInt(COSName.HEIGHT, COSName.H, 0);
        rows = rows > 0 && height > 0 ? Math.min(rows, height) : Math.max(rows, height);
        int k2 = decodeParms.getInt(COSName.K, 0);
        boolean encodedByteAlign = decodeParms.getBoolean(COSName.ENCODED_BYTE_ALIGN, false);
        int arraySize = (cols + 7) / 8 * rows;
        TIFFFaxDecoder faxDecoder = new TIFFFaxDecoder(1, cols, rows);
        long tiffOptions = 0L;
        byte[] compressed = IOUtils.toByteArray(compressedData);
        byte[] decompressed = null;
        if (k2 == 0) {
            InputStream in = new CCITTFaxG31DDecodeInputStream(new ByteArrayInputStream(compressed), cols, encodedByteAlign);
            in = new FillOrderChangeInputStream(in);
            decompressed = IOUtils.toByteArray(in);
            in.close();
        } else if (k2 > 0) {
            decompressed = new byte[arraySize];
            faxDecoder.decode2D(decompressed, compressed, 0, rows, tiffOptions);
        } else if (k2 < 0) {
            decompressed = new byte[arraySize];
            faxDecoder.decodeT6(decompressed, compressed, 0, rows, tiffOptions, encodedByteAlign);
        }
        boolean blackIsOne = decodeParms.getBoolean(COSName.BLACK_IS_1, false);
        if (!blackIsOne) {
            this.invertBitmap(decompressed);
        }
        if (!options.containsKey(COSName.COLORSPACE)) {
            options.setName(COSName.COLORSPACE, COSName.DEVICEGRAY.getName());
        }
        result.write(decompressed);
    }

    public void encode(InputStream rawData, OutputStream result, COSDictionary options, int filterIndex) throws IOException {
        log.warn("CCITTFaxDecode.encode is not implemented yet, skipping this stream.");
    }

    private void invertBitmap(byte[] bufferData) {
        int c2 = bufferData.length;
        for (int i2 = 0; i2 < c2; ++i2) {
            bufferData[i2] = (byte)(~bufferData[i2] & 0xFF);
        }
    }
}

