/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.encryption;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.encryption.PDFEncryption;
import org.apache.pdfbox.exceptions.CryptographyException;
import org.apache.pdfbox.exceptions.InvalidPasswordException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.encryption.PDStandardEncryption;

public class DocumentEncryption {
    private PDDocument pdDocument = null;
    private COSDocument document = null;
    private byte[] encryptionKey = null;
    private PDFEncryption encryption = new PDFEncryption();
    private Set objects = new HashSet();
    private Set potentialSignatures = new HashSet();

    public DocumentEncryption(PDDocument doc) {
        this.pdDocument = doc;
        this.document = doc.getDocument();
    }

    public DocumentEncryption(COSDocument doc) {
        this.pdDocument = new PDDocument(doc);
        this.document = doc;
    }

    public void initForEncryption() throws CryptographyException, IOException {
        String ownerPassword = this.pdDocument.getOwnerPasswordForEncryption();
        String userPassword = this.pdDocument.getUserPasswordForEncryption();
        if (ownerPassword == null) {
            ownerPassword = "";
        }
        if (userPassword == null) {
            userPassword = "";
        }
        PDStandardEncryption encParameters = (PDStandardEncryption)this.pdDocument.getEncryptionDictionary();
        int permissionInt = encParameters.getPermissions();
        int revision = encParameters.getRevision();
        int length = encParameters.getLength() / 8;
        COSArray idArray = this.document.getDocumentID();
        if (idArray == null || idArray.size() < 2) {
            idArray = new COSArray();
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                BigInteger time = BigInteger.valueOf(System.currentTimeMillis());
                md.update(time.toByteArray());
                md.update(ownerPassword.getBytes("ISO-8859-1"));
                md.update(userPassword.getBytes("ISO-8859-1"));
                md.update(this.document.toString().getBytes());
                byte[] id = md.digest(this.toString().getBytes("ISO-8859-1"));
                COSString idString = new COSString();
                idString.append(id);
                idArray.add(idString);
                idArray.add(idString);
                this.document.setDocumentID(idArray);
            }
            catch (NoSuchAlgorithmException e2) {
                throw new CryptographyException(e2);
            }
        }
        COSString id = (COSString)idArray.getObject(0);
        this.encryption = new PDFEncryption();
        byte[] o2 = this.encryption.computeOwnerPassword(ownerPassword.getBytes("ISO-8859-1"), userPassword.getBytes("ISO-8859-1"), revision, length);
        byte[] u = this.encryption.computeUserPassword(userPassword.getBytes("ISO-8859-1"), o2, permissionInt, id.getBytes(), revision, length);
        this.encryptionKey = this.encryption.computeEncryptedKey(userPassword.getBytes("ISO-8859-1"), o2, permissionInt, id.getBytes(), revision, length);
        encParameters.setOwnerKey(o2);
        encParameters.setUserKey(u);
        this.document.setEncryptionDictionary(encParameters.getCOSDictionary());
    }

    public void decryptDocument(String password) throws CryptographyException, IOException, InvalidPasswordException {
        if (password == null) {
            password = "";
        }
        PDStandardEncryption encParameters = (PDStandardEncryption)this.pdDocument.getEncryptionDictionary();
        int permissions = encParameters.getPermissions();
        int revision = encParameters.getRevision();
        int length = encParameters.getLength() / 8;
        COSString id = (COSString)this.document.getDocumentID().getObject(0);
        byte[] u = encParameters.getUserKey();
        byte[] o2 = encParameters.getOwnerKey();
        boolean isUserPassword = this.encryption.isUserPassword(password.getBytes("ISO-8859-1"), u, o2, permissions, id.getBytes(), revision, length);
        boolean isOwnerPassword = this.encryption.isOwnerPassword(password.getBytes("ISO-8859-1"), u, o2, permissions, id.getBytes(), revision, length);
        if (isUserPassword) {
            this.encryptionKey = this.encryption.computeEncryptedKey(password.getBytes("ISO-8859-1"), o2, permissions, id.getBytes(), revision, length);
        } else if (isOwnerPassword) {
            byte[] computedUserPassword = this.encryption.getUserPassword(password.getBytes("ISO-8859-1"), o2, revision, length);
            this.encryptionKey = this.encryption.computeEncryptedKey(computedUserPassword, o2, permissions, id.getBytes(), revision, length);
        } else {
            throw new InvalidPasswordException("Error: The supplied password does not match either the owner or user password in the document.");
        }
        COSDictionary trailer = this.document.getTrailer();
        COSArray fields = (COSArray)trailer.getObjectFromPath("Root/AcroForm/Fields");
        if (fields != null) {
            for (int i2 = 0; i2 < fields.size(); ++i2) {
                COSDictionary field = (COSDictionary)fields.getObject(i2);
                this.addDictionaryAndSubDictionary(this.potentialSignatures, field);
            }
        }
        List<COSObject> allObjects = this.document.getObjects();
        Iterator<COSObject> objectIter = allObjects.iterator();
        while (objectIter.hasNext()) {
            this.decryptObject(objectIter.next());
        }
        this.document.setEncryptionDictionary(null);
    }

    private void addDictionaryAndSubDictionary(Set set, COSDictionary dic) {
        set.add(dic);
        COSArray kids = (COSArray)dic.getDictionaryObject(COSName.KIDS);
        for (int i2 = 0; kids != null && i2 < kids.size(); ++i2) {
            this.addDictionaryAndSubDictionary(set, (COSDictionary)kids.getObject(i2));
        }
        COSBase value = dic.getDictionaryObject(COSName.V);
        if (value instanceof COSDictionary) {
            this.addDictionaryAndSubDictionary(set, (COSDictionary)value);
        }
    }

    private void decryptObject(COSObject object) throws CryptographyException, IOException {
        long objNum = object.getObjectNumber().intValue();
        long genNum = object.getGenerationNumber().intValue();
        COSBase base = object.getObject();
        this.decrypt(base, objNum, genNum);
    }

    public void decrypt(Object obj, long objNum, long genNum) throws CryptographyException, IOException {
        if (!this.objects.contains(obj)) {
            this.objects.add(obj);
            if (obj instanceof COSString) {
                this.decryptString((COSString)obj, objNum, genNum);
            } else if (obj instanceof COSStream) {
                this.decryptStream((COSStream)obj, objNum, genNum);
            } else if (obj instanceof COSDictionary) {
                this.decryptDictionary((COSDictionary)obj, objNum, genNum);
            } else if (obj instanceof COSArray) {
                this.decryptArray((COSArray)obj, objNum, genNum);
            }
        }
    }

    private void decryptStream(COSStream stream, long objNum, long genNum) throws CryptographyException, IOException {
        this.decryptDictionary(stream, objNum, genNum);
        InputStream encryptedStream = stream.getFilteredStream();
        this.encryption.encryptData(objNum, genNum, this.encryptionKey, encryptedStream, stream.createFilteredStream());
    }

    private void decryptDictionary(COSDictionary dictionary, long objNum, long genNum) throws CryptographyException, IOException {
        for (Map.Entry<COSName, COSBase> entry : dictionary.entrySet()) {
            if (entry.getKey().getName().equals("Contents") && entry.getValue() instanceof COSString && this.potentialSignatures.contains(dictionary)) continue;
            this.decrypt(entry.getValue(), objNum, genNum);
        }
    }

    private void decryptString(COSString string, long objNum, long genNum) throws CryptographyException, IOException {
        ByteArrayInputStream data = new ByteArrayInputStream(string.getBytes());
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        this.encryption.encryptData(objNum, genNum, this.encryptionKey, data, buffer);
        string.reset();
        string.append(buffer.toByteArray());
    }

    private void decryptArray(COSArray array, long objNum, long genNum) throws CryptographyException, IOException {
        for (int i2 = 0; i2 < array.size(); ++i2) {
            this.decrypt(array.get(i2), objNum, genNum);
        }
    }
}

