/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox;

import java.io.FileInputStream;
import java.io.InputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.encryption.PublicKeyProtectionPolicy;
import org.apache.pdfbox.pdmodel.encryption.PublicKeyRecipient;
import org.apache.pdfbox.pdmodel.encryption.StandardProtectionPolicy;

public class Encrypt {
    private Encrypt() {
    }

    public static void main(String[] args) throws Exception {
        Encrypt encrypt = new Encrypt();
        encrypt.encrypt(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void encrypt(String[] args) throws Exception {
        if (args.length < 1) {
            Encrypt.usage();
            return;
        }
        AccessPermission ap = new AccessPermission();
        String infile = null;
        String outfile = null;
        String certFile = null;
        String userPassword = "";
        String ownerPassword = "";
        int keyLength = 40;
        PDDocument document = null;
        try {
            for (int i2 = 0; i2 < args.length; ++i2) {
                String key = args[i2];
                if (key.equals("-O")) {
                    ownerPassword = args[++i2];
                    continue;
                }
                if (key.equals("-U")) {
                    userPassword = args[++i2];
                    continue;
                }
                if (key.equals("-canAssemble")) {
                    ap.setCanAssembleDocument(args[++i2].equalsIgnoreCase("true"));
                    continue;
                }
                if (key.equals("-canExtractContent")) {
                    ap.setCanExtractContent(args[++i2].equalsIgnoreCase("true"));
                    continue;
                }
                if (key.equals("-canExtractForAccessibility")) {
                    ap.setCanExtractForAccessibility(args[++i2].equalsIgnoreCase("true"));
                    continue;
                }
                if (key.equals("-canFillInForm")) {
                    ap.setCanFillInForm(args[++i2].equalsIgnoreCase("true"));
                    continue;
                }
                if (key.equals("-canModify")) {
                    ap.setCanModify(args[++i2].equalsIgnoreCase("true"));
                    continue;
                }
                if (key.equals("-canModifyAnnotations")) {
                    ap.setCanModifyAnnotations(args[++i2].equalsIgnoreCase("true"));
                    continue;
                }
                if (key.equals("-canPrint")) {
                    ap.setCanPrint(args[++i2].equalsIgnoreCase("true"));
                    continue;
                }
                if (key.equals("-canPrintDegraded")) {
                    ap.setCanPrintDegraded(args[++i2].equalsIgnoreCase("true"));
                    continue;
                }
                if (key.equals("-certFile")) {
                    certFile = args[++i2];
                    continue;
                }
                if (key.equals("-keyLength")) {
                    try {
                        keyLength = Integer.parseInt(args[++i2]);
                        continue;
                    }
                    catch (NumberFormatException e2) {
                        throw new NumberFormatException("Error: -keyLength is not an integer '" + args[i2] + "'");
                    }
                }
                if (infile == null) {
                    infile = key;
                    continue;
                }
                if (outfile == null) {
                    outfile = key;
                    continue;
                }
                Encrypt.usage();
            }
            if (infile == null) {
                Encrypt.usage();
            }
            if (outfile == null) {
                outfile = infile;
            }
            if (!(document = PDDocument.load(infile)).isEncrypted()) {
                if (certFile != null) {
                    PublicKeyProtectionPolicy ppp = new PublicKeyProtectionPolicy();
                    PublicKeyRecipient recip = new PublicKeyRecipient();
                    recip.setPermission(ap);
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    FileInputStream inStream = new FileInputStream(certFile);
                    X509Certificate certificate = (X509Certificate)cf.generateCertificate(inStream);
                    ((InputStream)inStream).close();
                    recip.setX509(certificate);
                    ppp.addRecipient(recip);
                    ppp.setEncryptionKeyLength(keyLength);
                    document.protect(ppp);
                } else {
                    StandardProtectionPolicy spp = new StandardProtectionPolicy(ownerPassword, userPassword, ap);
                    spp.setEncryptionKeyLength(keyLength);
                    document.protect(spp);
                }
                document.save(outfile);
            } else {
                System.err.println("Error: Document is already encrypted.");
            }
            Object var16_18 = null;
            if (document == null) return;
        }
        catch (Throwable throwable) {
            Object var16_19 = null;
            if (document == null) throw throwable;
            document.close();
            throw throwable;
        }
        document.close();
    }

    private static void usage() {
        System.err.println("usage: java -jar pdfbox-app-x.y.z.jar Encrypt [options] <inputfile> [outputfile]");
        System.err.println("   -O <password>                            Set the owner password(ignored if cert is set)");
        System.err.println("   -U <password>                            Set the user password(ignored if cert is set)");
        System.err.println("   -certFile <path to cert>                 Path to X.509 certificate");
        System.err.println("   -canAssemble <true|false>                Set the assemble permission");
        System.err.println("   -canExtractContent <true|false>          Set the extraction permission");
        System.err.println("   -canExtractForAccessibility <true|false> Set the extraction permission");
        System.err.println("   -canFillInForm <true|false>              Set the fill in form permission");
        System.err.println("   -canModify <true|false>                  Set the modify permission");
        System.err.println("   -canModifyAnnotations <true|false>       Set the modify annots permission");
        System.err.println("   -canPrint <true|false>                   Set the print permission");
        System.err.println("   -canPrintDegraded <true|false>           Set the print degraded permission");
        System.err.println("   -keyLength <length>                      The length of the key in bits(40)");
        System.err.println("\nNote: By default all permissions are set to true!");
        System.exit(1);
    }
}

