/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.pdfparser.PDFStreamParser;
import org.apache.pdfbox.pdfwriter.ContentStreamWriter;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.util.PDFOperator;

public class ConvertColorspace {
    private static final String PASSWORD = "-password";
    private static final String CONVERSION = "-equiv";
    private static final String DEST_COLORSPACE = "-toColorspace";

    private ConvertColorspace() {
    }

    private void replaceColors(PDDocument inputFile, Hashtable colorEquivalents, String destColorspace) throws IOException {
        if (!destColorspace.equals("CMYK")) {
            throw new IOException("Error: Unknown colorspace " + destColorspace);
        }
        List pagesList = inputFile.getDocumentCatalog().getAllPages();
        PDPage currentPage = null;
        PDFStreamParser parser = null;
        List<Object> pageTokens = null;
        ArrayList<Object> editedPageTokens = null;
        for (int pageCounter = 0; pageCounter < pagesList.size(); ++pageCounter) {
            currentPage = (PDPage)pagesList.get(pageCounter);
            parser = new PDFStreamParser(currentPage.getContents().getStream());
            parser.parse();
            pageTokens = parser.getTokens();
            editedPageTokens = new ArrayList<Object>();
            for (int counter = 0; counter < pageTokens.size(); ++counter) {
                Object token = pageTokens.get(counter);
                if (token instanceof PDFOperator) {
                    PDFOperator tokenOperator = (PDFOperator)token;
                    if (tokenOperator.getOperation().equals("rg")) {
                        if (!destColorspace.equals("CMYK")) continue;
                        this.replaceRGBTokensWithCMYKTokens(editedPageTokens, pageTokens, counter, colorEquivalents);
                        editedPageTokens.add(PDFOperator.getOperator("k"));
                        continue;
                    }
                    if (tokenOperator.getOperation().equals("RG")) {
                        if (!destColorspace.equals("CMYK")) continue;
                        this.replaceRGBTokensWithCMYKTokens(editedPageTokens, pageTokens, counter, colorEquivalents);
                        editedPageTokens.add(PDFOperator.getOperator("K"));
                        continue;
                    }
                    if (tokenOperator.getOperation().equals("g")) {
                        if (!destColorspace.equals("CMYK")) continue;
                        this.replaceGrayTokensWithCMYKTokens(editedPageTokens, pageTokens, counter, colorEquivalents);
                        editedPageTokens.add(PDFOperator.getOperator("k"));
                        continue;
                    }
                    if (tokenOperator.getOperation().equals("G")) {
                        if (!destColorspace.equals("CMYK")) continue;
                        this.replaceGrayTokensWithCMYKTokens(editedPageTokens, pageTokens, counter, colorEquivalents);
                        editedPageTokens.add(PDFOperator.getOperator("K"));
                        continue;
                    }
                    editedPageTokens.add(token);
                    continue;
                }
                editedPageTokens.add(token);
            }
            PDStream updatedPageContents = new PDStream(inputFile);
            ContentStreamWriter contentWriter = new ContentStreamWriter(updatedPageContents.createOutputStream());
            contentWriter.writeTokens(editedPageTokens);
            currentPage.setContents(updatedPageContents);
        }
    }

    private void replaceRGBTokensWithCMYKTokens(List editedPageTokens, List pageTokens, int counter, Hashtable colorEquivalents) {
        float red = ((COSNumber)pageTokens.get(counter - 3)).floatValue();
        float green = ((COSNumber)pageTokens.get(counter - 2)).floatValue();
        float blue = ((COSNumber)pageTokens.get(counter - 1)).floatValue();
        int intRed = Math.round(red * 255.0f);
        int intGreen = Math.round(green * 255.0f);
        int intBlue = Math.round(blue * 255.0f);
        ColorSpaceInstance rgbColor = new ColorSpaceInstance();
        rgbColor.colorspace = "RGB";
        ColorSpaceInstance.access$202(rgbColor, new int[]{intRed, intGreen, intBlue});
        ColorSpaceInstance cmykColor = (ColorSpaceInstance)colorEquivalents.get(rgbColor);
        float[] cmyk = null;
        cmyk = cmykColor != null ? new float[]{(float)cmykColor.colorspaceValues[0] / 100.0f, (float)cmykColor.colorspaceValues[1] / 100.0f, (float)cmykColor.colorspaceValues[2] / 100.0f, (float)cmykColor.colorspaceValues[3] / 100.0f} : ConvertColorspace.convertRGBToCMYK(red, green, blue);
        editedPageTokens.remove(editedPageTokens.size() - 1);
        editedPageTokens.remove(editedPageTokens.size() - 1);
        editedPageTokens.remove(editedPageTokens.size() - 1);
        editedPageTokens.add(new COSFloat(cmyk[0]));
        editedPageTokens.add(new COSFloat(cmyk[1]));
        editedPageTokens.add(new COSFloat(cmyk[2]));
        editedPageTokens.add(new COSFloat(cmyk[3]));
    }

    private void replaceGrayTokensWithCMYKTokens(List editedPageTokens, List pageTokens, int counter, Hashtable colorEquivalents) {
        float gray = ((COSNumber)pageTokens.get(counter - 1)).floatValue();
        ColorSpaceInstance grayColor = new ColorSpaceInstance();
        grayColor.colorspace = "Grayscale";
        ColorSpaceInstance.access$202(grayColor, new int[]{Math.round(gray * 100.0f)});
        ColorSpaceInstance cmykColor = (ColorSpaceInstance)colorEquivalents.get(grayColor);
        float[] cmyk = null;
        cmyk = cmykColor != null ? new float[]{(float)cmykColor.colorspaceValues[0] / 100.0f, (float)cmykColor.colorspaceValues[1] / 100.0f, (float)cmykColor.colorspaceValues[2] / 100.0f, (float)cmykColor.colorspaceValues[3] / 100.0f} : new float[]{0.0f, 0.0f, 0.0f, gray};
        editedPageTokens.remove(editedPageTokens.size() - 1);
        editedPageTokens.add(new COSFloat(cmyk[0]));
        editedPageTokens.add(new COSFloat(cmyk[1]));
        editedPageTokens.add(new COSFloat(cmyk[2]));
        editedPageTokens.add(new COSFloat(cmyk[3]));
    }

    private static float[] convertRGBToCMYK(float red, float green, float blue) {
        float c2 = 1.0f - red;
        float m2 = 1.0f - green;
        float y = 1.0f - blue;
        float k2 = 1.0f;
        k2 = Math.min(Math.min(Math.min(c2, k2), m2), y);
        c2 = (c2 - k2) / (1.0f - k2);
        m2 = (m2 - k2) / (1.0f - k2);
        y = (y - k2) / (1.0f - k2);
        return new float[]{c2, m2, y, k2};
    }

    private static int[] stringToIntArray(String string) {
        String[] ints = string.split(",");
        int[] retval = new int[ints.length];
        for (int i2 = 0; i2 < ints.length; ++i2) {
            retval[i2] = Integer.parseInt(ints[i2]);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String password = "";
        String inputFile = null;
        String outputFile = null;
        String destColorspace = "CMYK";
        Pattern colorEquivalentPattern = Pattern.compile("^(.*):\\((.*)\\)=(.*):\\((.*)\\)$");
        Matcher colorEquivalentMatcher = null;
        Hashtable<ColorSpaceInstance, ColorSpaceInstance> colorEquivalents = new Hashtable<ColorSpaceInstance, ColorSpaceInstance>();
        for (int i2 = 0; i2 < args.length; ++i2) {
            if (args[i2].equals(PASSWORD)) {
                if (++i2 >= args.length) {
                    ConvertColorspace.usage();
                }
                password = args[i2];
            }
            if (args[i2].equals(DEST_COLORSPACE)) {
                if (++i2 >= args.length) {
                    ConvertColorspace.usage();
                }
                destColorspace = args[i2];
            }
            if (args[i2].equals(CONVERSION)) {
                if (++i2 >= args.length) {
                    ConvertColorspace.usage();
                }
                if (!(colorEquivalentMatcher = colorEquivalentPattern.matcher(args[i2])).matches()) {
                    ConvertColorspace.usage();
                }
                String srcColorSpace = colorEquivalentMatcher.group(1);
                String srcColorvalues = colorEquivalentMatcher.group(2);
                String destColorSpace = colorEquivalentMatcher.group(3);
                String destColorvalues = colorEquivalentMatcher.group(4);
                ColorSpaceInstance source = new ColorSpaceInstance();
                source.colorspace = srcColorSpace;
                ColorSpaceInstance.access$202(source, ConvertColorspace.stringToIntArray(srcColorvalues));
                ColorSpaceInstance dest = new ColorSpaceInstance();
                dest.colorspace = destColorSpace;
                ColorSpaceInstance.access$202(dest, ConvertColorspace.stringToIntArray(destColorvalues));
                colorEquivalents.put(source, dest);
                continue;
            }
            if (inputFile == null) {
                inputFile = args[i2];
                continue;
            }
            outputFile = args[i2];
        }
        if (inputFile == null) {
            ConvertColorspace.usage();
        }
        if (outputFile == null || outputFile.equals(inputFile)) {
            ConvertColorspace.usage();
        }
        PDDocument doc = null;
        try {
            doc = PDDocument.load(inputFile);
            if (doc.isEncrypted()) {
                doc.decrypt(password);
            }
            ConvertColorspace converter = new ConvertColorspace();
            converter.replaceColors(doc, colorEquivalents, destColorspace);
            doc.save(outputFile);
        }
        finally {
            if (doc != null) {
                doc.close();
            }
        }
    }

    private static void usage() {
        System.err.println("Usage: java org.apache.pdfbox.ConvertColorspace [OPTIONS] <PDF Input file> <PDF Output File>\n  -password  <password>                Password to decrypt document\n  -equiv <color equivalent>            Color equivalent to use for conversion.\n  -destColorspace <color equivalent>   The destination colorspace, CMYK is the only 'supported colorspace.  \n The equiv format is : <source colorspace>:(colorspace value)=<dest colorspace>:(colorspace value) This option can be used as many times as necessary\n The supported equiv colorspaces are RGB and CMYK.\n RGB color values are integers between 0 and 255 CMYK color values are integer between 0 and 100.\n Example: java org.apache.pdfbox.ConvertColorspace -equiv RGB:(255,0,0)=CMYK(0,99,100,0) input.pdf output.pdf\n  <PDF Input file>             The PDF document to use\n  <PDF Output file>            The PDF file to write the result to. Must be different of input file\n");
        System.exit(1);
    }

    private static class ColorSpaceInstance {
        private String colorspace = null;
        private int[] colorspaceValues = null;

        private ColorSpaceInstance() {
        }

        public int hashCode() {
            int code = this.colorspace.hashCode();
            for (int i2 = 0; i2 < this.colorspaceValues.length; ++i2) {
                code += this.colorspaceValues[i2];
            }
            return code;
        }

        public boolean equals(Object o2) {
            boolean retval = false;
            if (o2 instanceof ColorSpaceInstance) {
                ColorSpaceInstance other = (ColorSpaceInstance)o2;
                if (this.colorspace.equals(other.colorspace) && this.colorspaceValues.length == other.colorspaceValues.length) {
                    retval = true;
                    for (int i2 = 0; i2 < this.colorspaceValues.length && retval; ++i2) {
                        retval = retval && this.colorspaceValues[i2] == other.colorspaceValues[i2];
                    }
                }
            }
            return retval;
        }

        static /* synthetic */ int[] access$202(ColorSpaceInstance x0, int[] x1) {
            x0.colorspaceValues = x1;
            return x1;
        }
    }
}

