/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.util.autodetect;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.fontbox.util.autodetect.FontDirFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowsFontDirFinder
implements FontDirFinder {
    private String getWinDir(String osName) throws IOException {
        Process process = null;
        Runtime runtime = Runtime.getRuntime();
        process = osName.startsWith("Windows 9") ? runtime.exec("command.com /c echo %windir%") : runtime.exec("cmd.exe /c echo %windir%");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        return bufferedReader.readLine();
    }

    @Override
    public List<File> find() {
        ArrayList<File> fontDirList;
        block10: {
            char driveLetter;
            File psFontsDir;
            File osFontsDir;
            String osName;
            block9: {
                fontDirList = new ArrayList<File>();
                String windir = null;
                try {
                    windir = System.getProperty("env.windir");
                }
                catch (SecurityException e2) {
                    // empty catch block
                }
                osName = System.getProperty("os.name");
                if (windir == null) {
                    try {
                        windir = this.getWinDir(osName);
                    }
                    catch (IOException e3) {
                        // empty catch block
                    }
                }
                osFontsDir = null;
                psFontsDir = null;
                if (windir == null) break block9;
                if (windir.endsWith("/")) {
                    windir = windir.substring(0, windir.length() - 1);
                }
                if ((osFontsDir = new File(windir + File.separator + "FONTS")).exists() && osFontsDir.canRead()) {
                    fontDirList.add(osFontsDir);
                }
                if (!(psFontsDir = new File(windir.substring(0, 2) + File.separator + "PSFONTS")).exists() || !psFontsDir.canRead()) break block10;
                fontDirList.add(psFontsDir);
                break block10;
            }
            String windowsDirName = osName.endsWith("NT") ? "WINNT" : "WINDOWS";
            for (driveLetter = 'C'; driveLetter <= 'E'; driveLetter = (char)(driveLetter + '\u0001')) {
                osFontsDir = new File(driveLetter + ":" + File.separator + windowsDirName + File.separator + "FONTS");
                if (!osFontsDir.exists() || !osFontsDir.canRead()) continue;
                fontDirList.add(osFontsDir);
                break;
            }
            for (driveLetter = 'C'; driveLetter <= 'E'; driveLetter = (char)(driveLetter + '\u0001')) {
                psFontsDir = new File(driveLetter + ":" + File.separator + "PSFONTS");
                if (!psFontsDir.exists() || !psFontsDir.canRead()) continue;
                fontDirList.add(psFontsDir);
                break;
            }
        }
        return fontDirList;
    }

    @Override
    public Map<String, String> getCommonTTFMapping() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Arial", "arialmt");
        map.put("Arial,Bold", "arialmtbold");
        map.put("Arial,Italic", "arialmtitalic");
        map.put("Arial,BoldItalic", "arialmtbolditalic");
        map.put("TimesNewRoman", "timesnewromanpsmt");
        map.put("TimesNewRoman,Bold", "timesnewromanpsmtbold");
        map.put("TimesNewRoman,BoldItalic", "timesnewromanpsmtbolditalic");
        map.put("TimesNewRoman,Italic", "timesnewromanpsmtitalic");
        map.put("Courier", "couriernewpsmt");
        map.put("Courier,Bold", "couriernewpsmtbold");
        map.put("Courier,Italic", "couriernewpsmtitalic");
        map.put("Courier,BoldItalic", "couriernewpsmtbolditalic");
        map.put("Symbol", "symbolmt");
        map.put("ZapfDingbats", "Wingdings");
        return Collections.unmodifiableMap(map);
    }
}

