/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cmap;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.cmap.CIDRange;
import org.apache.fontbox.cmap.CodespaceRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMap {
    private static final Log LOG = LogFactory.getLog(CMap.class);
    private int wmode = 0;
    private String cmapName = null;
    private String cmapVersion = null;
    private int cmapType = -1;
    private String registry = null;
    private String ordering = null;
    private int supplement = 0;
    private List<CodespaceRange> codeSpaceRanges = new ArrayList<CodespaceRange>();
    private Map<Integer, String> singleByteMappings = new HashMap<Integer, String>();
    private Map<Integer, String> doubleByteMappings = new HashMap<Integer, String>();
    private final Map<Integer, String> cid2charMappings = new HashMap<Integer, String>();
    private final Map<String, Integer> char2CIDMappings = new HashMap<String, Integer>();
    private final List<CIDRange> cidRanges = new LinkedList<CIDRange>();
    private static final String SPACE = " ";
    private int spaceMapping = -1;

    public boolean hasOneByteMappings() {
        return this.singleByteMappings.size() > 0;
    }

    public boolean hasTwoByteMappings() {
        return this.doubleByteMappings.size() > 0;
    }

    public boolean hasCIDMappings() {
        return !this.char2CIDMappings.isEmpty() || !this.cidRanges.isEmpty();
    }

    public String lookup(byte[] code, int offset, int length) {
        return this.lookup(this.getCodeFromArray(code, offset, length), length);
    }

    public String lookup(int code, int length) {
        String result = null;
        if (length == 1) {
            result = this.singleByteMappings.get(code);
        } else if (length == 2) {
            result = this.doubleByteMappings.get(code);
        }
        return result;
    }

    public String lookupCID(int cid) {
        if (this.cid2charMappings.containsKey(cid)) {
            return this.cid2charMappings.get(cid);
        }
        for (CIDRange range : this.cidRanges) {
            int ch = range.unmap(cid);
            if (ch == -1) continue;
            return Character.toString((char)ch);
        }
        return null;
    }

    public int lookupCID(byte[] code, int offset, int length) {
        if (this.isInCodeSpaceRanges(code, offset, length)) {
            int codeAsInt = this.getCodeFromArray(code, offset, length);
            if (this.char2CIDMappings.containsKey(codeAsInt)) {
                return this.char2CIDMappings.get(codeAsInt);
            }
            for (CIDRange range : this.cidRanges) {
                int ch = range.map((char)codeAsInt);
                if (ch == -1) continue;
                return ch;
            }
            return -1;
        }
        return -1;
    }

    private int getCodeFromArray(byte[] data, int offset, int length) {
        int code = 0;
        for (int i2 = 0; i2 < length; ++i2) {
            code <<= 8;
            code |= (data[offset + i2] + 256) % 256;
        }
        return code;
    }

    public void addMapping(byte[] src, String dest) throws IOException {
        int srcLength = src.length;
        int intSrc = this.getCodeFromArray(src, 0, srcLength);
        if (SPACE.equals(dest)) {
            this.spaceMapping = intSrc;
        }
        if (srcLength == 1) {
            this.singleByteMappings.put(intSrc, dest);
        } else if (srcLength == 2) {
            this.doubleByteMappings.put(intSrc, dest);
        } else {
            LOG.error("Mapping code should be 1 or two bytes and not " + src.length);
        }
    }

    public void addCIDMapping(int src, String dest) throws IOException {
        this.cid2charMappings.put(src, dest);
        this.char2CIDMappings.put(dest, src);
    }

    public void addCIDRange(char from, char to, int cid) {
        this.cidRanges.add(0, new CIDRange(from, to, cid));
    }

    public void addCodespaceRange(CodespaceRange range) {
        this.codeSpaceRanges.add(range);
    }

    public List<CodespaceRange> getCodeSpaceRanges() {
        return this.codeSpaceRanges;
    }

    public void useCmap(CMap cmap) {
        this.codeSpaceRanges.addAll(cmap.codeSpaceRanges);
        this.singleByteMappings.putAll(cmap.singleByteMappings);
        this.doubleByteMappings.putAll(cmap.doubleByteMappings);
    }

    public boolean isInCodeSpaceRanges(byte[] code) {
        return this.isInCodeSpaceRanges(code, 0, code.length);
    }

    public boolean isInCodeSpaceRanges(byte[] code, int offset, int length) {
        for (CodespaceRange range : this.codeSpaceRanges) {
            if (range == null || !range.isInRange(code, offset, length)) continue;
            return true;
        }
        return false;
    }

    public int getWMode() {
        return this.wmode;
    }

    public void setWMode(int newWMode) {
        this.wmode = newWMode;
    }

    public String getName() {
        return this.cmapName;
    }

    public void setName(String name) {
        this.cmapName = name;
    }

    public String getVersion() {
        return this.cmapVersion;
    }

    public void setVersion(String version) {
        this.cmapVersion = version;
    }

    public int getType() {
        return this.cmapType;
    }

    public void setType(int type) {
        this.cmapType = type;
    }

    public String getRegistry() {
        return this.registry;
    }

    public void setRegistry(String newRegistry) {
        this.registry = newRegistry;
    }

    public String getOrdering() {
        return this.ordering;
    }

    public void setOrdering(String newOrdering) {
        this.ordering = newOrdering;
    }

    public int getSupplement() {
        return this.supplement;
    }

    public void setSupplement(int newSupplement) {
        this.supplement = newSupplement;
    }

    public int getSpaceMapping() {
        return this.spaceMapping;
    }
}

