/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff;

public class Type1FontUtil {
    private Type1FontUtil() {
    }

    public static String hexEncode(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            String string = Integer.toHexString(bytes[i2] & 0xFF);
            if (string.length() == 1) {
                sb.append("0");
            }
            sb.append(string.toUpperCase());
        }
        return sb.toString();
    }

    public static byte[] hexDecode(String string) {
        if (string.length() % 2 != 0) {
            throw new IllegalArgumentException();
        }
        byte[] bytes = new byte[string.length() / 2];
        for (int i2 = 0; i2 < string.length(); i2 += 2) {
            bytes[i2 / 2] = (byte)Integer.parseInt(string.substring(i2, i2 + 2), 16);
        }
        return bytes;
    }

    public static byte[] eexecEncrypt(byte[] buffer) {
        return Type1FontUtil.encrypt(buffer, 55665, 4);
    }

    public static byte[] charstringEncrypt(byte[] buffer, int n2) {
        return Type1FontUtil.encrypt(buffer, 4330, n2);
    }

    private static byte[] encrypt(byte[] plaintextBytes, int r, int n2) {
        byte[] buffer = new byte[plaintextBytes.length + n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            buffer[i2] = 0;
        }
        System.arraycopy(plaintextBytes, 0, buffer, n2, buffer.length - n2);
        int c1 = 52845;
        int c2 = 22719;
        byte[] ciphertextBytes = new byte[buffer.length];
        for (int i3 = 0; i3 < buffer.length; ++i3) {
            int plain = buffer[i3] & 0xFF;
            int cipher = plain ^ r >> 8;
            ciphertextBytes[i3] = (byte)cipher;
            r = (cipher + r) * c1 + c2 & 0xFFFF;
        }
        return ciphertextBytes;
    }

    public static byte[] eexecDecrypt(byte[] buffer) {
        return Type1FontUtil.decrypt(buffer, 55665, 4);
    }

    public static byte[] charstringDecrypt(byte[] buffer, int n2) {
        return Type1FontUtil.decrypt(buffer, 4330, n2);
    }

    private static byte[] decrypt(byte[] ciphertextBytes, int r, int n2) {
        byte[] buffer = new byte[ciphertextBytes.length];
        int c1 = 52845;
        int c2 = 22719;
        for (int i2 = 0; i2 < ciphertextBytes.length; ++i2) {
            int cipher = ciphertextBytes[i2] & 0xFF;
            int plain = cipher ^ r >> 8;
            buffer[i2] = (byte)plain;
            r = (cipher + r) * c1 + c2 & 0xFFFF;
        }
        byte[] plaintextBytes = new byte[ciphertextBytes.length - n2];
        System.arraycopy(buffer, n2, plaintextBytes, 0, plaintextBytes.length);
        return plaintextBytes;
    }
}

