/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Locale;
import org.apache.fontbox.cff.CFFFont;
import org.apache.fontbox.cff.DataOutput;
import org.apache.fontbox.cff.Type1CharStringFormatter;
import org.apache.fontbox.cff.Type1FontUtil;

public class Type1FontFormatter {
    private Type1FontFormatter() {
    }

    public static byte[] format(CFFFont font) throws IOException {
        DataOutput output = new DataOutput();
        Type1FontFormatter.printFont(font, output);
        return output.getBytes();
    }

    private static void printFont(CFFFont font, DataOutput output) throws IOException {
        output.println("%!FontType1-1.0 " + font.getName() + " " + font.getProperty("version"));
        Type1FontFormatter.printFontDictionary(font, output);
        for (int i2 = 0; i2 < 8; ++i2) {
            StringBuilder sb = new StringBuilder();
            for (int j2 = 0; j2 < 64; ++j2) {
                sb.append("0");
            }
            output.println(sb.toString());
        }
        output.println("cleartomark");
    }

    private static void printFontDictionary(CFFFont font, DataOutput output) throws IOException {
        String hexLine;
        output.println("10 dict begin");
        output.println("/FontInfo 10 dict dup begin");
        output.println("/version (" + font.getProperty("version") + ") readonly def");
        output.println("/Notice (" + font.getProperty("Notice") + ") readonly def");
        output.println("/FullName (" + font.getProperty("FullName") + ") readonly def");
        output.println("/FamilyName (" + font.getProperty("FamilyName") + ") readonly def");
        output.println("/Weight (" + font.getProperty("Weight") + ") readonly def");
        output.println("/ItalicAngle " + font.getProperty("ItalicAngle") + " def");
        output.println("/isFixedPitch " + font.getProperty("isFixedPitch") + " def");
        output.println("/UnderlinePosition " + font.getProperty("UnderlinePosition") + " def");
        output.println("/UnderlineThickness " + font.getProperty("UnderlineThickness") + " def");
        output.println("end readonly def");
        output.println("/FontName /" + font.getName() + " def");
        output.println("/PaintType " + font.getProperty("PaintType") + " def");
        output.println("/FontType 1 def");
        DecimalFormat matrixFormat = new DecimalFormat("0.########", new DecimalFormatSymbols(Locale.US));
        output.println("/FontMatrix " + Type1FontFormatter.formatArray(font.getProperty("FontMatrix"), matrixFormat, false) + " readonly def");
        output.println("/FontBBox " + Type1FontFormatter.formatArray(font.getProperty("FontBBox"), false) + " readonly def");
        output.println("/StrokeWidth " + font.getProperty("StrokeWidth") + " def");
        Collection<CFFFont.Mapping> mappings = font.getMappings();
        output.println("/Encoding 256 array");
        output.println("0 1 255 {1 index exch /.notdef put} for");
        for (CFFFont.Mapping mapping : mappings) {
            output.println("dup " + mapping.getCode() + " /" + mapping.getName() + " put");
        }
        output.println("readonly def");
        output.println("currentdict end");
        DataOutput eexecOutput = new DataOutput();
        Type1FontFormatter.printEexecFontDictionary(font, eexecOutput);
        output.println("currentfile eexec");
        byte[] eexecBytes = Type1FontUtil.eexecEncrypt(eexecOutput.getBytes());
        String hexString = Type1FontUtil.hexEncode(eexecBytes);
        for (int i2 = 0; i2 < hexString.length(); i2 += hexLine.length()) {
            hexLine = hexString.substring(i2, Math.min(i2 + 72, hexString.length()));
            output.println(hexLine);
        }
    }

    private static void printEexecFontDictionary(CFFFont font, DataOutput output) throws IOException {
        output.println("dup /Private 15 dict dup begin");
        output.println("/RD {string currentfile exch readstring pop} executeonly def");
        output.println("/ND {noaccess def} executeonly def");
        output.println("/NP {noaccess put} executeonly def");
        output.println("/BlueValues " + Type1FontFormatter.formatArray(font.getProperty("BlueValues"), true) + " ND");
        output.println("/OtherBlues " + Type1FontFormatter.formatArray(font.getProperty("OtherBlues"), true) + " ND");
        output.println("/BlueScale " + font.getProperty("BlueScale") + " def");
        output.println("/BlueShift " + font.getProperty("BlueShift") + " def");
        output.println("/BlueFuzz " + font.getProperty("BlueFuzz") + " def");
        output.println("/StdHW " + Type1FontFormatter.formatArray(font.getProperty("StdHW"), true) + " ND");
        output.println("/StdVW " + Type1FontFormatter.formatArray(font.getProperty("StdVW"), true) + " ND");
        output.println("/ForceBold " + font.getProperty("ForceBold") + " def");
        output.println("/MinFeature {16 16} def");
        output.println("/password 5839 def");
        Collection<CFFFont.Mapping> mappings = font.getMappings();
        output.println("2 index /CharStrings " + mappings.size() + " dict dup begin");
        Type1CharStringFormatter formatter = new Type1CharStringFormatter();
        for (CFFFont.Mapping mapping : mappings) {
            byte[] type1Bytes = formatter.format(mapping.toType1Sequence());
            byte[] charstringBytes = Type1FontUtil.charstringEncrypt(type1Bytes, 4);
            output.print("/" + mapping.getName() + " " + charstringBytes.length + " RD ");
            output.write(charstringBytes);
            output.print(" ND");
            output.println();
        }
        output.println("end");
        output.println("end");
        output.println("readonly put");
        output.println("noaccess put");
        output.println("dup /FontName get exch definefont pop");
        output.println("mark currentfile closefile");
    }

    private static String formatArray(Object object, boolean executable) {
        return Type1FontFormatter.formatArray(object, null, executable);
    }

    private static String formatArray(Object object, NumberFormat format, boolean executable) {
        StringBuffer sb = new StringBuffer();
        sb.append(executable ? "{" : "[");
        if (object instanceof Collection) {
            String sep = "";
            Collection elements = (Collection)object;
            for (Object element : elements) {
                sb.append(sep).append(Type1FontFormatter.formatElement(element, format));
                sep = " ";
            }
        } else if (object instanceof Number) {
            sb.append(Type1FontFormatter.formatElement(object, format));
        }
        sb.append(executable ? "}" : "]");
        return sb.toString();
    }

    private static String formatElement(Object object, NumberFormat format) {
        if (format != null) {
            if (object instanceof Double || object instanceof Float) {
                Number number = (Number)object;
                return format.format(number.doubleValue());
            }
            if (object instanceof Long || object instanceof Integer) {
                Number number = (Number)object;
                return format.format(number.longValue());
            }
        }
        return String.valueOf(object);
    }
}

