/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.util;

import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.exception.NotPositiveException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.util.FastMath;

public final class ArithmeticUtils {
    static final long[] FACTORIALS = new long[]{1L, 1L, 2L, 6L, 24L, 120L, 720L, 5040L, 40320L, 362880L, 3628800L, 39916800L, 479001600L, 6227020800L, 87178291200L, 1307674368000L, 20922789888000L, 355687428096000L, 6402373705728000L, 121645100408832000L, 2432902008176640000L};
    static final AtomicReference<long[][]> STIRLING_S2 = new AtomicReference<Object>(null);

    private ArithmeticUtils() {
    }

    public static int addAndCheck(int x, int y) throws MathArithmeticException {
        long s = (long)x + (long)y;
        if (s < Integer.MIN_VALUE || s > Integer.MAX_VALUE) {
            throw new MathArithmeticException(LocalizedFormats.OVERFLOW_IN_ADDITION, x, y);
        }
        return (int)s;
    }

    public static long addAndCheck(long a2, long b2) throws MathArithmeticException {
        return ArithmeticUtils.addAndCheck(a2, b2, LocalizedFormats.OVERFLOW_IN_ADDITION);
    }

    public static long binomialCoefficient(int n2, int k2) throws NotPositiveException, NumberIsTooLargeException, MathArithmeticException {
        ArithmeticUtils.checkBinomial(n2, k2);
        if (n2 == k2 || k2 == 0) {
            return 1L;
        }
        if (k2 == 1 || k2 == n2 - 1) {
            return n2;
        }
        if (k2 > n2 / 2) {
            return ArithmeticUtils.binomialCoefficient(n2, n2 - k2);
        }
        long result = 1L;
        if (n2 <= 61) {
            int i2 = n2 - k2 + 1;
            for (int j2 = 1; j2 <= k2; ++j2) {
                result = result * (long)i2 / (long)j2;
                ++i2;
            }
        } else if (n2 <= 66) {
            int i3 = n2 - k2 + 1;
            for (int j3 = 1; j3 <= k2; ++j3) {
                long d2 = ArithmeticUtils.gcd(i3, j3);
                result = result / ((long)j3 / d2) * ((long)i3 / d2);
                ++i3;
            }
        } else {
            int i4 = n2 - k2 + 1;
            for (int j4 = 1; j4 <= k2; ++j4) {
                long d3 = ArithmeticUtils.gcd(i4, j4);
                result = ArithmeticUtils.mulAndCheck(result / ((long)j4 / d3), (long)i4 / d3);
                ++i4;
            }
        }
        return result;
    }

    public static double binomialCoefficientDouble(int n2, int k2) throws NotPositiveException, NumberIsTooLargeException, MathArithmeticException {
        ArithmeticUtils.checkBinomial(n2, k2);
        if (n2 == k2 || k2 == 0) {
            return 1.0;
        }
        if (k2 == 1 || k2 == n2 - 1) {
            return n2;
        }
        if (k2 > n2 / 2) {
            return ArithmeticUtils.binomialCoefficientDouble(n2, n2 - k2);
        }
        if (n2 < 67) {
            return ArithmeticUtils.binomialCoefficient(n2, k2);
        }
        double result = 1.0;
        for (int i2 = 1; i2 <= k2; ++i2) {
            result *= (double)(n2 - k2 + i2) / (double)i2;
        }
        return FastMath.floor(result + 0.5);
    }

    public static double binomialCoefficientLog(int n2, int k2) throws NotPositiveException, NumberIsTooLargeException, MathArithmeticException {
        int i2;
        ArithmeticUtils.checkBinomial(n2, k2);
        if (n2 == k2 || k2 == 0) {
            return 0.0;
        }
        if (k2 == 1 || k2 == n2 - 1) {
            return FastMath.log(n2);
        }
        if (n2 < 67) {
            return FastMath.log(ArithmeticUtils.binomialCoefficient(n2, k2));
        }
        if (n2 < 1030) {
            return FastMath.log(ArithmeticUtils.binomialCoefficientDouble(n2, k2));
        }
        if (k2 > n2 / 2) {
            return ArithmeticUtils.binomialCoefficientLog(n2, n2 - k2);
        }
        double logSum = 0.0;
        for (i2 = n2 - k2 + 1; i2 <= n2; ++i2) {
            logSum += FastMath.log(i2);
        }
        for (i2 = 2; i2 <= k2; ++i2) {
            logSum -= FastMath.log(i2);
        }
        return logSum;
    }

    public static long factorial(int n2) throws NotPositiveException, MathArithmeticException {
        if (n2 < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.FACTORIAL_NEGATIVE_PARAMETER, n2);
        }
        if (n2 > 20) {
            throw new MathArithmeticException();
        }
        return FACTORIALS[n2];
    }

    public static double factorialDouble(int n2) throws NotPositiveException {
        if (n2 < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.FACTORIAL_NEGATIVE_PARAMETER, n2);
        }
        if (n2 < 21) {
            return FACTORIALS[n2];
        }
        return FastMath.floor(FastMath.exp(ArithmeticUtils.factorialLog(n2)) + 0.5);
    }

    public static double factorialLog(int n2) throws NotPositiveException {
        if (n2 < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.FACTORIAL_NEGATIVE_PARAMETER, n2);
        }
        if (n2 < 21) {
            return FastMath.log(FACTORIALS[n2]);
        }
        double logSum = 0.0;
        for (int i2 = 2; i2 <= n2; ++i2) {
            logSum += FastMath.log(i2);
        }
        return logSum;
    }

    public static int gcd(int p, int q) throws MathArithmeticException {
        int a2 = p;
        int b2 = q;
        if (a2 == 0 || b2 == 0) {
            if (a2 == Integer.MIN_VALUE || b2 == Integer.MIN_VALUE) {
                throw new MathArithmeticException(LocalizedFormats.GCD_OVERFLOW_32_BITS, p, q);
            }
            return FastMath.abs(a2 + b2);
        }
        long al = a2;
        long bl = b2;
        boolean useLong = false;
        if (a2 < 0) {
            if (Integer.MIN_VALUE == a2) {
                useLong = true;
            } else {
                a2 = -a2;
            }
            al = -al;
        }
        if (b2 < 0) {
            if (Integer.MIN_VALUE == b2) {
                useLong = true;
            } else {
                b2 = -b2;
            }
            bl = -bl;
        }
        if (useLong) {
            if (al == bl) {
                throw new MathArithmeticException(LocalizedFormats.GCD_OVERFLOW_32_BITS, p, q);
            }
            long blbu = bl;
            bl = al;
            if ((al = blbu % al) == 0L) {
                if (bl > Integer.MAX_VALUE) {
                    throw new MathArithmeticException(LocalizedFormats.GCD_OVERFLOW_32_BITS, p, q);
                }
                return (int)bl;
            }
            blbu = bl;
            b2 = (int)al;
            a2 = (int)(blbu % al);
        }
        return ArithmeticUtils.gcdPositive(a2, b2);
    }

    private static int gcdPositive(int a2, int b2) {
        if (a2 == 0) {
            return b2;
        }
        if (b2 == 0) {
            return a2;
        }
        int aTwos = Integer.numberOfTrailingZeros(a2);
        a2 >>= aTwos;
        int bTwos = Integer.numberOfTrailingZeros(b2);
        b2 >>= bTwos;
        int shift = Math.min(aTwos, bTwos);
        while (a2 != b2) {
            int delta = a2 - b2;
            b2 = Math.min(a2, b2);
            a2 = Math.abs(delta);
            a2 >>= Integer.numberOfTrailingZeros(a2);
        }
        return a2 << shift;
    }

    public static long gcd(long p, long q) throws MathArithmeticException {
        long t;
        int k2;
        long u = p;
        long v = q;
        if (u == 0L || v == 0L) {
            if (u == Long.MIN_VALUE || v == Long.MIN_VALUE) {
                throw new MathArithmeticException(LocalizedFormats.GCD_OVERFLOW_64_BITS, p, q);
            }
            return FastMath.abs(u) + FastMath.abs(v);
        }
        if (u > 0L) {
            u = -u;
        }
        if (v > 0L) {
            v = -v;
        }
        for (k2 = 0; (u & 1L) == 0L && (v & 1L) == 0L && k2 < 63; ++k2) {
            u /= 2L;
            v /= 2L;
        }
        if (k2 == 63) {
            throw new MathArithmeticException(LocalizedFormats.GCD_OVERFLOW_64_BITS, p, q);
        }
        long l2 = t = (u & 1L) == 1L ? v : -(u / 2L);
        while (true) {
            if ((t & 1L) == 0L) {
                t /= 2L;
                continue;
            }
            if (t > 0L) {
                u = -t;
            } else {
                v = t;
            }
            if ((t = (v - u) / 2L) == 0L) break;
        }
        return -u * (1L << k2);
    }

    public static int lcm(int a2, int b2) throws MathArithmeticException {
        if (a2 == 0 || b2 == 0) {
            return 0;
        }
        int lcm = FastMath.abs(ArithmeticUtils.mulAndCheck(a2 / ArithmeticUtils.gcd(a2, b2), b2));
        if (lcm == Integer.MIN_VALUE) {
            throw new MathArithmeticException(LocalizedFormats.LCM_OVERFLOW_32_BITS, a2, b2);
        }
        return lcm;
    }

    public static long lcm(long a2, long b2) throws MathArithmeticException {
        if (a2 == 0L || b2 == 0L) {
            return 0L;
        }
        long lcm = FastMath.abs(ArithmeticUtils.mulAndCheck(a2 / ArithmeticUtils.gcd(a2, b2), b2));
        if (lcm == Long.MIN_VALUE) {
            throw new MathArithmeticException(LocalizedFormats.LCM_OVERFLOW_64_BITS, a2, b2);
        }
        return lcm;
    }

    public static int mulAndCheck(int x, int y) throws MathArithmeticException {
        long m2 = (long)x * (long)y;
        if (m2 < Integer.MIN_VALUE || m2 > Integer.MAX_VALUE) {
            throw new MathArithmeticException();
        }
        return (int)m2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long mulAndCheck(long a2, long b2) throws MathArithmeticException {
        if (a2 > b2) {
            return ArithmeticUtils.mulAndCheck(b2, a2);
        }
        if (a2 < 0L) {
            if (b2 < 0L) {
                if (a2 < Long.MAX_VALUE / b2) throw new MathArithmeticException();
                return a2 * b2;
            }
            if (b2 <= 0L) return 0L;
            if (Long.MIN_VALUE / b2 > a2) throw new MathArithmeticException();
            return a2 * b2;
        }
        if (a2 <= 0L) return 0L;
        if (a2 > Long.MAX_VALUE / b2) throw new MathArithmeticException();
        return a2 * b2;
    }

    public static int subAndCheck(int x, int y) throws MathArithmeticException {
        long s = (long)x - (long)y;
        if (s < Integer.MIN_VALUE || s > Integer.MAX_VALUE) {
            throw new MathArithmeticException(LocalizedFormats.OVERFLOW_IN_SUBTRACTION, x, y);
        }
        return (int)s;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long subAndCheck(long a2, long b2) throws MathArithmeticException {
        if (b2 != Long.MIN_VALUE) return ArithmeticUtils.addAndCheck(a2, -b2, LocalizedFormats.OVERFLOW_IN_ADDITION);
        if (a2 >= 0L) throw new MathArithmeticException(LocalizedFormats.OVERFLOW_IN_ADDITION, a2, -b2);
        return a2 - b2;
    }

    public static int pow(int k2, int e2) throws NotPositiveException {
        if (e2 < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.EXPONENT, e2);
        }
        int result = 1;
        int k2p = k2;
        while (e2 != 0) {
            if ((e2 & 1) != 0) {
                result *= k2p;
            }
            k2p *= k2p;
            e2 >>= 1;
        }
        return result;
    }

    public static int pow(int k2, long e2) throws NotPositiveException {
        if (e2 < 0L) {
            throw new NotPositiveException((Localizable)LocalizedFormats.EXPONENT, e2);
        }
        int result = 1;
        int k2p = k2;
        while (e2 != 0L) {
            if ((e2 & 1L) != 0L) {
                result *= k2p;
            }
            k2p *= k2p;
            e2 >>= 1;
        }
        return result;
    }

    public static long pow(long k2, int e2) throws NotPositiveException {
        if (e2 < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.EXPONENT, e2);
        }
        long result = 1L;
        long k2p = k2;
        while (e2 != 0) {
            if ((e2 & 1) != 0) {
                result *= k2p;
            }
            k2p *= k2p;
            e2 >>= 1;
        }
        return result;
    }

    public static long pow(long k2, long e2) throws NotPositiveException {
        if (e2 < 0L) {
            throw new NotPositiveException((Localizable)LocalizedFormats.EXPONENT, e2);
        }
        long result = 1L;
        long k2p = k2;
        while (e2 != 0L) {
            if ((e2 & 1L) != 0L) {
                result *= k2p;
            }
            k2p *= k2p;
            e2 >>= 1;
        }
        return result;
    }

    public static BigInteger pow(BigInteger k2, int e2) throws NotPositiveException {
        if (e2 < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.EXPONENT, e2);
        }
        return k2.pow(e2);
    }

    public static BigInteger pow(BigInteger k2, long e2) throws NotPositiveException {
        if (e2 < 0L) {
            throw new NotPositiveException((Localizable)LocalizedFormats.EXPONENT, e2);
        }
        BigInteger result = BigInteger.ONE;
        BigInteger k2p = k2;
        while (e2 != 0L) {
            if ((e2 & 1L) != 0L) {
                result = result.multiply(k2p);
            }
            k2p = k2p.multiply(k2p);
            e2 >>= 1;
        }
        return result;
    }

    public static BigInteger pow(BigInteger k2, BigInteger e2) throws NotPositiveException {
        if (e2.compareTo(BigInteger.ZERO) < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.EXPONENT, e2);
        }
        BigInteger result = BigInteger.ONE;
        BigInteger k2p = k2;
        while (!BigInteger.ZERO.equals(e2)) {
            if (e2.testBit(0)) {
                result = result.multiply(k2p);
            }
            k2p = k2p.multiply(k2p);
            e2 = e2.shiftRight(1);
        }
        return result;
    }

    public static long stirlingS2(int n2, int k2) throws NotPositiveException, NumberIsTooLargeException, MathArithmeticException {
        if (k2 < 0) {
            throw new NotPositiveException(k2);
        }
        if (k2 > n2) {
            throw new NumberIsTooLargeException(k2, (Number)n2, true);
        }
        Object stirlingS2 = STIRLING_S2.get();
        if (stirlingS2 == null) {
            int maxIndex = 26;
            stirlingS2 = new long[26][];
            stirlingS2[0] = new long[]{1L};
            for (int i2 = 1; i2 < ((long[][])stirlingS2).length; ++i2) {
                stirlingS2[i2] = new long[i2 + 1];
                stirlingS2[i2][0] = 0L;
                stirlingS2[i2][1] = 1L;
                stirlingS2[i2][i2] = 1L;
                for (int j2 = 2; j2 < i2; ++j2) {
                    stirlingS2[i2][j2] = (long)j2 * stirlingS2[i2 - 1][j2] + stirlingS2[i2 - 1][j2 - 1];
                }
            }
            STIRLING_S2.compareAndSet((long[][])null, (long[][])stirlingS2);
        }
        if (n2 < ((long[][])stirlingS2).length) {
            return stirlingS2[n2][k2];
        }
        if (k2 == 0) {
            return 0L;
        }
        if (k2 == 1 || k2 == n2) {
            return 1L;
        }
        if (k2 == 2) {
            return (1L << n2 - 1) - 1L;
        }
        if (k2 == n2 - 1) {
            return ArithmeticUtils.binomialCoefficient(n2, 2);
        }
        long sum = 0L;
        long sign = (k2 & 1) == 0 ? 1L : -1L;
        for (int j3 = 1; j3 <= k2; ++j3) {
            if ((sum += (sign = -sign) * ArithmeticUtils.binomialCoefficient(k2, j3) * (long)ArithmeticUtils.pow(j3, n2)) >= 0L) continue;
            throw new MathArithmeticException(LocalizedFormats.ARGUMENT_OUTSIDE_DOMAIN, n2, 0, ((long[][])stirlingS2).length - 1);
        }
        return sum / ArithmeticUtils.factorial(k2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static long addAndCheck(long a2, long b2, Localizable pattern) throws MathArithmeticException {
        if (a2 > b2) {
            return ArithmeticUtils.addAndCheck(b2, a2, pattern);
        }
        if (a2 < 0L) {
            if (b2 >= 0L) return a2 + b2;
            if (Long.MIN_VALUE - b2 > a2) throw new MathArithmeticException(pattern, a2, b2);
            return a2 + b2;
        }
        if (a2 > Long.MAX_VALUE - b2) throw new MathArithmeticException(pattern, a2, b2);
        return a2 + b2;
    }

    private static void checkBinomial(int n2, int k2) throws NumberIsTooLargeException, NotPositiveException {
        if (n2 < k2) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.BINOMIAL_INVALID_PARAMETERS_ORDER, (Number)k2, n2, true);
        }
        if (n2 < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.BINOMIAL_NEGATIVE_PARAMETER, n2);
        }
    }

    public static boolean isPowerOfTwo(long n2) {
        return n2 > 0L && (n2 & n2 - 1L) == 0L;
    }
}

