/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.transform;

import java.io.Serializable;
import org.apache.commons.math3.analysis.FunctionUtils;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.transform.DftNormalization;
import org.apache.commons.math3.transform.DstNormalization;
import org.apache.commons.math3.transform.FastFourierTransformer;
import org.apache.commons.math3.transform.RealTransformer;
import org.apache.commons.math3.transform.TransformType;
import org.apache.commons.math3.transform.TransformUtils;
import org.apache.commons.math3.util.ArithmeticUtils;
import org.apache.commons.math3.util.FastMath;

public class FastSineTransformer
implements RealTransformer,
Serializable {
    static final long serialVersionUID = 20120211L;
    private final DstNormalization normalization;

    public FastSineTransformer(DstNormalization normalization) {
        this.normalization = normalization;
    }

    public double[] transform(double[] f2, TransformType type) {
        if (this.normalization == DstNormalization.ORTHOGONAL_DST_I) {
            double s = FastMath.sqrt(2.0 / (double)f2.length);
            return TransformUtils.scaleArray(this.fst(f2), s);
        }
        if (type == TransformType.FORWARD) {
            return this.fst(f2);
        }
        double s = 2.0 / (double)f2.length;
        return TransformUtils.scaleArray(this.fst(f2), s);
    }

    public double[] transform(UnivariateFunction f2, double min, double max, int n2, TransformType type) {
        double[] data = FunctionUtils.sample(f2, min, max, n2);
        data[0] = 0.0;
        return this.transform(data, type);
    }

    protected double[] fst(double[] f2) throws MathIllegalArgumentException {
        double[] transformed = new double[f2.length];
        if (!ArithmeticUtils.isPowerOfTwo(f2.length)) {
            throw new MathIllegalArgumentException(LocalizedFormats.NOT_POWER_OF_TWO_CONSIDER_PADDING, f2.length);
        }
        if (f2[0] != 0.0) {
            throw new MathIllegalArgumentException(LocalizedFormats.FIRST_ELEMENT_NOT_ZERO, f2[0]);
        }
        int n2 = f2.length;
        if (n2 == 1) {
            transformed[0] = 0.0;
            return transformed;
        }
        double[] x = new double[n2];
        x[0] = 0.0;
        x[n2 >> 1] = 2.0 * f2[n2 >> 1];
        for (int i2 = 1; i2 < n2 >> 1; ++i2) {
            double a2 = FastMath.sin((double)i2 * Math.PI / (double)n2) * (f2[i2] + f2[n2 - i2]);
            double b2 = 0.5 * (f2[i2] - f2[n2 - i2]);
            x[i2] = a2 + b2;
            x[n2 - i2] = a2 - b2;
        }
        FastFourierTransformer transformer = new FastFourierTransformer(DftNormalization.STANDARD);
        Complex[] y = transformer.transform(x, TransformType.FORWARD);
        transformed[0] = 0.0;
        transformed[1] = 0.5 * y[0].getReal();
        for (int i3 = 1; i3 < n2 >> 1; ++i3) {
            transformed[2 * i3] = -y[i3].getImaginary();
            transformed[2 * i3 + 1] = y[i3].getReal() + transformed[2 * i3 - 1];
        }
        return transformed;
    }
}

