/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.primes;

import java.util.List;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.primes.SmallPrimes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Primes {
    private Primes() {
    }

    public static boolean isPrime(int n2) {
        if (n2 < 2) {
            return false;
        }
        for (int p : SmallPrimes.PRIMES) {
            if (0 != n2 % p) continue;
            return n2 == p;
        }
        return SmallPrimes.millerRabinPrimeTest(n2);
    }

    public static int nextPrime(int n2) {
        if (n2 < 0) {
            throw new MathIllegalArgumentException(LocalizedFormats.NUMBER_TOO_SMALL, n2, 0);
        }
        if (n2 == 2) {
            return 2;
        }
        if ((n2 |= 1) == 1) {
            return 2;
        }
        if (Primes.isPrime(n2)) {
            return n2;
        }
        int rem = n2 % 3;
        if (0 == rem) {
            n2 += 2;
        } else if (1 == rem) {
            n2 += 4;
        }
        while (!Primes.isPrime(n2)) {
            if (Primes.isPrime(n2 += 2)) {
                return n2;
            }
            n2 += 4;
        }
        return n2;
    }

    public static List<Integer> primeFactors(int n2) {
        if (n2 < 2) {
            throw new MathIllegalArgumentException(LocalizedFormats.NUMBER_TOO_SMALL, n2, 2);
        }
        return SmallPrimes.trialDivision(n2);
    }
}

