/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optimization.general;

import org.apache.commons.math3.analysis.DifferentiableMultivariateVectorFunction;
import org.apache.commons.math3.analysis.FunctionUtils;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.analysis.differentiation.MultivariateDifferentiableVectorFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.DiagonalMatrix;
import org.apache.commons.math3.linear.EigenDecomposition;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.QRDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.optimization.ConvergenceChecker;
import org.apache.commons.math3.optimization.DifferentiableMultivariateVectorOptimizer;
import org.apache.commons.math3.optimization.InitialGuess;
import org.apache.commons.math3.optimization.OptimizationData;
import org.apache.commons.math3.optimization.PointVectorValuePair;
import org.apache.commons.math3.optimization.Target;
import org.apache.commons.math3.optimization.Weight;
import org.apache.commons.math3.optimization.direct.BaseAbstractMultivariateVectorOptimizer;
import org.apache.commons.math3.util.FastMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public abstract class AbstractLeastSquaresOptimizer
extends BaseAbstractMultivariateVectorOptimizer<DifferentiableMultivariateVectorFunction>
implements DifferentiableMultivariateVectorOptimizer {
    @Deprecated
    private static final double DEFAULT_SINGULARITY_THRESHOLD = 1.0E-14;
    @Deprecated
    protected double[][] weightedResidualJacobian;
    @Deprecated
    protected int cols;
    @Deprecated
    protected int rows;
    @Deprecated
    protected double[] point;
    @Deprecated
    protected double[] objective;
    @Deprecated
    protected double[] weightedResiduals;
    @Deprecated
    protected double cost;
    private MultivariateDifferentiableVectorFunction jF;
    private int jacobianEvaluations;
    private RealMatrix weightMatrixSqrt;

    @Deprecated
    protected AbstractLeastSquaresOptimizer() {
    }

    protected AbstractLeastSquaresOptimizer(ConvergenceChecker<PointVectorValuePair> checker) {
        super(checker);
    }

    public int getJacobianEvaluations() {
        return this.jacobianEvaluations;
    }

    @Deprecated
    protected void updateJacobian() {
        RealMatrix weightedJacobian = this.computeWeightedJacobian(this.point);
        this.weightedResidualJacobian = weightedJacobian.scalarMultiply(-1.0).getData();
    }

    protected RealMatrix computeWeightedJacobian(double[] params) {
        int nR;
        ++this.jacobianEvaluations;
        DerivativeStructure[] dsPoint = new DerivativeStructure[params.length];
        int nC = params.length;
        for (int i2 = 0; i2 < nC; ++i2) {
            dsPoint[i2] = new DerivativeStructure(nC, 1, i2, params[i2]);
        }
        DerivativeStructure[] dsValue = this.jF.value(dsPoint);
        if (dsValue.length != (nR = this.getTarget().length)) {
            throw new DimensionMismatchException(dsValue.length, nR);
        }
        double[][] jacobianData = new double[nR][nC];
        for (int i3 = 0; i3 < nR; ++i3) {
            int[] orders = new int[nC];
            for (int j2 = 0; j2 < nC; ++j2) {
                orders[j2] = 1;
                jacobianData[i3][j2] = dsValue[i3].getPartialDerivative(orders);
                orders[j2] = 0;
            }
        }
        return this.weightMatrixSqrt.multiply(MatrixUtils.createRealMatrix(jacobianData));
    }

    @Deprecated
    protected void updateResidualsAndCost() {
        this.objective = this.computeObjectiveValue(this.point);
        double[] res = this.computeResiduals(this.objective);
        this.cost = this.computeCost(res);
        ArrayRealVector residuals = new ArrayRealVector(res);
        this.weightedResiduals = this.weightMatrixSqrt.operate(residuals).toArray();
    }

    protected double computeCost(double[] residuals) {
        ArrayRealVector r = new ArrayRealVector(residuals);
        return FastMath.sqrt(r.dotProduct(this.getWeight().operate(r)));
    }

    public double getRMS() {
        return FastMath.sqrt(this.getChiSquare() / (double)this.rows);
    }

    public double getChiSquare() {
        return this.cost * this.cost;
    }

    public RealMatrix getWeightSquareRoot() {
        return this.weightMatrixSqrt.copy();
    }

    protected void setCost(double cost) {
        this.cost = cost;
    }

    @Deprecated
    public double[][] getCovariances() {
        return this.getCovariances(1.0E-14);
    }

    @Deprecated
    public double[][] getCovariances(double threshold) {
        return this.computeCovariances(this.point, threshold);
    }

    public double[][] computeCovariances(double[] params, double threshold) {
        RealMatrix j2 = this.computeWeightedJacobian(params);
        RealMatrix jTj = j2.transpose().multiply(j2);
        DecompositionSolver solver = new QRDecomposition(jTj, threshold).getSolver();
        return solver.getInverse().getData();
    }

    @Deprecated
    public double[] guessParametersErrors() {
        if (this.rows <= this.cols) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.NO_DEGREES_OF_FREEDOM, (Number)this.rows, this.cols, false);
        }
        double[] errors = new double[this.cols];
        double c2 = FastMath.sqrt(this.getChiSquare() / (double)(this.rows - this.cols));
        double[][] covar = this.computeCovariances(this.point, 1.0E-14);
        for (int i2 = 0; i2 < errors.length; ++i2) {
            errors[i2] = FastMath.sqrt(covar[i2][i2]) * c2;
        }
        return errors;
    }

    public double[] computeSigma(double[] params, double covarianceSingularityThreshold) {
        int nC = params.length;
        double[] sig = new double[nC];
        double[][] cov = this.computeCovariances(params, covarianceSingularityThreshold);
        for (int i2 = 0; i2 < nC; ++i2) {
            sig[i2] = FastMath.sqrt(cov[i2][i2]);
        }
        return sig;
    }

    @Override
    @Deprecated
    public PointVectorValuePair optimize(int maxEval, DifferentiableMultivariateVectorFunction f2, double[] target, double[] weights, double[] startPoint) {
        return this.optimizeInternal(maxEval, FunctionUtils.toMultivariateDifferentiableVectorFunction(f2), new OptimizationData[]{new Target(target), new Weight(weights), new InitialGuess(startPoint)});
    }

    @Override
    @Deprecated
    public PointVectorValuePair optimize(int maxEval, MultivariateDifferentiableVectorFunction f2, double[] target, double[] weights, double[] startPoint) {
        return this.optimizeInternal(maxEval, f2, new OptimizationData[]{new Target(target), new Weight(weights), new InitialGuess(startPoint)});
    }

    @Override
    @Deprecated
    protected PointVectorValuePair optimizeInternal(int maxEval, MultivariateDifferentiableVectorFunction f2, OptimizationData ... optData) {
        return super.optimizeInternal(maxEval, FunctionUtils.toDifferentiableMultivariateVectorFunction(f2), optData);
    }

    @Override
    protected void setUp() {
        super.setUp();
        this.jacobianEvaluations = 0;
        this.weightMatrixSqrt = this.squareRoot(this.getWeight());
        this.jF = FunctionUtils.toMultivariateDifferentiableVectorFunction((DifferentiableMultivariateVectorFunction)this.getObjectiveFunction());
        this.point = this.getStartPoint();
        this.rows = this.getTarget().length;
        this.cols = this.point.length;
    }

    protected double[] computeResiduals(double[] objectiveValue) {
        double[] target = this.getTarget();
        if (objectiveValue.length != target.length) {
            throw new DimensionMismatchException(target.length, objectiveValue.length);
        }
        double[] residuals = new double[target.length];
        for (int i2 = 0; i2 < target.length; ++i2) {
            residuals[i2] = target[i2] - objectiveValue[i2];
        }
        return residuals;
    }

    private RealMatrix squareRoot(RealMatrix m2) {
        if (m2 instanceof DiagonalMatrix) {
            int dim = m2.getRowDimension();
            DiagonalMatrix sqrtM = new DiagonalMatrix(dim);
            for (int i2 = 0; i2 < dim; ++i2) {
                sqrtM.setEntry(i2, i2, FastMath.sqrt(m2.getEntry(i2, i2)));
            }
            return sqrtM;
        }
        EigenDecomposition dec = new EigenDecomposition(m2);
        return dec.getSquareRoot();
    }
}

