/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optimization.fitting;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.analysis.DifferentiableMultivariateVectorFunction;
import org.apache.commons.math3.analysis.MultivariateMatrixFunction;
import org.apache.commons.math3.analysis.ParametricUnivariateFunction;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.analysis.differentiation.MultivariateDifferentiableVectorFunction;
import org.apache.commons.math3.optimization.DifferentiableMultivariateVectorOptimizer;
import org.apache.commons.math3.optimization.MultivariateDifferentiableVectorOptimizer;
import org.apache.commons.math3.optimization.PointVectorValuePair;
import org.apache.commons.math3.optimization.fitting.WeightedObservedPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class CurveFitter<T extends ParametricUnivariateFunction> {
    @Deprecated
    private final DifferentiableMultivariateVectorOptimizer oldOptimizer;
    private final MultivariateDifferentiableVectorOptimizer optimizer;
    private final List<WeightedObservedPoint> observations;

    public CurveFitter(DifferentiableMultivariateVectorOptimizer optimizer) {
        this.oldOptimizer = optimizer;
        this.optimizer = null;
        this.observations = new ArrayList<WeightedObservedPoint>();
    }

    public CurveFitter(MultivariateDifferentiableVectorOptimizer optimizer) {
        this.oldOptimizer = null;
        this.optimizer = optimizer;
        this.observations = new ArrayList<WeightedObservedPoint>();
    }

    public void addObservedPoint(double x, double y) {
        this.addObservedPoint(1.0, x, y);
    }

    public void addObservedPoint(double weight, double x, double y) {
        this.observations.add(new WeightedObservedPoint(weight, x, y));
    }

    public void addObservedPoint(WeightedObservedPoint observed) {
        this.observations.add(observed);
    }

    public WeightedObservedPoint[] getObservations() {
        return this.observations.toArray(new WeightedObservedPoint[this.observations.size()]);
    }

    public void clearObservations() {
        this.observations.clear();
    }

    public double[] fit(T f2, double[] initialGuess) {
        return this.fit(Integer.MAX_VALUE, f2, initialGuess);
    }

    public double[] fit(int maxEval, T f2, double[] initialGuess) {
        double[] target = new double[this.observations.size()];
        double[] weights = new double[this.observations.size()];
        int i2 = 0;
        for (WeightedObservedPoint point : this.observations) {
            target[i2] = point.getY();
            weights[i2] = point.getWeight();
            ++i2;
        }
        PointVectorValuePair optimum = this.optimizer == null ? this.oldOptimizer.optimize(maxEval, new OldTheoreticalValuesFunction((ParametricUnivariateFunction)f2), target, weights, initialGuess) : this.optimizer.optimize(maxEval, new TheoreticalValuesFunction((ParametricUnivariateFunction)f2), target, weights, initialGuess);
        return optimum.getPointRef();
    }

    private class TheoreticalValuesFunction
    implements MultivariateDifferentiableVectorFunction {
        private final ParametricUnivariateFunction f;

        public TheoreticalValuesFunction(ParametricUnivariateFunction f2) {
            this.f = f2;
        }

        public double[] value(double[] point) {
            double[] values = new double[CurveFitter.this.observations.size()];
            int i2 = 0;
            for (WeightedObservedPoint observed : CurveFitter.this.observations) {
                values[i2++] = this.f.value(observed.getX(), point);
            }
            return values;
        }

        public DerivativeStructure[] value(DerivativeStructure[] point) {
            double[] parameters = new double[point.length];
            for (int k2 = 0; k2 < point.length; ++k2) {
                parameters[k2] = point[k2].getValue();
            }
            DerivativeStructure[] values = new DerivativeStructure[CurveFitter.this.observations.size()];
            int i2 = 0;
            for (WeightedObservedPoint observed : CurveFitter.this.observations) {
                DerivativeStructure vi = new DerivativeStructure(point.length, 1, this.f.value(observed.getX(), parameters));
                for (int k3 = 0; k3 < point.length; ++k3) {
                    vi = vi.add(new DerivativeStructure(point.length, 1, k3, 0.0));
                }
                values[i2++] = vi;
            }
            return values;
        }
    }

    @Deprecated
    private class OldTheoreticalValuesFunction
    implements DifferentiableMultivariateVectorFunction {
        private final ParametricUnivariateFunction f;

        public OldTheoreticalValuesFunction(ParametricUnivariateFunction f2) {
            this.f = f2;
        }

        public MultivariateMatrixFunction jacobian() {
            return new MultivariateMatrixFunction(){

                public double[][] value(double[] point) {
                    double[][] jacobian = new double[CurveFitter.this.observations.size()][];
                    int i2 = 0;
                    for (WeightedObservedPoint observed : CurveFitter.this.observations) {
                        jacobian[i2++] = OldTheoreticalValuesFunction.this.f.gradient(observed.getX(), point);
                    }
                    return jacobian;
                }
            };
        }

        public double[] value(double[] point) {
            double[] values = new double[CurveFitter.this.observations.size()];
            int i2 = 0;
            for (WeightedObservedPoint observed : CurveFitter.this.observations) {
                values[i2++] = this.f.value(observed.getX(), point);
            }
            return values;
        }
    }
}

