/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.exception.NoBracketingException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.ode.AbstractIntegrator;
import org.apache.commons.math3.ode.ExpandableStatefulODE;
import org.apache.commons.math3.ode.nonstiff.RungeKuttaStepInterpolator;
import org.apache.commons.math3.util.FastMath;

public abstract class RungeKuttaIntegrator
extends AbstractIntegrator {
    private final double[] c;
    private final double[][] a;
    private final double[] b;
    private final RungeKuttaStepInterpolator prototype;
    private final double step;

    protected RungeKuttaIntegrator(String name, double[] c2, double[][] a2, double[] b2, RungeKuttaStepInterpolator prototype, double step) {
        super(name);
        this.c = c2;
        this.a = a2;
        this.b = b2;
        this.prototype = prototype;
        this.step = FastMath.abs(step);
    }

    public void integrate(ExpandableStatefulODE equations, double t) throws NumberIsTooSmallException, DimensionMismatchException, MaxCountExceededException, NoBracketingException {
        this.sanityChecks(equations, t);
        this.setEquations(equations);
        boolean forward = t > equations.getTime();
        double[] y0 = equations.getCompleteState();
        double[] y = (double[])y0.clone();
        int stages = this.c.length + 1;
        double[][] yDotK = new double[stages][];
        for (int i2 = 0; i2 < stages; ++i2) {
            yDotK[i2] = new double[y0.length];
        }
        double[] yTmp = (double[])y0.clone();
        double[] yDotTmp = new double[y0.length];
        RungeKuttaStepInterpolator interpolator = (RungeKuttaStepInterpolator)this.prototype.copy();
        interpolator.reinitialize(this, yTmp, yDotK, forward, equations.getPrimaryMapper(), equations.getSecondaryMappers());
        interpolator.storeTime(equations.getTime());
        this.stepStart = equations.getTime();
        this.stepSize = forward ? this.step : -this.step;
        this.initIntegration(equations.getTime(), y0, t);
        this.isLastStep = false;
        do {
            boolean nextIsLast;
            interpolator.shift();
            this.computeDerivatives(this.stepStart, y, yDotK[0]);
            for (int k2 = 1; k2 < stages; ++k2) {
                for (int j2 = 0; j2 < y0.length; ++j2) {
                    double sum = this.a[k2 - 1][0] * yDotK[0][j2];
                    for (int l2 = 1; l2 < k2; ++l2) {
                        sum += this.a[k2 - 1][l2] * yDotK[l2][j2];
                    }
                    yTmp[j2] = y[j2] + this.stepSize * sum;
                }
                this.computeDerivatives(this.stepStart + this.c[k2 - 1] * this.stepSize, yTmp, yDotK[k2]);
            }
            for (int j3 = 0; j3 < y0.length; ++j3) {
                double sum = this.b[0] * yDotK[0][j3];
                for (int l3 = 1; l3 < stages; ++l3) {
                    sum += this.b[l3] * yDotK[l3][j3];
                }
                yTmp[j3] = y[j3] + this.stepSize * sum;
            }
            interpolator.storeTime(this.stepStart + this.stepSize);
            System.arraycopy(yTmp, 0, y, 0, y0.length);
            System.arraycopy(yDotK[stages - 1], 0, yDotTmp, 0, y0.length);
            this.stepStart = this.acceptStep(interpolator, y, yDotTmp, t);
            if (this.isLastStep) continue;
            interpolator.storeTime(this.stepStart);
            double nextT = this.stepStart + this.stepSize;
            boolean bl = forward ? nextT >= t : (nextIsLast = nextT <= t);
            if (!nextIsLast) continue;
            this.stepSize = t - this.stepStart;
        } while (!this.isLastStep);
        equations.setTime(this.stepStart);
        equations.setCompleteState(y);
        this.stepStart = Double.NaN;
        this.stepSize = Double.NaN;
    }
}

