/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math3.FieldElement;
import org.apache.commons.math3.fraction.BigFraction;
import org.apache.commons.math3.linear.Array2DRowFieldMatrix;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayFieldVector;
import org.apache.commons.math3.linear.FieldDecompositionSolver;
import org.apache.commons.math3.linear.FieldLUDecomposition;
import org.apache.commons.math3.linear.FieldMatrix;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.QRDecomposition;
import org.apache.commons.math3.linear.RealMatrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdamsNordsieckTransformer {
    private static final Map<Integer, AdamsNordsieckTransformer> CACHE = new HashMap<Integer, AdamsNordsieckTransformer>();
    private final Array2DRowRealMatrix update;
    private final double[] c1;

    private AdamsNordsieckTransformer(int nSteps) {
        FieldMatrix<BigFraction> bigP = this.buildP(nSteps);
        FieldDecompositionSolver<BigFraction> pSolver = new FieldLUDecomposition<BigFraction>(bigP).getSolver();
        Object[] u = new BigFraction[nSteps];
        Arrays.fill(u, BigFraction.ONE);
        BigFraction[] bigC1 = (BigFraction[])pSolver.solve(new ArrayFieldVector((FieldElement[])u, false)).toArray();
        FieldElement[][] shiftedP = (BigFraction[][])bigP.getData();
        for (int i2 = shiftedP.length - 1; i2 > 0; --i2) {
            shiftedP[i2] = shiftedP[i2 - 1];
        }
        shiftedP[0] = new BigFraction[nSteps];
        Arrays.fill(shiftedP[0], BigFraction.ZERO);
        FieldMatrix<BigFraction> bigMSupdate = pSolver.solve(new Array2DRowFieldMatrix(shiftedP, false));
        this.update = MatrixUtils.bigFractionMatrixToRealMatrix(bigMSupdate);
        this.c1 = new double[nSteps];
        for (int i3 = 0; i3 < nSteps; ++i3) {
            this.c1[i3] = bigC1[i3].doubleValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AdamsNordsieckTransformer getInstance(int nSteps) {
        Map<Integer, AdamsNordsieckTransformer> map = CACHE;
        synchronized (map) {
            AdamsNordsieckTransformer t = CACHE.get(nSteps);
            if (t == null) {
                t = new AdamsNordsieckTransformer(nSteps);
                CACHE.put(nSteps, t);
            }
            return t;
        }
    }

    public int getNSteps() {
        return this.c1.length;
    }

    private FieldMatrix<BigFraction> buildP(int nSteps) {
        FieldElement[][] pData = new BigFraction[nSteps][nSteps];
        for (int i2 = 0; i2 < pData.length; ++i2) {
            int factor;
            BigFraction[] pI = pData[i2];
            int aj = factor = -(i2 + 1);
            for (int j2 = 0; j2 < pI.length; ++j2) {
                pI[j2] = new BigFraction(aj * (j2 + 2));
                aj *= factor;
            }
        }
        return new Array2DRowFieldMatrix(pData, false);
    }

    public Array2DRowRealMatrix initializeHighOrderDerivatives(double h2, double[] t, double[][] y, double[][] yDot) {
        double[][] a2 = new double[2 * (y.length - 1)][this.c1.length];
        double[][] b2 = new double[2 * (y.length - 1)][y[0].length];
        double[] y0 = y[0];
        double[] yDot0 = yDot[0];
        for (int i2 = 1; i2 < y.length; ++i2) {
            double di = t[i2] - t[0];
            double ratio = di / h2;
            double dikM1Ohk = 1.0 / h2;
            double[] aI = a2[2 * i2 - 2];
            double[] aDotI = a2[2 * i2 - 1];
            for (int j2 = 0; j2 < aI.length; ++j2) {
                aI[j2] = di * (dikM1Ohk *= ratio);
                aDotI[j2] = (double)(j2 + 2) * dikM1Ohk;
            }
            double[] yI = y[i2];
            double[] yDotI = yDot[i2];
            double[] bI = b2[2 * i2 - 2];
            double[] bDotI = b2[2 * i2 - 1];
            for (int j3 = 0; j3 < yI.length; ++j3) {
                bI[j3] = yI[j3] - y0[j3] - di * yDot0[j3];
                bDotI[j3] = yDotI[j3] - yDot0[j3];
            }
        }
        QRDecomposition decomposition = new QRDecomposition(new Array2DRowRealMatrix(a2, false));
        RealMatrix x = decomposition.getSolver().solve(new Array2DRowRealMatrix(b2, false));
        return new Array2DRowRealMatrix(x.getData(), false);
    }

    public Array2DRowRealMatrix updateHighOrderDerivativesPhase1(Array2DRowRealMatrix highOrder) {
        return this.update.multiply(highOrder);
    }

    public void updateHighOrderDerivativesPhase2(double[] start, double[] end, Array2DRowRealMatrix highOrder) {
        double[][] data = highOrder.getDataRef();
        for (int i2 = 0; i2 < data.length; ++i2) {
            double[] dataI = data[i2];
            double c1I = this.c1[i2];
            for (int j2 = 0; j2 < dataI.length; ++j2) {
                int n2 = j2;
                dataI[n2] = dataI[n2] + c1I * (start[j2] - end[j2]);
            }
        }
    }
}

