/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.QRDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.util.FastMath;

public class RRQRDecomposition
extends QRDecomposition {
    private int[] p;
    private RealMatrix cachedP;

    public RRQRDecomposition(RealMatrix matrix) {
        this(matrix, 0.0);
    }

    public RRQRDecomposition(RealMatrix matrix, double threshold) {
        super(matrix, threshold);
    }

    protected void decompose(double[][] qrt) {
        this.p = new int[qrt.length];
        for (int i2 = 0; i2 < this.p.length; ++i2) {
            this.p[i2] = i2;
        }
        super.decompose(qrt);
    }

    protected void performHouseholderReflection(int minor, double[][] qrt) {
        double l2NormSquaredMax = 0.0;
        int l2NormSquaredMaxIndex = minor;
        for (int i2 = minor; i2 < qrt.length; ++i2) {
            double l2NormSquared = 0.0;
            for (int j2 = 0; j2 < qrt[i2].length; ++j2) {
                l2NormSquared += qrt[i2][j2] * qrt[i2][j2];
            }
            if (!(l2NormSquared > l2NormSquaredMax)) continue;
            l2NormSquaredMax = l2NormSquared;
            l2NormSquaredMaxIndex = i2;
        }
        if (l2NormSquaredMaxIndex != minor) {
            double[] tmp1 = qrt[minor];
            qrt[minor] = qrt[l2NormSquaredMaxIndex];
            qrt[l2NormSquaredMaxIndex] = tmp1;
            int tmp2 = this.p[minor];
            this.p[minor] = this.p[l2NormSquaredMaxIndex];
            this.p[l2NormSquaredMaxIndex] = tmp2;
        }
        super.performHouseholderReflection(minor, qrt);
    }

    public RealMatrix getP() {
        if (this.cachedP == null) {
            int n2 = this.p.length;
            this.cachedP = MatrixUtils.createRealMatrix(n2, n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                this.cachedP.setEntry(this.p[i2], i2, 1.0);
            }
        }
        return this.cachedP;
    }

    public int getRank(double dropThreshold) {
        double thisNorm;
        int rank;
        double lastNorm;
        RealMatrix r = this.getR();
        int rows = r.getRowDimension();
        int columns = r.getColumnDimension();
        double rNorm = lastNorm = r.getFrobeniusNorm();
        for (rank = 1; rank < FastMath.min(rows, columns) && (thisNorm = r.getSubMatrix(rank, rows - 1, rank, columns - 1).getFrobeniusNorm()) != 0.0 && !(thisNorm / lastNorm * rNorm < dropThreshold); ++rank) {
            lastNorm = thisNorm;
        }
        return rank;
    }

    public DecompositionSolver getSolver() {
        return new Solver(super.getSolver(), this.getP());
    }

    private static class Solver
    implements DecompositionSolver {
        private final DecompositionSolver upper;
        private RealMatrix p;

        private Solver(DecompositionSolver upper, RealMatrix p) {
            this.upper = upper;
            this.p = p;
        }

        public boolean isNonSingular() {
            return this.upper.isNonSingular();
        }

        public RealVector solve(RealVector b2) {
            return this.p.operate(this.upper.solve(b2));
        }

        public RealMatrix solve(RealMatrix b2) {
            return this.p.multiply(this.upper.solve(b2));
        }

        public RealMatrix getInverse() {
            return this.solve(MatrixUtils.createRealIdentityMatrix(this.p.getRowDimension()));
        }
    }
}

