/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import java.io.Serializable;
import org.apache.commons.math3.Field;
import org.apache.commons.math3.FieldElement;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.fraction.BigFraction;
import org.apache.commons.math3.fraction.BigFractionField;
import org.apache.commons.math3.fraction.FractionConversionException;
import org.apache.commons.math3.linear.Array2DRowFieldMatrix;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.FieldMatrix;
import org.apache.commons.math3.linear.RealMatrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KolmogorovSmirnovDistribution
implements Serializable {
    private static final long serialVersionUID = -4670676796862967187L;
    private int n;

    public KolmogorovSmirnovDistribution(int n2) throws NotStrictlyPositiveException {
        if (n2 <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NOT_POSITIVE_NUMBER_OF_SAMPLES, n2);
        }
        this.n = n2;
    }

    public double cdf(double d2) throws MathArithmeticException {
        return this.cdf(d2, false);
    }

    public double cdfExact(double d2) throws MathArithmeticException {
        return this.cdf(d2, true);
    }

    public double cdf(double d2, boolean exact) throws MathArithmeticException {
        double ninv = 1.0 / (double)this.n;
        double ninvhalf = 0.5 * ninv;
        if (d2 <= ninvhalf) {
            return 0.0;
        }
        if (ninvhalf < d2 && d2 <= ninv) {
            double res = 1.0;
            double f2 = 2.0 * d2 - ninv;
            for (int i2 = 1; i2 <= this.n; ++i2) {
                res *= (double)i2 * f2;
            }
            return res;
        }
        if (1.0 - ninv <= d2 && d2 < 1.0) {
            return 1.0 - 2.0 * Math.pow(1.0 - d2, this.n);
        }
        if (1.0 <= d2) {
            return 1.0;
        }
        return exact ? this.exactK(d2) : this.roundedK(d2);
    }

    private double exactK(double d2) throws MathArithmeticException {
        int k2 = (int)Math.ceil((double)this.n * d2);
        FieldMatrix<BigFraction> H = this.createH(d2);
        FieldMatrix<BigFraction> Hpower = H.power(this.n);
        BigFraction pFrac = Hpower.getEntry(k2 - 1, k2 - 1);
        for (int i2 = 1; i2 <= this.n; ++i2) {
            pFrac = pFrac.multiply(i2).divide(this.n);
        }
        return pFrac.bigDecimalValue(20, 4).doubleValue();
    }

    private double roundedK(double d2) throws MathArithmeticException {
        int k2 = (int)Math.ceil((double)this.n * d2);
        FieldMatrix<BigFraction> HBigFraction = this.createH(d2);
        int m2 = HBigFraction.getRowDimension();
        Array2DRowRealMatrix H = new Array2DRowRealMatrix(m2, m2);
        for (int i2 = 0; i2 < m2; ++i2) {
            for (int j2 = 0; j2 < m2; ++j2) {
                H.setEntry(i2, j2, HBigFraction.getEntry(i2, j2).doubleValue());
            }
        }
        RealMatrix Hpower = H.power(this.n);
        double pFrac = Hpower.getEntry(k2 - 1, k2 - 1);
        for (int i3 = 1; i3 <= this.n; ++i3) {
            pFrac *= (double)i3 / (double)this.n;
        }
        return pFrac;
    }

    private FieldMatrix<BigFraction> createH(double d2) throws NumberIsTooLargeException, FractionConversionException {
        int i2;
        int k2 = (int)Math.ceil((double)this.n * d2);
        int m2 = 2 * k2 - 1;
        double hDouble = (double)k2 - (double)this.n * d2;
        if (hDouble >= 1.0) {
            throw new NumberIsTooLargeException(hDouble, (Number)1.0, false);
        }
        BigFraction h2 = null;
        try {
            h2 = new BigFraction(hDouble, 1.0E-20, 10000);
        }
        catch (FractionConversionException e1) {
            try {
                h2 = new BigFraction(hDouble, 1.0E-10, 10000);
            }
            catch (FractionConversionException e2) {
                h2 = new BigFraction(hDouble, 1.0E-5, 10000);
            }
        }
        FieldElement[][] Hdata = new BigFraction[m2][m2];
        for (int i3 = 0; i3 < m2; ++i3) {
            for (int j2 = 0; j2 < m2; ++j2) {
                Hdata[i3][j2] = i3 - j2 + 1 < 0 ? BigFraction.ZERO : BigFraction.ONE;
            }
        }
        BigFraction[] hPowers = new BigFraction[m2];
        hPowers[0] = h2;
        for (i2 = 1; i2 < m2; ++i2) {
            hPowers[i2] = h2.multiply(hPowers[i2 - 1]);
        }
        for (i2 = 0; i2 < m2; ++i2) {
            Hdata[i2][0] = Hdata[i2][0].subtract(hPowers[i2]);
            Hdata[m2 - 1][i2] = ((BigFraction)Hdata[m2 - 1][i2]).subtract(hPowers[m2 - i2 - 1]);
        }
        if (h2.compareTo(BigFraction.ONE_HALF) == 1) {
            Hdata[m2 - 1][0] = ((BigFraction)Hdata[m2 - 1][0]).add(h2.multiply(2).subtract(1).pow(m2));
        }
        for (i2 = 0; i2 < m2; ++i2) {
            for (int j3 = 0; j3 < i2 + 1; ++j3) {
                if (i2 - j3 + 1 <= 0) continue;
                for (int g2 = 2; g2 <= i2 - j3 + 1; ++g2) {
                    Hdata[i2][j3] = ((BigFraction)Hdata[i2][j3]).divide(g2);
                }
            }
        }
        return new Array2DRowFieldMatrix((Field)BigFractionField.getInstance(), Hdata);
    }
}

