/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.interpolation;

import org.apache.commons.math3.analysis.interpolation.BicubicSplineInterpolatingFunction;
import org.apache.commons.math3.analysis.interpolation.BicubicSplineInterpolator;
import org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.exception.NonMonotonicSequenceException;
import org.apache.commons.math3.exception.NotPositiveException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.fitting.PolynomialFitter;
import org.apache.commons.math3.optim.SimpleVectorValueChecker;
import org.apache.commons.math3.optim.nonlinear.vector.jacobian.GaussNewtonOptimizer;
import org.apache.commons.math3.util.MathArrays;
import org.apache.commons.math3.util.Precision;

public class SmoothingPolynomialBicubicSplineInterpolator
extends BicubicSplineInterpolator {
    private final PolynomialFitter xFitter;
    private final int xDegree;
    private final PolynomialFitter yFitter;
    private final int yDegree;

    public SmoothingPolynomialBicubicSplineInterpolator() {
        this(3);
    }

    public SmoothingPolynomialBicubicSplineInterpolator(int degree) throws NotPositiveException {
        this(degree, degree);
    }

    public SmoothingPolynomialBicubicSplineInterpolator(int xDegree, int yDegree) throws NotPositiveException {
        if (xDegree < 0) {
            throw new NotPositiveException(xDegree);
        }
        if (yDegree < 0) {
            throw new NotPositiveException(yDegree);
        }
        this.xDegree = xDegree;
        this.yDegree = yDegree;
        double safeFactor = 100.0;
        SimpleVectorValueChecker checker = new SimpleVectorValueChecker(100.0 * Precision.EPSILON, 100.0 * Precision.SAFE_MIN);
        this.xFitter = new PolynomialFitter(new GaussNewtonOptimizer(false, checker));
        this.yFitter = new PolynomialFitter(new GaussNewtonOptimizer(false, checker));
    }

    public BicubicSplineInterpolatingFunction interpolate(double[] xval, double[] yval, double[][] fval) throws NoDataException, NullArgumentException, DimensionMismatchException, NonMonotonicSequenceException {
        int i2;
        if (xval.length == 0 || yval.length == 0 || fval.length == 0) {
            throw new NoDataException();
        }
        if (xval.length != fval.length) {
            throw new DimensionMismatchException(xval.length, fval.length);
        }
        int xLen = xval.length;
        int yLen = yval.length;
        for (int i3 = 0; i3 < xLen; ++i3) {
            if (fval[i3].length == yLen) continue;
            throw new DimensionMismatchException(fval[i3].length, yLen);
        }
        MathArrays.checkOrder(xval);
        MathArrays.checkOrder(yval);
        PolynomialFunction[] yPolyX = new PolynomialFunction[yLen];
        for (int j2 = 0; j2 < yLen; ++j2) {
            this.xFitter.clearObservations();
            for (int i4 = 0; i4 < xLen; ++i4) {
                this.xFitter.addObservedPoint(1.0, xval[i4], fval[i4][j2]);
            }
            yPolyX[j2] = new PolynomialFunction(this.xFitter.fit(new double[this.xDegree + 1]));
        }
        double[][] fval_1 = new double[xLen][yLen];
        for (int j3 = 0; j3 < yLen; ++j3) {
            PolynomialFunction f2 = yPolyX[j3];
            for (i2 = 0; i2 < xLen; ++i2) {
                fval_1[i2][j3] = f2.value(xval[i2]);
            }
        }
        PolynomialFunction[] xPolyY = new PolynomialFunction[xLen];
        for (int i5 = 0; i5 < xLen; ++i5) {
            this.yFitter.clearObservations();
            for (int j4 = 0; j4 < yLen; ++j4) {
                this.yFitter.addObservedPoint(1.0, yval[j4], fval_1[i5][j4]);
            }
            xPolyY[i5] = new PolynomialFunction(this.yFitter.fit(new double[this.yDegree + 1]));
        }
        double[][] fval_2 = new double[xLen][yLen];
        for (i2 = 0; i2 < xLen; ++i2) {
            PolynomialFunction f3 = xPolyY[i2];
            for (int j5 = 0; j5 < yLen; ++j5) {
                fval_2[i2][j5] = f3.value(yval[j5]);
            }
        }
        return super.interpolate(xval, yval, fval_2);
    }
}

