/*
 * Decompiled with CFR 0.152.
 */
package drivers.xensity;

import com.hsyco.driverBase;
import com.hsyco.userBase;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;

public class Driver
extends driverBase {
    public static final String[] WEBOBJECTS = new String[0];
    public static final int DEFAULTSOCKETPORT = 0;
    public static final int COMMANDSQUEUESIZE = 256;
    public static final boolean SHUTDOWNWHENSLAVE = true;
    private final byte[] REQ_STATE_BUFFER = new byte[8];
    private String name;
    private int port;
    InetAddress addr;
    private long pollInterval = 2000L;
    private boolean genEvent = false;
    private boolean online;
    private Object pollingkLock = new Object();
    private int count = 1;
    private int zonesNum;

    public boolean init(String name, HashMap<String, String> config) {
        try {
            super.init(name);
            this.name = name;
            try {
                this.port = Integer.parseInt(config.get("port"));
                this.addr = InetAddress.getByName(config.get("host"));
            }
            catch (Exception e2) {
                throw new Exception("specify IP and port");
            }
            try {
                this.pollInterval = Integer.parseInt(config.get("pollinterval")) * 1000;
            }
            catch (Exception e2) {
                // empty catch block
            }
            this.messageLog("Connecting to " + this.addr.getHostAddress() + ":" + this.port);
            String startupevents = config.get("startupevents");
            if (startupevents != null) {
                this.genEvent = Boolean.parseBoolean(startupevents);
            }
            return true;
        }
        catch (Exception e3) {
            this.errorLog("Initialization failed - " + e3.getLocalizedMessage());
            this.end();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loop() {
        try {
            this.processGeneralState(this.reqState(65535));
            int i22 = 0;
            while (i22 < this.zonesNum) {
                this.processZoneState(this.reqState(i22));
                ++i22;
            }
            if (!this.online) {
                this.online = true;
                this.genEvent = true;
                this.ioWrite("connection", "online");
                this.uiSet("connection.offline", "visible", "false");
                this.uiSet("connection.online", "visible", "true");
            }
            Object i22 = this.pollingkLock;
            synchronized (i22) {
                this.pollingkLock.wait(this.pollInterval);
            }
            return true;
        }
        catch (Exception e2) {
            this.errorLog("Error in loop: " + e2);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return false;
        }
    }

    private void processZoneState(byte[] data) throws IOException {
        String prefix = "z" + ((data[0] & 0xFF) + ((data[1] & 0xFF) << 8)) + ".";
        this.ioWriteUiSet01(String.valueOf(prefix) + "prealarm.mem", "" + this.getBit(data, 2, 0));
        this.ioWriteUiSet01(String.valueOf(prefix) + "alarm.mem", "" + this.getBit(data, 2, 1));
        this.ioWriteUiSet01(String.valueOf(prefix) + "tamper.mem", "" + this.getBit(data, 2, 2));
        this.ioWriteUiSet01(String.valueOf(prefix) + "fault.mem", "" + this.getBit(data, 2, 3));
        this.ioWriteUiSet01(String.valueOf(prefix) + "alarm", "" + this.getBit(data, 2, 5));
        this.ioWriteUiSet01(String.valueOf(prefix) + "tamper", "" + this.getBit(data, 2, 6));
        this.ioWriteUiSet01(String.valueOf(prefix) + "fault", "" + this.getBit(data, 2, 7));
        this.ioWrite(String.valueOf(prefix) + "seclev", Integer.toString(data[3] & 0xFF));
        StringBuilder add = new StringBuilder();
        int i2 = 10;
        while (i2 >= 4) {
            add.append(Integer.toHexString(data[i2] & 0xFF | 0x100).substring(1));
            --i2;
        }
        this.ioWrite(String.valueOf(prefix) + "serial", add.toString().toUpperCase(Locale.ENGLISH));
        StringBuilder name = new StringBuilder();
        int i3 = 11;
        while (i3 <= 36) {
            name.append((char)data[i3]);
            ++i3;
        }
        this.ioWrite(String.valueOf(prefix) + "name", name.toString());
        this.ioWrite(String.valueOf(prefix) + "pn", Integer.toString((data[37] & 0xFF) + ((data[38] & 0xFF) << 8)));
        this.ioWrite(String.valueOf(prefix) + "line", Integer.toString(data[39] & 0xFF));
        if (data[40] == 1) {
            this.ioWriteUiSet01(String.valueOf(prefix) + "armed", "1");
            this.ioWriteUiSet01(String.valueOf(prefix) + "bypass", "0");
        } else if (data[40] == 2) {
            this.ioWriteUiSet01(String.valueOf(prefix) + "armed", "0");
            this.ioWriteUiSet01(String.valueOf(prefix) + "bypass", "0");
        } else if (data[40] == 3) {
            this.ioWriteUiSet01(String.valueOf(prefix) + "armed", "0");
            this.ioWriteUiSet01(String.valueOf(prefix) + "bypass", "1");
        }
    }

    private void processGeneralState(byte[] data) throws IOException {
        if ((data[0] & 0xFF) + ((data[1] & 0xFF) << 8) != 65535) {
            throw new IOException("gen state resp error");
        }
        if (data.length != 24) {
            throw new IOException("gen state resp len error");
        }
        StringBuilder add = new StringBuilder();
        int i2 = 8;
        while (i2 >= 2) {
            add.append(Integer.toHexString(data[i2] & 0xFF | 0x100).substring(1));
            --i2;
        }
        this.ioWrite("serial", add.toString().toUpperCase(Locale.ENGLISH));
        this.ioWrite("seclev", Integer.toString(data[9] & 0xFF));
        this.ioWrite("pn", Integer.toString((data[10] & 0xFF) + ((data[11] & 0xFF) << 8)));
        i2 = 0;
        while (i2 <= 3) {
            this.ioWriteUiSet01("in" + (i2 + 1), "" + this.getBit(data, 12, i2));
            ++i2;
        }
        i2 = 16;
        while (i2 <= 27) {
            this.ioWriteUiSet01("rel" + (i2 - 15), "" + this.getBit(data, 12, i2));
            ++i2;
        }
        i2 = 28;
        while (i2 <= 29) {
            this.ioWriteUiSet01("oc" + (i2 - 27), "" + this.getBit(data, 12, i2));
            ++i2;
        }
        this.ioWriteUiSet01("link.x16", "" + this.getBit(data, 16, 0));
        this.ioWriteUiSet01("link.sens", "" + this.getBit(data, 16, 1));
        this.ioWriteUiSet01("bus.power", "" + this.getBit(data, 16, 2));
        this.ioWriteUiSet01("alarm.nf", "" + this.getBit(data, 16, 3));
        this.ioWriteUiSet01("tamper.nf", "" + this.getBit(data, 16, 4));
        this.ioWriteUiSet01("arm", "" + this.getBit(data, 16, 12));
        this.ioWriteUiSet01("in.tamper", "" + this.getBit(data, 16, 13));
        this.ioWriteUiSet01("battery.low", "" + this.getBit(data, 16, 14));
        this.ioWriteUiSet01("test.fail", "" + this.getBit(data, 16, 15));
        this.ioWriteUiSet01("bus.fault", "" + this.getBit(data, 16, 18));
        this.ioWriteUiSet01("bus.overcurr", "" + this.getBit(data, 16, 19));
        this.ioWriteUiSet01("alarm", "" + this.getBit(data, 16, 22));
        this.ioWriteUiSet01("tamper", "" + this.getBit(data, 16, 23));
        this.ioWriteUiSet01("power.fault", "" + this.getBit(data, 16, 24));
        this.ioWrite("vin", Integer.toString((data[20] & 0xFF) + ((data[21] & 0xFF) << 8)));
        this.zonesNum = (data[22] & 0xFF) + ((data[23] & 0xFF) << 8);
    }

    private int getBit(byte[] data, int offset, int index) {
        offset += index / 8;
        return data[offset] >>> (index %= 8) & 1;
    }

    private byte[] reqState(int zone) throws IOException {
        this.REQ_STATE_BUFFER[0] = (byte)(zone & 0xFF);
        this.REQ_STATE_BUFFER[1] = (byte)(zone >> 8 & 0xFF);
        int respLen = zone == 65535 ? 24 : 41;
        return this.sendReceive(4144, this.REQ_STATE_BUFFER, respLen, false);
    }

    public boolean end() {
        String conn = userBase.ioGet(String.valueOf(this.name) + ".connection");
        if (conn == null || !conn.equals("offline")) {
            this.ioWrite("connection", "offline");
            this.uiSet("connection.offline", "visible", "true");
            this.uiSet("connection.online", "visible", "false");
        }
        return true;
    }

    public String user(String session, String user2, String id, HashMap<String, String> fields) {
        int sep = id.lastIndexOf(46);
        String cmd = id.substring(0, sep);
        String value = id.substring(sep + 1);
        this.command(cmd, value);
        return "";
    }

    private synchronized byte[] sendReceive(int mtn, byte[] data, int respLen, boolean checksum) throws IOException {
        DatagramSocket sock = null;
        try {
            byte[] pack = new byte[16 + data.length];
            pack[0] = (byte)(mtn & 0xFF);
            pack[1] = (byte)(mtn >> 8 & 0xFF);
            pack[2] = (byte)(data.length & 0xFF);
            pack[3] = (byte)(data.length >> 8 & 0xFF);
            if (checksum) {
                byte[] byArray = data;
                int n2 = data.length;
                int n3 = 0;
                while (n3 < n2) {
                    byte b2 = byArray[n3];
                    pack[5] = (byte)(pack[5] ^ b2);
                    ++n3;
                }
            }
            pack[6] = (byte)this.count++;
            pack[7] = 8;
            long ts = System.currentTimeMillis() / 1000L - 631152000L;
            pack[8] = (byte)(ts & 0xFFL);
            pack[9] = (byte)(ts >> 8 & 0xFFL);
            pack[10] = (byte)(ts >> 16 & 0xFFL);
            pack[11] = (byte)(ts >> 24 & 0xFFL);
            System.arraycopy(data, 0, pack, 16, data.length);
            sock = new DatagramSocket(this.port);
            sock.setSoTimeout(5000);
            DatagramPacket sendPacket = new DatagramPacket(pack, pack.length, this.addr, this.port);
            sock.send(sendPacket);
            if (this.isVerboseLog()) {
                StringBuilder sb = new StringBuilder();
                byte[] byArray = pack;
                int n4 = pack.length;
                int n5 = 0;
                while (n5 < n4) {
                    byte b3 = byArray[n5];
                    sb.append(Integer.toHexString(b3 & 0xFF | 0x100).substring(1));
                    sb.append(' ');
                    ++n5;
                }
                this.messageLog(">> " + sb.toString());
            }
            byte[] recvData = new byte[16 + respLen];
            DatagramPacket receivePacket = new DatagramPacket(recvData, recvData.length);
            sock.receive(receivePacket);
            if (this.isVerboseLog()) {
                StringBuilder sb = new StringBuilder();
                byte[] byArray = recvData;
                int n6 = recvData.length;
                int n7 = 0;
                while (n7 < n6) {
                    byte b4 = byArray[n7];
                    sb.append(Integer.toHexString(b4 & 0xFF | 0x100).substring(1));
                    sb.append(' ');
                    ++n7;
                }
                this.messageLog("<< " + sb.toString());
            }
            if ((recvData[7] & 4) == 4) {
                throw new IOException("err flag");
            }
            if (recvData[6] != pack[6]) {
                throw new IOException("counter error");
            }
            byte[] byArray = Arrays.copyOfRange(recvData, 16, recvData.length);
            return byArray;
        }
        finally {
            try {
                sock.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void command(String name, String value) {
        try {
            int z;
            String function;
            String target;
            name = name.toLowerCase();
            this.messageLog("Command: " + name + " = " + value);
            int dot = name.indexOf(46);
            if (dot > 0) {
                target = name.substring(0, dot);
                function = name.substring(dot + 1);
            } else {
                target = null;
                function = name;
            }
            byte[] cmdReq = new byte[8];
            boolean ok = false;
            if ("armed".equals(function)) {
                if (target.startsWith("z")) {
                    z = Integer.parseInt(target.substring(1));
                    if ("1".equals(value)) {
                        cmdReq[0] = 1;
                    } else if ("0".equals(value)) {
                        cmdReq[0] = 2;
                    } else {
                        throw new Exception("invalid value");
                    }
                    cmdReq[2] = (byte)(z & 0xFF);
                    cmdReq[3] = (byte)(z >> 8 & 0xFF);
                    ok = true;
                }
            } else if ("bypass".equals(function)) {
                if (target.startsWith("z") && "1".equals(value)) {
                    z = Integer.parseInt(target.substring(1));
                    cmdReq[0] = 3;
                    cmdReq[2] = (byte)(z & 0xFF);
                    cmdReq[3] = (byte)(z >> 8 & 0xFF);
                    ok = true;
                }
            } else if ("seclev".equals(function)) {
                byte lvl = Byte.parseByte(value);
                if (lvl < 1 || lvl > 3) {
                    throw new Exception("invalid value");
                }
                cmdReq[2] = lvl;
                if (target == null) {
                    cmdReq[0] = 4;
                    ok = true;
                } else if (target.startsWith("z")) {
                    int z2 = Integer.parseInt(target.substring(1));
                    cmdReq[0] = 5;
                    cmdReq[4] = (byte)(z2 & 0xFF);
                    cmdReq[5] = (byte)(z2 >> 8 & 0xFF);
                    ok = true;
                }
            } else if (function.startsWith("rel")) {
                int r = Integer.parseInt(target.substring(3));
                if ("1".equals(value)) {
                    cmdReq[0] = 6;
                } else if ("0".equals(value)) {
                    cmdReq[0] = 7;
                } else {
                    throw new Exception("invalid value");
                }
                cmdReq[2] = (byte)(r & 0xFF);
                cmdReq[3] = (byte)(r >> 8 & 0xFF);
                ok = true;
            }
            if (!ok) {
                throw new Exception("unknown command");
            }
            byte[] resp = this.sendReceive(4160, cmdReq, 8, false);
            int i2 = 0;
            while (i2 <= 5) {
                if (resp[i2] != cmdReq[i2]) {
                    throw new Exception("response data error");
                }
                ++i2;
            }
            switch (resp[6]) {
                case 1: {
                    throw new Exception("request param error");
                }
                case 2: {
                    throw new Exception("unavailable function");
                }
                case 3: {
                    throw new Exception("command failed");
                }
            }
            Object object = this.pollingkLock;
            synchronized (object) {
                this.pollingkLock.notify();
            }
        }
        catch (Exception e2) {
            this.errorLog("Error executing command '" + name + " = " + value + "': " + e2.getMessage());
        }
    }

    protected void ioWriteUiSet01(String name, String value) {
        if (this.genEvent) {
            super.ioWrite(name, value);
        } else {
            super.ioWriteNoEvents(name, value);
        }
        if ("1".equals(value)) {
            this.uiSet(String.valueOf(name) + ".1", "visible", "true");
            this.uiSet(String.valueOf(name) + ".0", "visible", "false");
        } else {
            this.uiSet(String.valueOf(name) + ".1", "visible", "false");
            this.uiSet(String.valueOf(name) + ".0", "visible", "true");
        }
    }

    @Override
    protected void uiSet(String id, String attr, String value) {
        super.uiSet(id, attr, value);
    }

    @Override
    protected void messageLog(String message) {
        super.messageLog(String.valueOf(message) + " [" + this.name + "]");
    }

    @Override
    protected void errorLog(String message) {
        super.errorLog(String.valueOf(message) + " [" + this.name + "]");
    }
}

