/*
 * Decompiled with CFR 0.152.
 */
package drivers.wxt520;

import com.hsyco.driverBase;
import java.text.DecimalFormat;
import java.util.HashMap;

public class Driver
extends driverBase {
    public static final int DEFAULTSOCKETPORT = 0;
    public static final int COMMANDSQUEUESIZE = 0;
    public static final boolean SHUTDOWNWHENSLAVE = true;
    private final long HEARTBEAT_TIMEOUT = 30000L;
    private String driverid = null;
    private String comm = null;
    private boolean gui = false;
    private boolean online = false;
    private long heartbeat = 0L;
    private double altitude = 0.0;
    private Double airtemperature = null;

    public boolean init(String name, HashMap<String, String> config) {
        super.init(name);
        this.driverid = new String(name);
        this.comm = config.get("comm");
        if (this.comm == null) {
            return false;
        }
        String s = config.get("gui");
        if (s != null) {
            this.gui = Boolean.parseBoolean(s);
        }
        if ((s = config.get("altitude")) != null) {
            try {
                this.altitude = Double.parseDouble(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.offline();
        if (this.readCommBytes(this.comm, 0) != null) {
            this.heartbeat = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean loop() {
        StringBuffer buffer = new StringBuffer();
        int state = 0;
        try {
            while (true) {
                byte[] data;
                if ((data = this.readCommBytes(this.comm, 1)) == null || data.length != 1) {
                    return this.heartbeat > System.currentTimeMillis() - 30000L;
                }
                switch (state) {
                    case 0: {
                        if (data[0] != 13) break;
                        state = 1;
                        break;
                    }
                    case 1: {
                        if (data[0] != 10) break;
                        state = 2;
                        buffer = new StringBuffer();
                        break;
                    }
                    case 2: {
                        if (data[0] == 13) {
                            if (buffer.length() <= 0) {
                                this.offline();
                                return false;
                            }
                            state = 1;
                            String response = buffer.toString();
                            if (this.isVerboseLog()) {
                                this.messageLog(String.valueOf(this.driverid) + ": DATA: " + response);
                            }
                            if (this.parseResponse(response)) {
                                this.heartbeat = System.currentTimeMillis();
                                this.online();
                                return true;
                            }
                            this.offline();
                            return false;
                        }
                        buffer.append((char)data[0]);
                        break;
                    }
                }
            }
        }
        catch (Exception e2) {
            this.offline();
            return false;
        }
    }

    public boolean end() {
        this.offline();
        this.closeComm(this.comm);
        return true;
    }

    private void offline() {
        if (this.online) {
            this.online = false;
            this.ioWrite("status", "offline");
            if (this.gui) {
                this.uiClear();
            }
        }
    }

    private void online() {
        if (!this.online) {
            this.online = true;
            this.ioWrite("status", "online");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean parseResponse(String data) {
        try {
            String[] sa;
            String crc;
            if (data.charAt(1) == 'r') {
                int crcposition = data.length() - 3;
                crc = data.substring(crcposition);
                if (!this.crcCheck(data = data.substring(0, crcposition), crc)) {
                    if (this.isVerboseLog()) {
                        this.errorLog(String.valueOf(this.driverid) + "CRC Error: DATA: " + data);
                    }
                    return false;
                }
            } else {
                crc = null;
            }
            if ((sa = data.split(","))[0].startsWith("0")) {
                int i2 = 1;
                while (i2 < sa.length) {
                    String[] pa = sa[i2].split("=");
                    String n2 = pa[0].toLowerCase();
                    if (n2.equals("id")) {
                        this.ioWrite(n2, pa[1]);
                        if (this.gui) {
                            this.uiSet(n2, "value", pa[1]);
                        }
                    } else {
                        int x = pa[1].length() - 1;
                        String v = pa[1].substring(0, x);
                        char u = pa[1].charAt(x);
                        if (u != '#') {
                            if (n2.equals("pa") && this.altitude != 0.0 && this.airtemperature != null) {
                                double p = Double.parseDouble(v) * Math.pow(1.0 - 0.0065 * this.altitude / (this.airtemperature + 0.0065 * this.altitude + 273.15), -5.257);
                                v = new DecimalFormat("0.0").format(p);
                            }
                            this.ioWrite(n2, v);
                            if (this.gui) {
                                if (n2.startsWith("s") || n2.startsWith("d")) {
                                    this.uiSet(n2, "value", String.valueOf(v) + " " + this.unitsWind(u));
                                } else if (n2.startsWith("p")) {
                                    this.uiSet(n2, "value", String.valueOf(v) + " " + this.unitsPressure(u));
                                } else if (n2.startsWith("ta")) {
                                    this.airtemperature = u == 'C' ? Double.parseDouble(v) : (Double.parseDouble(v) - 32.0) * 5.0 / 9.0;
                                    this.uiSet(n2, "value", String.valueOf(v) + " " + u);
                                } else if (n2.startsWith("t")) {
                                    this.uiSet(n2, "value", String.valueOf(v) + " " + u);
                                } else if (n2.startsWith("u")) {
                                    this.uiSet(n2, "value", String.valueOf(v) + " %RH");
                                } else if (n2.startsWith("rc")) {
                                    this.uiSet(n2, "value", String.valueOf(v) + " " + this.unitsRain(u));
                                } else if (n2.startsWith("rd")) {
                                    this.uiSet(n2, "value", String.valueOf(v) + " s");
                                } else if (n2.startsWith("r")) {
                                    this.uiSet(n2, "value", String.valueOf(v) + " " + this.unitsRain(u) + "/h");
                                } else if (n2.startsWith("hc")) {
                                    this.uiSet(n2, "value", String.valueOf(v) + " " + this.unitsHail(u));
                                } else if (n2.startsWith("hd")) {
                                    this.uiSet(n2, "value", String.valueOf(v) + " s");
                                } else if (n2.startsWith("h")) {
                                    this.uiSet(n2, "value", String.valueOf(v) + " " + this.unitsHail(u) + "h");
                                } else if (n2.startsWith("v")) {
                                    this.uiSet(n2, "value", String.valueOf(v) + " V");
                                }
                            }
                        }
                    }
                    ++i2;
                }
            }
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    private boolean crcCheck(String data, String crc) {
        int c2 = 0;
        StringBuffer sb = new StringBuffer();
        int i2 = 0;
        while (i2 < data.length()) {
            c2 = (c2 ^ data.charAt(i2) & 0xFF) & 0xFFFF;
            int j2 = 0;
            while (j2 < 8) {
                if ((c2 & 1) == 1) {
                    c2 >>= 1;
                    c2 = (c2 ^ 0xA001) & 0xFFFF;
                } else {
                    c2 >>= 1;
                }
                ++j2;
            }
            ++i2;
        }
        sb.append((char)(0x40 | c2 >> 12));
        sb.append((char)(0x40 | c2 >> 6 & 0x3F));
        sb.append((char)(0x40 | c2 & 0x3F));
        return crc.equals(sb.toString());
    }

    private String unitsWind(char code) {
        switch (code) {
            case 'D': {
                return "deg";
            }
            case 'K': {
                return "km/h";
            }
            case 'M': {
                return "m/s";
            }
            case 'N': {
                return "knots";
            }
            case 'S': {
                return "mph";
            }
        }
        return Character.toString(code);
    }

    private String unitsPressure(char code) {
        switch (code) {
            case 'B': {
                return "bar";
            }
            case 'H': {
                return "hPa";
            }
            case 'I': {
                return "inHg";
            }
            case 'M': {
                return "mmHg";
            }
            case 'P': {
                return "Pa";
            }
        }
        return Character.toString(code);
    }

    private String unitsRain(char code) {
        switch (code) {
            case 'I': {
                return "in";
            }
            case 'M': {
                return "mm";
            }
        }
        return Character.toString(code);
    }

    private String unitsHail(char code) {
        switch (code) {
            case 'H': {
                return "hits";
            }
            case 'I': {
                return "hits/in2";
            }
            case 'M': {
                return "hits/cm2";
            }
        }
        return Character.toString(code);
    }

    private void uiClear() {
        String[] names = new String[]{"id", "sn", "sm", "sx", "dn", "dm", "dx", "pa", "ta", "tp", "th", "ua", "rc", "rd", "ri", "rp", "hc", "hd", "hi", "hp", "vh", "vs", "vr"};
        int i2 = 0;
        while (i2 < names.length) {
            this.uiSet(names[i2], "value", "");
            ++i2;
        }
    }
}

