/*
 * Decompiled with CFR 0.152.
 */
package drivers.wolf8access;

import com.hsyco.driverBase;
import com.hsyco.userBase;
import drivers.wolf8access.Listener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class Driver
extends driverBase {
    public static final String[] WEBOBJECTS = new String[0];
    public static final int DEFAULTSOCKETPORT = 0;
    public static final int COMMANDSQUEUESIZE = 256;
    public static final boolean SHUTDOWNWHENSLAVE = true;
    static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    static final GregorianCalendar EPOCH = new GregorianCalendar();
    private static final byte[] ENTER;
    static final long LOOP_INTERVAL = 20000L;
    private String name;
    private String comm;
    private String pwd;
    private String serialNum;
    private boolean genEvent = true;
    private static int maxPeriph;
    private boolean online;
    private Listener listener;
    AtomicInteger respLock = new AtomicInteger(-1);

    static {
        EPOCH.set(1, 2000);
        EPOCH.set(2, 0);
        EPOCH.set(5, 1);
        EPOCH.set(11, 0);
        EPOCH.set(12, 0);
        EPOCH.set(13, 0);
        EPOCH.set(14, 0);
        ENTER = new byte[]{13};
        maxPeriph = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init(String name, HashMap<String, String> config) {
        try {
            int n2;
            super.init(name);
            this.name = name;
            this.comm = config.get("comm");
            if (this.comm == null) {
                throw new Exception("No comm port");
            }
            this.readComm(this.comm, 0);
            this.listener = new Listener(this, this.comm);
            this.listener.start();
            this.pwd = config.get("password");
            this.serialNum = config.get("serialnum");
            if (this.serialNum == null) {
                this.serialNum = "";
            }
            try {
                this.respLock.set(-1);
                this.writeData("w" + this.pwd + this.serialNum, -2, 3000);
            }
            catch (Exception e2) {
                throw new Exception("Authentication error");
            }
            this.writeData("b");
            int nMax = -2;
            int nPrev = -2;
            while ((n2 = this.respLock.get()) != nPrev) {
                if (n2 > nMax) {
                    nMax = n2;
                }
                this.messageLog("Found peripheral: " + (n2 + 1));
                nPrev = n2;
                AtomicInteger atomicInteger = this.respLock;
                synchronized (atomicInteger) {
                    this.respLock.notifyAll();
                    this.respLock.wait(2000L);
                }
            }
            if (nMax < 0) {
                throw new Exception("No discovery response");
            }
            this.messageLog("Max peripheral: " + (nMax + 1));
            maxPeriph = nMax + 1;
            int Y = 0;
            while (Y <= nMax) {
                this.respLock.set(-1);
                this.writeData("N" + Y, 100, 10000);
                this.writeData("L" + Y);
                this.writeData("T" + Y);
                ++Y;
            }
            this.respLock.set(-1);
            return true;
        }
        catch (Exception e3) {
            this.errorLog("Initialization failed - " + e3.getLocalizedMessage());
            this.end();
            return false;
        }
    }

    private int writeData(String data) throws Exception {
        return this.writeData(data, -1, 77777);
    }

    private int writeData(String data, int expVal, int timeout) throws Exception {
        return this.writeData(data.getBytes("ASCII"), expVal, timeout);
    }

    private int writeData(byte[] data) throws Exception {
        return this.writeData(data, -1, 77777);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeData(byte[] data, int expVal, int timeout) throws Exception {
        AtomicInteger atomicInteger = this.respLock;
        synchronized (atomicInteger) {
            long to = System.currentTimeMillis() + (long)timeout;
            int r = this.writeCommBytes(this.comm, data);
            r += this.writeCommBytes(this.comm, ENTER);
            do {
                if (System.currentTimeMillis() > to) {
                    throw new Exception("message timeout: no response received");
                }
                this.respLock.wait(2000L);
            } while (expVal >= 0 && this.respLock.get() != expVal);
            return r;
        }
    }

    @Override
    public byte[] readCommBytes(String portName, int len) {
        return super.readCommBytes(portName, len);
    }

    public boolean loop() {
        try {
            if (!this.online) {
                this.online = true;
                this.genEvent = true;
                this.ioWrite("connection", "online");
                this.uiSet("connection.offline", "visible", "false");
                this.uiSet("connection.online", "visible", "true");
            } else {
                this.sleep(20000L);
                this.writeData("w" + this.pwd + this.serialNum);
            }
            return this.listener.isOk();
        }
        catch (Exception e2) {
            this.errorLog("Error in loop: " + e2);
            this.sleep(1000L);
            return false;
        }
    }

    public boolean end() {
        String conn = userBase.ioGet(String.valueOf(this.name) + ".connection");
        if (conn == null || !conn.equals("offline")) {
            this.ioWrite("connection", "offline");
            this.uiSet("connection.offline", "visible", "true");
            this.uiSet("connection.online", "visible", "false");
        }
        this.listener.end();
        return true;
    }

    public String user(String session, String user2, String id, HashMap<String, String> fields) {
        int sep = id.lastIndexOf(46);
        String cmd = id.substring(0, sep);
        String value = id.substring(sep + 1);
        this.command(cmd, value);
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void command(String name, String value) {
        block40: {
            try {
                String function;
                String target;
                name = name.toLowerCase();
                this.messageLog("Command: " + name + " = " + value);
                int dot = name.indexOf(46);
                if (dot > 0) {
                    target = name.substring(0, dot);
                    function = name.substring(dot + 1);
                } else {
                    target = null;
                    function = name;
                }
                if (target == null) {
                    if (function.equals("time")) {
                        if ("read".equalsIgnoreCase(value)) {
                            this.writeData("t");
                        } else {
                            SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
                            Date date = dateFormat.parse(value);
                            long sec = (date.getTime() - EPOCH.getTimeInMillis()) / 1000L;
                            byte[] data = new byte[9];
                            data[0] = 100;
                            int i2 = 1;
                            while (i2 <= 8) {
                                data[i2] = (byte)(sec >>> (8 - i2) * 4 & 0xFL);
                                ++i2;
                            }
                            this.writeData(data);
                        }
                    }
                    break block40;
                }
                if (!target.startsWith("p")) break block40;
                char Y = target.charAt(1);
                if (function.equals("mem")) {
                    if (value.equals("add")) {
                        this.writeData("K" + Y);
                        break block40;
                    }
                    if (value.equalsIgnoreCase("read")) {
                        AtomicInteger date = this.respLock;
                        synchronized (date) {
                            this.respLock.set(-1);
                            this.writeData("N" + Y, 100, 5000);
                            break block40;
                        }
                    }
                    if (value.equalsIgnoreCase("clear")) {
                        this.writeData("D" + Y);
                    } else if (value.equalsIgnoreCase("refresh")) {
                        this.writeData("R" + Y);
                    }
                    break block40;
                }
                if (function.startsWith("mem.free")) {
                    if (value.equalsIgnoreCase("read")) {
                        this.writeData("M" + Y);
                    }
                    break block40;
                }
                if (function.startsWith("k")) {
                    if (function.endsWith(".blocked")) {
                        int xxxInt = Integer.parseInt(function.substring(1, function.indexOf(46)));
                        String xxx = this.addZeros("" + xxxInt, 3);
                        AtomicInteger atomicInteger = this.respLock;
                        synchronized (atomicInteger) {
                            this.respLock.set(xxxInt);
                            if (value.equals("1")) {
                                this.writeData("E" + Y + xxx);
                            } else {
                                this.writeData("V" + Y + xxx);
                            }
                            this.respLock.set(-1);
                            break block40;
                        }
                    }
                    if (!value.equals("erase")) break block40;
                    int xxxInt = Integer.parseInt(function.substring(1));
                    String xxx = this.addZeros("" + xxxInt, 3);
                    AtomicInteger atomicInteger = this.respLock;
                    synchronized (atomicInteger) {
                        this.respLock.set(xxxInt);
                        this.writeData("A" + Y + xxx);
                        this.respLock.set(-1);
                        break block40;
                    }
                }
                if (function.equals("open")) {
                    if (value.equals("1")) {
                        this.writeData("G" + Y);
                    }
                } else if (function.equals("blocked")) {
                    if (value.equals("1")) {
                        this.writeData("B" + Y);
                    } else {
                        this.writeData("U" + Y);
                    }
                } else if (function.equals("copy")) {
                    String[] X_sss_fff = value.split(":");
                    String X = X_sss_fff[0];
                    String sss = this.addZeros(X_sss_fff[1], 3);
                    String fff = this.addZeros(X_sss_fff[2], 3);
                    this.writeData("C" + X + Y + sss + fff);
                } else if (function.equals("reltime")) {
                    String xxxxx = this.addZeros(value, 5);
                    this.writeData("S" + Y + xxxxx);
                    this.writeData("T" + Y);
                }
            }
            catch (Exception e2) {
                this.errorLog("Error executing command '" + name + " = " + value + "': " + e2.getMessage());
            }
        }
    }

    private String addZeros(String val, int len) {
        int n2 = len - val.length();
        if (n2 <= 0) {
            return val;
        }
        StringBuilder sb = new StringBuilder();
        int i2 = 0;
        while (i2 < n2) {
            sb.append('0');
            ++i2;
        }
        sb.append(val);
        return sb.toString();
    }

    @Override
    public void ioWrite(String name, String value) {
        super.ioWrite(name, value);
    }

    @Override
    public void ioWriteForced(String name, String value) {
        super.ioWriteForced(name, value);
    }

    protected void ioWriteUiSet01(String name, String value) {
        if (this.genEvent) {
            super.ioWrite(name, value);
        } else {
            super.ioWriteNoEvents(name, value);
        }
        if ("1".equals(value)) {
            this.uiSet(String.valueOf(name) + ".1", "visible", "true");
            this.uiSet(String.valueOf(name) + ".0", "visible", "false");
        } else {
            this.uiSet(String.valueOf(name) + ".1", "visible", "false");
            this.uiSet(String.valueOf(name) + ".0", "visible", "true");
        }
    }

    @Override
    protected void uiSet(String id, String attr, String value) {
        super.uiSet(id, attr, value);
    }

    @Override
    protected void messageLog(String message) {
        super.messageLog(String.valueOf(message) + " [" + this.name + "]");
    }

    @Override
    protected void errorLog(String message) {
        super.errorLog(String.valueOf(message) + " [" + this.name + "]");
    }

    public static int getMaxPeriph() {
        return maxPeriph;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDriverInVerboseLog() {
        return this.isVerboseLog();
    }

    public String getSerialNum() {
        return this.serialNum;
    }
}

