/*
 * Decompiled with CFR 0.152.
 */
package drivers.vedirect;

import com.hsyco.driverBase;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;

public class Driver
extends driverBase {
    private String comm = null;
    private boolean gui = true;
    private boolean online = false;

    public boolean init(String name, HashMap<String, String> config) {
        super.init(name);
        this.comm = config.get("comm");
        if (this.comm == null) {
            return false;
        }
        String s = config.get("gui");
        if (s != null) {
            this.gui = Boolean.parseBoolean(s);
        }
        if (this.gui) {
            this.uiClear();
        }
        this.ioWrite("status", "offline");
        this.online = false;
        return this.readCommBytes(this.comm, 0) != null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean loop() {
        Hashtable<String, String> block = new Hashtable<String, String>();
        StringBuffer buffer = new StringBuffer();
        String name = null;
        int state = 0;
        boolean checksum = false;
        int sum = 0;
        try {
            while (true) {
                byte[] data;
                if ((data = this.readCommBytes(this.comm, 1)) == null || data.length != 1) {
                    return false;
                }
                sum = (sum + (data[0] & 0xFF)) % 256;
                switch (state) {
                    case 0: {
                        if (data[0] != 13) break;
                        state = 1;
                        break;
                    }
                    case 1: {
                        if (data[0] != 10) break;
                        state = 2;
                        buffer = new StringBuffer();
                        break;
                    }
                    case 2: {
                        if (data[0] == 9) {
                            if (buffer.length() > 0) {
                                state = 3;
                                name = buffer.toString().toLowerCase();
                                buffer = new StringBuffer();
                                checksum = name.equals("checksum");
                                break;
                            }
                            return false;
                        }
                        buffer.append((char)data[0]);
                        break;
                    }
                    case 3: {
                        if (checksum) {
                            if (sum == 0) {
                                Enumeration e2 = block.keys();
                                while (e2.hasMoreElements()) {
                                    String k2 = (String)e2.nextElement();
                                    String v = (String)block.get(k2);
                                    this.ioWrite(k2, v);
                                    if (!this.gui) continue;
                                    this.uiWrite(k2, v);
                                }
                            }
                            if (!this.online) {
                                this.online = true;
                                this.ioWrite("status", "online");
                            }
                            return true;
                        }
                        if (data[0] == 13) {
                            if (buffer.length() > 0) {
                                state = 1;
                                block.put(name, buffer.toString());
                                break;
                            }
                            return false;
                        }
                        buffer.append((char)data[0]);
                    }
                }
            }
        }
        catch (Exception e3) {
            return false;
        }
    }

    public boolean end() {
        this.ioWrite("status", "offline");
        if (this.gui) {
            this.uiClear();
        }
        return true;
    }

    private void uiWrite(String name, String value) {
        try {
            if (name.equals("v")) {
                this.uiSet(name, "value", String.valueOf(new DecimalFormat("0.00").format(Double.parseDouble(value) / 1000.0)) + " V");
            } else if (name.equals("vs")) {
                this.uiSet(name, "value", String.valueOf(new DecimalFormat("0.00").format(Double.parseDouble(value) / 1000.0)) + " V");
            } else if (name.equals("vm")) {
                this.uiSet(name, "value", String.valueOf(new DecimalFormat("0.00").format(Double.parseDouble(value) / 1000.0)) + " V");
            } else if (name.equals("dm")) {
                this.uiSet(name, "value", String.valueOf(new DecimalFormat("0.0").format(Double.parseDouble(value) / 10.0)) + " %");
            } else if (name.equals("vpv")) {
                this.uiSet(name, "value", String.valueOf(new DecimalFormat("0.00").format(Double.parseDouble(value) / 1000.0)) + " V");
            } else if (name.equals("ppv")) {
                this.uiSet(name, "value", String.valueOf(value) + " W");
            } else if (name.equals("i")) {
                this.uiSet(name, "value", String.valueOf(new DecimalFormat("0.00").format(Double.parseDouble(value) / 1000.0)) + " A");
            } else if (name.equals("t")) {
                this.uiSet(name, "value", value.equals("---") ? value : String.valueOf(value) + " C");
            } else if (name.equals("p")) {
                this.uiSet(name, "value", String.valueOf(value) + " W");
            } else if (name.equals("ce")) {
                if (value.equals("---")) {
                    this.uiSet(name, "value", value);
                } else {
                    this.uiSet(name, "value", String.valueOf(new DecimalFormat("0.00").format(Double.parseDouble(value) / 1000.0)) + " Ah");
                }
            } else if (name.equals("soc")) {
                if (value.equals("---")) {
                    this.uiSet(name, "value", value);
                } else {
                    this.uiSet(name, "value", String.valueOf(new DecimalFormat("0.0").format(Double.parseDouble(value) / 10.0)) + " %");
                }
            } else if (name.equals("ttg")) {
                if (value.equals("---")) {
                    this.uiSet(name, "value", value);
                } else {
                    int i2 = Integer.parseInt(value);
                    if (i2 == -1) {
                        this.uiSet(name, "value", "INF");
                    } else {
                        int h2 = i2 / 60;
                        int m2 = i2 % 60;
                        this.uiSet(name, "value", String.valueOf(h2) + ":" + new DecimalFormat("00").format(m2) + " h");
                    }
                }
            } else if (name.equals("h1")) {
                this.uiSet(name, "value", String.valueOf((int)(Double.parseDouble(value) / 1000.0)) + " Ah");
            } else if (name.equals("h2")) {
                this.uiSet(name, "value", String.valueOf((int)(Double.parseDouble(value) / 1000.0)) + " Ah");
            } else if (name.equals("h3")) {
                this.uiSet(name, "value", String.valueOf((int)(Double.parseDouble(value) / 1000.0)) + " Ah");
            } else if (name.equals("h4")) {
                this.uiSet(name, "value", value);
            } else if (name.equals("h5")) {
                this.uiSet(name, "value", value);
            } else if (name.equals("h6")) {
                this.uiSet(name, "value", String.valueOf((int)(Double.parseDouble(value) / 1000.0)) + " Ah");
            } else if (name.equals("h7")) {
                this.uiSet(name, "value", String.valueOf(new DecimalFormat("0.00").format(Double.parseDouble(value) / 1000.0)) + " V");
            } else if (name.equals("h8")) {
                this.uiSet(name, "value", String.valueOf(new DecimalFormat("0.00").format(Double.parseDouble(value) / 1000.0)) + " V");
            } else if (name.equals("h9")) {
                if (value.equals("---")) {
                    this.uiSet(name, "value", value);
                } else {
                    int i3 = Integer.parseInt(value) / 60;
                    int h3 = i3 / 60;
                    int m3 = i3 % 60;
                    this.uiSet(name, "value", String.valueOf(h3) + ":" + new DecimalFormat("00").format(m3) + " h");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void uiClear() {
        String[] names = new String[]{"v", "vs", "vm", "dm", "vpv", "ppv", "i", "t", "p", "ce", "soc", "ttg", "h1", "h2", "h3", "h4", "h5", "h6", "h7", "h8", "h9"};
        int i2 = 0;
        while (i2 < names.length) {
            this.uiSet(names[i2], "value", "");
            ++i2;
        }
    }
}

