/*
 * Decompiled with CFR 0.152.
 */
package drivers.tlabq;

public class Log {
    private int[] log;

    public Log(int[] n2) {
        this.log = n2;
    }

    public boolean equals(Object o2) {
        Log l2 = (Log)o2;
        int i2 = 0;
        while (i2 < this.log.length) {
            if (this.log[i2] != l2.log[i2]) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public String decodeLogMessage() {
        String s = "";
        String hexEventType = Integer.toHexString(this.log[0]);
        String eventType = "";
        if (hexEventType.equals("0")) {
            eventType = "armed";
        } else if (hexEventType.equals("1")) {
            eventType = "disarmed";
        } else if (hexEventType.equals("2")) {
            eventType = "alarm";
        } else if (hexEventType.equals("3")) {
            eventType = "pre-alarm";
        } else if (hexEventType.equals("4")) {
            eventType = "tamper";
        } else if (hexEventType.equals("5")) {
            eventType = "theft";
        } else if (hexEventType.equals("6")) {
            eventType = "technical event";
        } else if (hexEventType.equals("7")) {
            eventType = "technical fault";
        } else if (hexEventType.equals("8")) {
            eventType = "fire";
        } else if (hexEventType.equals("9")) {
            eventType = "med emergency";
        } else if (hexEventType.equals("a")) {
            eventType = "flooding";
        } else if (hexEventType.equals("b")) {
            eventType = "coertion";
        } else if (hexEventType.equals("c")) {
            eventType = "radio interference";
        } else if (hexEventType.equals("d")) {
            eventType = "radio-device supervision";
        } else if (hexEventType.equals("f")) {
            eventType = "no power";
        } else if (hexEventType.equals("10")) {
            eventType = "low battery";
        } else if (hexEventType.equals("11")) {
            eventType = "service";
        } else if (hexEventType.equals("12")) {
            eventType = "PSTN fault";
        } else if (hexEventType.equals("13")) {
            eventType = "GSM fault";
        } else if (hexEventType.equals("14")) {
            eventType = "GSM no credit";
        } else if (hexEventType.equals("15")) {
            eventType = "radio-freq med emergency";
        } else if (hexEventType.equals("16")) {
            eventType = "radio-freq theft";
        } else if (hexEventType.equals("17")) {
            eventType = "radio hooter fault";
        } else if (hexEventType.equals("18")) {
            eventType = "remote access";
        } else if (hexEventType.equals("19")) {
            eventType = "keyboard fault";
        } else if (hexEventType.equals("1a")) {
            eventType = "device tamper";
        } else if (hexEventType.equals("1b")) {
            eventType = "";
        } else if (hexEventType.equals("1c")) {
            eventType = "blinded zone";
        } else if (hexEventType.equals("1d")) {
            eventType = "cloud user login";
        } else if (hexEventType.equals("e0")) {
            eventType = "system restart";
        } else if (hexEventType.equals("ff")) {
            return s;
        }
        s = String.valueOf(s) + eventType;
        String hexDevType = Integer.toHexString(this.log[1]);
        String devType = "";
        if (hexDevType.equals("1")) {
            devType = "keyboard";
        } else if (hexDevType.equals("2")) {
            devType = "zone";
        } else if (hexDevType.equals("3")) {
            devType = "expansion";
        } else if (hexDevType.equals("4")) {
            devType = "inserter";
        } else if (hexDevType.equals("5")) {
            devType = "key zone";
        } else if (hexDevType.equals("6")) {
            devType = "timer";
        } else if (hexDevType.equals("7")) {
            devType = "sms";
        } else if (hexDevType.equals("8")) {
            devType = "remote user";
        } else if (hexDevType.equals("9")) {
            devType = "radio command";
        } else if (hexDevType.equals("a")) {
            devType = "radio hooter";
        } else if (hexDevType.equals("b")) {
            devType = "battery charger";
        } else if (hexDevType.equals("c")) {
            devType = "PSTN or GSM phone";
        } else if (hexDevType.equals("d")) {
            devType = "radiobus";
        } else if (hexDevType.equals("fe")) {
            devType = "system";
        }
        if (hexEventType.equals("0") || hexEventType.equals("1")) {
            s = String.valueOf(s) + " - " + devType;
            if (hexDevType.equals("1") || hexDevType.equals("4")) {
                s = String.valueOf(s) + " " + (this.log[2] + 1);
                s = this.log[3] == 255 && hexEventType.equals("0") ? String.valueOf(s) + " - quick arming" : (this.log[3] == 255 && hexEventType.equals("1") ? String.valueOf(s) + " - quick disarming" : String.valueOf(s) + " - user " + (this.log[3] + 1));
                s = String.valueOf(s) + this.bitmapGroups();
            } else if (hexDevType.equals("6") || hexDevType.equals("5") || hexDevType.equals("9")) {
                s = String.valueOf(s) + " " + (this.log[2] + 1) + this.bitmapGroups();
            } else if (hexDevType.equals("8")) {
                s = String.valueOf(s) + this.bitmapGroups();
            } else if (hexDevType.equals("c")) {
                s = String.valueOf(s) + " - user " + (this.log[3] + 1) + this.bitmapGroups();
            }
        } else if (hexEventType.equals("2") || hexEventType.equals("3") || hexEventType.equals("4") || hexEventType.equals("5") || hexEventType.equals("6") || hexEventType.equals("7") || hexEventType.equals("8") || hexEventType.equals("9") || hexEventType.equals("a") || hexEventType.equals("1c")) {
            s = String.valueOf(s) + " - zone " + (this.log[2] + 1);
            if (this.log[3] == 1) {
                s = String.valueOf(s) + " - external contact";
            }
        } else if (hexEventType.equals("15") || hexEventType.equals("16")) {
            s = String.valueOf(s) + " - " + (this.log[2] + 1);
        } else if (hexEventType.equals("1a") || hexEventType.equals("10")) {
            s = String.valueOf(s) + " - " + devType;
            if (!hexDevType.equals("fe")) {
                s = String.valueOf(s) + " " + (this.log[2] + 1);
            }
        } else if (hexEventType.equals("17")) {
            s = String.valueOf(s) + " " + (this.log[2] + 1);
        } else if (hexEventType.equals("f")) {
            s = String.valueOf(s) + " - " + devType;
            if (hexDevType.equals("b")) {
                s = String.valueOf(s) + " " + (this.log[2] + 1);
            }
        } else if (hexEventType.equals("b")) {
            s = String.valueOf(s) + " - user " + (this.log[3] + 1);
        } else if (hexEventType.equals("11")) {
            s = this.log[1] == 0 ? String.valueOf(s) + " - stop maintenance" : String.valueOf(s) + " - start maintenance";
            s = this.log[2] == 0 ? String.valueOf(s) + " - local user " + (this.log[3] + 1) : String.valueOf(s) + " - remote user";
        } else if (hexEventType.equals("d")) {
            s = String.valueOf(s) + " - zone " + (this.log[2] + 1);
        } else if (hexEventType.equals("19")) {
            s = String.valueOf(s) + " - keyboard " + (this.log[2] + 1);
        } else if (hexEventType.equals("18")) {
            s = String.valueOf(s) + " - " + this.log[3] + "." + this.log[4] + "." + this.log[5] + "." + this.log[6];
        } else if (hexEventType.equals("1d")) {
            s = String.valueOf(s) + " - user " + (this.log[3] + 1);
        }
        return s;
    }

    public String bitmapGroups() {
        String s = "";
        if (this.log[4] != 0) {
            s = String.valueOf(s) + " - area 1 - groups: " + Log.decodeBitmapGroups(this.log[4]);
        }
        if (this.log[5] != 0) {
            s = String.valueOf(s) + " - area 2 - groups: " + Log.decodeBitmapGroups(this.log[5]);
        }
        if (this.log[6] != 0) {
            s = String.valueOf(s) + " - area 3 - groups: " + Log.decodeBitmapGroups(this.log[6]);
        }
        if (this.log[7] != 0) {
            s = String.valueOf(s) + " - area 4 - groups: " + Log.decodeBitmapGroups(this.log[7]);
        }
        return s;
    }

    public static String decodeBitmapGroups(int b2) {
        String res = "";
        String s = Integer.toBinaryString(b2);
        switch (Integer.toBinaryString(b2).length()) {
            case 1: {
                s = "000" + s;
                break;
            }
            case 2: {
                s = "00" + s;
                break;
            }
            case 3: {
                s = "0" + s;
            }
        }
        if (s.charAt(3) == '1') {
            res = String.valueOf(res) + ",A";
        }
        if (s.charAt(2) == '1') {
            res = String.valueOf(res) + ",B";
        }
        if (s.charAt(1) == '1') {
            res = String.valueOf(res) + ",C";
        }
        if (s.charAt(0) == '1') {
            res = String.valueOf(res) + ",D";
        }
        if (res.length() != 0) {
            return res.substring(1);
        }
        return "";
    }

    public String getTime() {
        int hours = this.log[10];
        int minutes = this.log[11];
        int day = this.log[12];
        int month = this.log[13];
        int yearLow = this.log[14];
        int yearHigh = this.log[15];
        int year = yearHigh * 256 + yearLow;
        return String.valueOf(day < 10 ? "0" : "") + day + "/" + (month < 10 ? "0" : "") + month + "/" + year + " " + (hours < 10 ? "0" : "") + hours + ":" + (minutes < 10 ? "0" : "") + minutes;
    }

    public static Log readMostRecentLog(String s) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        try {
            String[] fields = s.split(",");
            int[] n2 = new int[fields.length];
            int i2 = 0;
            while (i2 < fields.length) {
                n2[i2] = Integer.parseInt(fields[i2]);
                ++i2;
            }
            return new Log(n2);
        }
        catch (Exception e2) {
            return null;
        }
    }

    public String writeMostRecentLog() {
        StringBuilder s = new StringBuilder();
        int i2 = 0;
        while (i2 < this.log.length) {
            s.append("," + this.log[i2]);
            ++i2;
        }
        if (s.length() > 0) {
            return s.substring(1);
        }
        return "";
    }
}

