/*
 * Decompiled with CFR 0.152.
 */
package drivers.tlabq;

import com.hsyco.driverBase;
import com.hsyco.hsyco;
import com.hsyco.userBase;
import drivers.tlabq.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Vector;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONArray;
import org.json.JSONObject;

public class Driver
extends driverBase {
    public static final int COMMANDSQUEUESIZE = 256;
    public static final boolean SHUTDOWNWHENSLAVE = true;
    public static final int DEFAULTPOLLINTERVAL = 1000;
    public static final int DEFAULTLOGSIZE = 400;
    private boolean startupevents;
    private boolean firstloop = true;
    private boolean gui = true;
    private boolean quadrio;
    private String name;
    private String username;
    private String password;
    private String host;
    private int pollinterval = 1000;
    private int logSize = 400;
    private ArrayList<Log> templogs = new ArrayList();
    private Vector<String> logs;
    private String logsVar;
    private String lastLogVar;
    private Log mostRecentLog;
    private int pollingArea;
    private int generalInfoCounter = 0;
    private long lastLogTs = 0L;
    private String httpResp;
    private HashMap<Integer, String> UISetZoneValues = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init(String name, HashMap<String, String> config) {
        try {
            super.init(name);
            this.name = name;
            try {
                InetAddress inet = InetAddress.getByName(config.get("host"));
                int port = Integer.parseInt(config.get("port"));
                this.host = String.valueOf(inet.getHostName()) + ":" + port;
            }
            catch (Exception e2) {
                throw new Exception(String.valueOf(name) + ": ioServersOption format error [" + name + "] - host ignored");
            }
            this.username = config.get("user");
            if (this.username == null) {
                this.messageLog(String.valueOf(name) + ": username ignored");
            }
            this.password = config.get("password");
            if (this.password == null) {
                this.messageLog(String.valueOf(name) + ": password ignored");
            }
            this.startupevents = Boolean.parseBoolean(config.get("startupevents"));
            if (config.containsKey("gui")) {
                this.gui = Boolean.parseBoolean(config.get("gui"));
            }
            try {
                int timer = Integer.parseInt(config.get("pollinterval"));
                if (timer >= 1000 && timer <= 30000) {
                    this.pollinterval = timer;
                }
            }
            catch (Exception e3) {
                this.messageLog(String.valueOf(name) + ": pollinterval ignored");
            }
            try {
                int n2 = Integer.parseInt(config.get("logsize"));
                if (n2 <= 400) {
                    this.logSize = n2;
                }
            }
            catch (Exception e4) {
                this.messageLog(String.valueOf(name) + ": logsize ignored");
            }
            this.UISetZoneValues.put(0, "not.configured");
            this.UISetZoneValues.put(1, "excluded");
            this.UISetZoneValues.put(2, "normal");
            this.UISetZoneValues.put(3, "tamper");
            this.UISetZoneValues.put(11, "open.internal");
            this.UISetZoneValues.put(12, "open.external");
            this.UISetZoneValues.put(13, "open.both");
            this.UISetZoneValues.put(20, "alarm.memory.closed.both");
            this.UISetZoneValues.put(21, "alarm.memory.open.internal");
            this.UISetZoneValues.put(22, "alarm.memory.open.external");
            this.UISetZoneValues.put(23, "alarm.memory.open.both");
            this.UISetZoneValues.put(40, "alarm.closed.both");
            this.UISetZoneValues.put(41, "alarm.open.internal");
            this.UISetZoneValues.put(42, "alarm.open.external");
            this.UISetZoneValues.put(43, "alarm.open.both");
            this.pollingArea = 1;
            Driver e4 = this;
            synchronized (e4) {
                this.httpResp = Driver.urlPost("http://" + this.host + "/sett/jsonrpc.json", "application/json", this.prepareStatusRequest("mQgetObj", "ids", 0), this.username, this.password);
                if (this.httpResp == null) {
                    throw new Exception(String.valueOf(this.name) + " - error in HTTP POST request - mQgetObj");
                }
                if (this.httpResp.startsWith("401")) {
                    throw new Exception(String.valueOf(this.name) + " - unauthorized");
                }
                if (!this.httpResp.startsWith("200")) {
                    throw new Exception(String.valueOf(this.name) + " - " + this.httpResp.substring(4));
                }
                this.readInfo(this.httpResp.substring(4));
            }
            this.sleep(100L);
            this.loadLogs();
            this.readRecordLog();
            this.messageLog(String.valueOf(name) + " - driver started | username: " + this.username + " | password: " + this.password + " | startupevents: " + this.startupevents + " | pollinterval: " + this.pollinterval);
            return true;
        }
        catch (Exception e5) {
            this.errorLog("Initialization failed - " + e5.getLocalizedMessage() + " - " + name);
            this.end();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loop() {
        if (this.generalInfoCounter >= 100) {
            this.generalInfoCounter = 0;
        }
        try {
            Driver driver;
            if (this.generalInfoCounter++ % 10 == 0) {
                driver = this;
                synchronized (driver) {
                    this.httpResp = Driver.urlPost("http://" + this.host + "/sett/jsonrpc.json", "application/json", this.prepareStatusRequest("mQgetObj", "diag", 0), this.username, this.password);
                    if (this.httpResp == null) {
                        throw new Exception(String.valueOf(this.name) + " - error in HTTP POST request - get general info stauts");
                    }
                    if (!this.httpResp.startsWith("200")) {
                        throw new Exception(String.valueOf(this.name) + " - " + this.httpResp.substring(4));
                    }
                    this.readGeneralStatus(this.httpResp.substring(4));
                }
                this.sleep(100L);
            }
            driver = this;
            synchronized (driver) {
                this.httpResp = Driver.urlPost("http://" + this.host + "/sett/jsonrpc.json", "application/json", this.prepareStatusRequest("m_q_get_area", null, this.pollingArea), this.username, this.password);
                if (this.httpResp == null) {
                    throw new Exception(String.valueOf(this.name) + " - error in HTTP POST request - get area status");
                }
                if (!this.httpResp.startsWith("200")) {
                    throw new Exception(String.valueOf(this.name) + " - " + this.httpResp.substring(4));
                }
                this.readAreaStatus(this.httpResp.substring(4));
            }
            this.sleep(100L);
            if (!this.quadrio && ++this.pollingArea > 4) {
                this.pollingArea = 1;
            }
            this.readRecordLog();
            driver = this;
            synchronized (driver) {
                this.httpResp = Driver.urlPost("http://" + this.host + "/sett/jsonrpc.json", "application/json", this.prepareStatusRequest("mQgetObj", "cnfZone", 0), this.username, this.password);
                if (this.httpResp == null) {
                    throw new Exception(String.valueOf(this.name) + " - error in HTTP POST request - get zone status");
                }
                if (!this.httpResp.startsWith("200")) {
                    throw new Exception(String.valueOf(this.name) + " - " + this.httpResp.substring(4));
                }
                this.readZoneStatus(this.httpResp.substring(4));
            }
            this.sleep(100L);
            driver = this;
            synchronized (driver) {
                this.httpResp = Driver.urlPost("http://" + this.host + "/sett/jsonrpc.json", "application/json", this.prepareStatusRequest("mQgetObj", "cnfOut", 0), this.username, this.password);
                if (this.httpResp == null) {
                    throw new Exception(String.valueOf(this.name) + " - error in HTTP POST request - get output status");
                }
                if (!this.httpResp.startsWith("200")) {
                    throw new Exception(String.valueOf(this.name) + " - " + this.httpResp.substring(4));
                }
                this.readOutputStatus(this.httpResp.substring(4));
            }
            if (this.firstloop) {
                this.firstloop = false;
                this.ioWrite("connection", "online");
                this.securityLog("HSYCO ONLINE");
            }
            if (this.lastLogTs != 0L && System.currentTimeMillis() > this.lastLogTs + 5000L) {
                this.uiSet("log0", "value", "");
                this.lastLogTs = 0L;
            }
            this.sleep(this.pollinterval);
            return true;
        }
        catch (Exception e2) {
            if (this.isVerboseLog()) {
                this.errorLog(String.valueOf(this.name) + ": Loop failed - " + e2.getMessage());
            }
            this.sleep(1000L);
            return false;
        }
    }

    public boolean end() {
        String conn = userBase.ioGet(String.valueOf(this.name) + ".connection");
        if (conn == null || !conn.equals("offline")) {
            this.ioWrite("connection", "offline");
            this.securityLog("HSYCO OFFLINE");
        }
        return true;
    }

    public String user(String session, String user2, String id, HashMap<String, String> fields) {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void command(String name, String value) {
        try {
            JSONObject params;
            String id;
            String[] fields;
            JSONObject json = null;
            if (name.startsWith("a")) {
                JSONArray groups;
                fields = name.split("\\.");
                id = fields[0].substring(1);
                json = new JSONObject();
                json.put("method", "m_q_set_area");
                json.put("id", "0000");
                params = new JSONObject();
                params = this.getOrderedJSONObject(params);
                params.put("aId", Integer.parseInt(id));
                if (fields[1].equals("name")) {
                    if (value.length() > 16) {
                        throw new Exception("area name too long (max 16 characters)");
                    }
                    params.put("name", value);
                }
                if (fields[1].equals("ins")) {
                    groups = new JSONArray();
                    int i2 = 0;
                    while (i2 < 4) {
                        JSONObject group = new JSONObject();
                        group.put("ins", Integer.parseInt(value));
                        groups.put(i2, group);
                        ++i2;
                    }
                    params.put("grps", groups);
                } else if (fields[1].equals("group")) {
                    groups = new JSONArray();
                    String groupType = fields[2];
                    String[] groupTypes = new String[]{"a", "b", "c", "d"};
                    int i3 = 0;
                    while (i3 < 4) {
                        JSONObject group = new JSONObject();
                        if (groupTypes[i3].equals(groupType)) {
                            if (fields[3].equals("name")) {
                                if (value.length() > 16) {
                                    throw new Exception("group name too long (max 16 characters)");
                                }
                                group.put("name", value);
                            } else if (fields[3].equals("ins")) {
                                group.put("ins", Integer.parseInt(value));
                            }
                        }
                        groups.put(i3, group);
                        ++i3;
                    }
                    params.put("grps", groups);
                }
                json.put("params", params);
            } else if (name.startsWith("o")) {
                fields = name.split("\\.");
                id = fields[0].substring(1);
                json = new JSONObject();
                json.put("method", "m_q_set_out");
                json.put("id", "0000");
                params = new JSONObject();
                params = this.getOrderedJSONObject(params);
                params.put("id", Integer.parseInt(id));
                if (fields.length == 1) {
                    params.put("stat", Integer.parseInt(value));
                } else if (fields[1].equals("name")) {
                    if (value.length() > 16) {
                        throw new Exception("output name too long (max 16 characters)");
                    }
                    params.put("name", value);
                } else if (fields[1].equals("sec")) {
                    params.put("sec", Integer.parseInt(value));
                }
                json.put("params", params);
            }
            int i4 = 0;
            while (i4 < 5) {
                Driver driver = this;
                synchronized (driver) {
                    this.httpResp = Driver.urlPost("http://" + this.host + "/sett/jsonrpc.json", "application/json", json.toString(), this.username, this.password);
                    if (this.httpResp == null) {
                        this.errorLog(String.valueOf(this.name) + " - error in HTTP POST request");
                    } else {
                        if (this.httpResp.startsWith("200")) {
                            if (!name.startsWith("a")) return;
                            this.readAreaStatus(this.httpResp.substring(4));
                            return;
                        }
                        this.errorLog(String.valueOf(this.name) + " - " + this.httpResp.substring(4));
                    }
                }
                this.sleep(100L);
                ++i4;
            }
            return;
        }
        catch (Exception e2) {
            this.errorLog(String.valueOf(this.name) + " - command error - " + name + ", " + value + " - " + e2.getMessage());
        }
    }

    @Override
    protected void ioWrite(String name, String value) {
        if (this.firstloop && !this.startupevents) {
            super.ioWriteNoEvents(name, value);
        } else {
            super.ioWrite(name, value);
        }
    }

    @Override
    protected void ioWriteForced(String name, String value) {
        super.ioWriteForced(name, value);
    }

    private void loadLogs() {
        block12: {
            this.logsVar = "__HSYCO__TLABQ_" + this.name + ".log!";
            this.lastLogVar = "__HSYCO__TLABQ_last_log!";
            ObjectInputStream ois = null;
            try {
                try {
                    String s = userBase.varGet(this.logsVar);
                    if (s == null) {
                        this.logs = new Vector(this.logSize);
                    }
                    byte[] data = Base64.decodeBase64(s);
                    ois = new ObjectInputStream(new ByteArrayInputStream(data));
                    this.logs = (Vector)ois.readObject();
                }
                catch (Exception e2) {
                    this.logs = new Vector(this.logSize);
                    try {
                        ois.close();
                    }
                    catch (Exception exception) {}
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    ois.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                ois.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.mostRecentLog = Log.readMostRecentLog(userBase.varGet(this.lastLogVar));
    }

    void securityLog(String event) {
        String message = event;
        hsyco.securityLog(String.valueOf(this.name) + " - " + message);
        String guiEntry = "<div style=\"font-size:17px\">" + message + "</div>";
        this.logs.add(0, guiEntry);
        while (this.logs.size() > this.logSize) {
            this.logs.remove(this.logSize);
        }
        StringBuilder text = new StringBuilder();
        int i2 = 0;
        while (i2 < this.logs.size()) {
            guiEntry = this.logs.get(i2);
            text.append("<div style=\"padding:3px\">").append(guiEntry).append("</div>");
            ++i2;
        }
        this.uiSet("log", "value", text.toString());
        this.uiSet("log0", "value", message);
        this.lastLogTs = System.currentTimeMillis();
        this.saveLogs();
    }

    private void saveLogs() {
        ByteArrayOutputStream out = null;
        ObjectOutputStream oos = null;
        try {
            try {
                out = new ByteArrayOutputStream();
                oos = new ObjectOutputStream(out);
                oos.writeObject(this.logs);
                userBase.varSet(this.logsVar, new String(Base64.encodeBase64(out.toByteArray())));
            }
            catch (Exception exception) {
                try {
                    out.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                try {
                    oos.close();
                }
                catch (Exception exception3) {}
            }
        }
        finally {
            try {
                out.close();
            }
            catch (Exception exception) {}
            try {
                oos.close();
            }
            catch (Exception exception) {}
        }
    }

    private String prepareStatusRequest(String method, String param, int id) {
        try {
            JSONObject json = new JSONObject();
            json.put("method", method);
            JSONObject params = new JSONObject();
            if (method.equals("m_q_get_area")) {
                params.put("aId", id);
            } else if (method.equals("m_q_get_rec")) {
                params.put("ri", Integer.parseInt(param));
                params.put("num", id);
            } else if (method.equals("m_q_get_out")) {
                params.put("id", id);
            } else if (method.equals("mQgetObj")) {
                params.put("oName", param);
            }
            json.put("params", params);
            json.put("id", "000");
            return json.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void readInfo(String resp) throws Exception {
        try {
            JSONObject json = new JSONObject(resp);
            JSONObject result = json.getJSONObject("result");
            JSONObject ids = result.getJSONObject("ids");
            if (ids.has("id")) {
                String id = ids.getString("id");
                this.ioWrite("id", id);
            }
            if (ids.has("md")) {
                String model = ids.getString("md");
                this.quadrio = model.equals("Quadrio");
                this.ioWrite("model", model);
            }
            if (ids.has("fw")) {
                String fw = ids.getString("fw");
                this.ioWrite("fw", fw);
            }
            if (ids.has("db")) {
                int db = ids.getInt("db");
                this.ioWrite("dataconfig", "" + db);
            }
            if (ids.has("ta")) {
                int ta = ids.getInt("ta");
                if (ta == 240) {
                    this.ioWrite("accesstype", "admin");
                } else if (ta == 255) {
                    this.ioWrite("accesstype", "no_valid_access");
                } else {
                    this.ioWrite("accesstype", "" + ta);
                }
            }
        }
        catch (Exception e2) {
            throw new Exception(String.valueOf(this.name) + " - error reading JSON response in TLABQ info status - " + e2.getMessage());
        }
    }

    private void readGeneralStatus(String resp) throws Exception {
        try {
            int n2;
            String s;
            JSONObject json = new JSONObject(resp);
            JSONObject result = json.getJSONObject("result");
            JSONObject diag = result.getJSONObject("diag");
            if (diag.has("temp")) {
                s = diag.getString("temp");
                this.ioWrite("temp", s);
            }
            if (diag.has("cred")) {
                s = diag.getString("cred");
                this.ioWrite("credit", s);
            }
            if (diag.has("gsm")) {
                n2 = diag.getInt("gsm");
                this.ioWrite("gsm.fault", "" + n2);
            } else {
                this.ioWrite("gsm.fault", "0");
            }
            if (diag.has("gsmCau")) {
                n2 = diag.getInt("gsmCau");
                this.ioWrite("gsm.fault.cause", "" + n2);
            }
            if (diag.has("pstn")) {
                n2 = diag.getInt("pstn");
                this.ioWrite("pstn.fault", "" + n2);
            } else {
                this.ioWrite("pstn.fault", "0");
            }
            if (diag.has("mains")) {
                n2 = diag.getInt("mains");
                this.ioWrite("nopower", "" + n2);
            } else {
                this.ioWrite("nopower", "0");
            }
            if (diag.has("dNoPwr")) {
                n2 = diag.getInt("dNoPwr");
                this.ioWrite("nopower.device", "" + n2);
            }
            if (diag.has("batt")) {
                n2 = diag.getInt("batt");
                this.ioWrite("batt.fault", "" + n2);
            } else {
                this.ioWrite("batt.fault", "0");
            }
            if (diag.has("dBatt")) {
                n2 = diag.getInt("dBatt");
                this.ioWrite("batt.fault.device", "" + n2);
            }
            if (diag.has("tamper")) {
                n2 = diag.getInt("tamper");
                this.ioWrite("tamper", "" + n2);
            } else {
                this.ioWrite("tamper", "0");
            }
            if (diag.has("dTamper")) {
                n2 = diag.getInt("dTamper");
                this.ioWrite("tamper.device", "" + n2);
            }
            if (diag.has("coerc")) {
                n2 = diag.getInt("coerc");
                this.ioWrite("coercion", "" + n2);
            } else {
                this.ioWrite("coercion", "0");
            }
            if (diag.has("uCoerc")) {
                n2 = diag.getInt("uCoerc");
                this.ioWrite("coercion.user", "" + n2);
            }
            if (diag.has("rfI")) {
                n2 = diag.getInt("rfI");
                this.ioWrite("radiointerference", "" + n2);
            } else {
                this.ioWrite("radiointerference", "0");
            }
            if (diag.has("zr")) {
                n2 = diag.getInt("zr");
                this.ioWrite("radiozone.fault", "" + n2);
            } else {
                this.ioWrite("radiozone.fault", "0");
            }
            if (diag.has("dZr")) {
                n2 = diag.getInt("dZr");
                this.ioWrite("radiozone.fault.zone", "" + n2);
            }
            if (diag.has("rfRap")) {
                n2 = diag.getInt("rfRap");
                this.ioWrite("theft", "" + n2);
            } else {
                this.ioWrite("theft", "0");
            }
            if (diag.has("dRfRap")) {
                n2 = diag.getInt("dRfRap");
                this.ioWrite("theft.device", "" + n2);
            }
            if (diag.has("rfEmMed")) {
                n2 = diag.getInt("rfEmMed");
                this.ioWrite("medemergency", "" + n2);
            } else {
                this.ioWrite("medemergency", "0");
            }
            if (diag.has("dRfEmMed")) {
                n2 = diag.getInt("dRfEmMed");
                this.ioWrite("medemergency.device", "" + n2);
            }
            if (diag.has("sirRf")) {
                n2 = diag.getInt("sirRf");
                this.ioWrite("radiohooter.fault", "" + n2);
            } else {
                this.ioWrite("radiohooter.fault", "0");
            }
            if (diag.has("dSirRf")) {
                n2 = diag.getInt("dSirRf");
                this.ioWrite("radiohooter.fault.device", "" + n2);
            }
            if (diag.has("kbr")) {
                n2 = diag.getInt("kbr");
                this.ioWrite("radiokeyboard.fault", "" + n2);
            } else {
                this.ioWrite("radiokeyboard.fault", "0");
            }
            if (diag.has("dKbr")) {
                n2 = diag.getInt("dKbr");
                this.ioWrite("radiokeyboard.fault.device", "" + n2);
            }
            if (diag.has("reAcc")) {
                n2 = diag.getInt("reAcc");
                this.ioWrite("remoteaccess", "" + n2);
            } else {
                this.ioWrite("remoteaccess", "0");
            }
            if (diag.has("sirRfMan")) {
                JSONArray arr = diag.getJSONArray("sirRfMan");
                s = "";
                if (arr.length() != 0) {
                    int i2 = 0;
                    while (i2 < arr.length()) {
                        s = String.valueOf(s) + "," + arr.getInt(i2);
                        ++i2;
                    }
                    this.ioWrite("radiohooter.ids", s.substring(1));
                }
            }
        }
        catch (Exception e2) {
            throw new Exception(String.valueOf(this.name) + " - error reading JSON response in general status - " + e2.getMessage());
        }
    }

    private void readAreaStatus(String resp) throws Exception {
        try {
            int n2;
            JSONObject json = new JSONObject(resp);
            JSONObject result = json.getJSONObject("result");
            JSONObject area = result.getJSONObject("area");
            int areaId = area.getInt("aId");
            if (area.has("name")) {
                String s = area.getString("name");
                this.ioWrite("a" + areaId + ".name", s);
            }
            if (area.has("all")) {
                n2 = area.getInt("all");
                this.ioWrite("a" + areaId + ".alarmgroups", Log.decodeBitmapGroups(n2));
            }
            if (area.has("man")) {
                n2 = area.getInt("man");
                this.ioWrite("a" + areaId + ".tampergroups", Log.decodeBitmapGroups(n2));
            }
            if (area.has("pre")) {
                n2 = area.getInt("pre");
                this.ioWrite("a" + areaId + ".prealarmgroups", Log.decodeBitmapGroups(n2));
            }
            if (area.has("acc")) {
                n2 = area.getInt("acc");
                this.ioWrite("a" + areaId + ".blindgroups", Log.decodeBitmapGroups(n2));
            }
            if (area.has("grps")) {
                char grId = 'a';
                JSONArray ar = area.getJSONArray("grps");
                int i2 = 0;
                while (i2 < ar.length()) {
                    JSONObject obj = ar.getJSONObject(i2);
                    if (obj.has("name")) {
                        String name = obj.getString("name");
                        this.ioWrite("a" + areaId + ".group." + grId + ".name", name);
                    }
                    if (obj.has("en")) {
                        int en = obj.getInt("en");
                        this.ioWrite("a" + areaId + ".group." + grId + ".en", "" + en);
                    }
                    if (obj.has("ins")) {
                        int ins = obj.getInt("ins");
                        this.ioWrite("a" + areaId + ".group." + grId + ".ins", "" + ins);
                    }
                    grId = (char)(grId + 1);
                    ++i2;
                }
            }
        }
        catch (Exception e2) {
            throw new Exception(String.valueOf(this.name) + " - error reading JSON response in area status - " + e2.getMessage());
        }
    }

    private void readOutputStatus(String resp) throws Exception {
        try {
            JSONObject json = new JSONObject(resp);
            JSONObject result = json.getJSONObject("result");
            JSONObject cnfOut = result.getJSONObject("cnfOut");
            int totOut = cnfOut.getInt("nOut");
            this.ioWrite("totaloutputs", "" + totOut);
            int totRadioOut = cnfOut.getInt("nOutR");
            this.ioWrite("totalradiooutputs", "" + totRadioOut);
            JSONArray outputs = cnfOut.getJSONArray("out");
            int i2 = 0;
            while (i2 < outputs.length()) {
                String hexVal = Integer.toHexString(outputs.getInt(i2));
                this.ioWrite("o" + (i2 + 1) + ".status", hexVal);
                ++i2;
            }
        }
        catch (Exception e2) {
            throw new Exception(String.valueOf(this.name) + " - error reading JSON response in output status - " + e2.getMessage());
        }
    }

    private void readZoneStatus(String resp) throws Exception {
        try {
            JSONObject json = new JSONObject(resp);
            JSONObject result = json.getJSONObject("result");
            JSONObject cnfZone = result.getJSONObject("cnfZone");
            int numWiredZone = cnfZone.getInt("nZf");
            this.ioWrite("totalwiredzones", "" + numWiredZone);
            int numRadioZone = cnfZone.getInt("nZr");
            this.ioWrite("totalradiozones", "" + numRadioZone);
            JSONArray zones = cnfZone.getJSONArray("zone");
            Collection<String> values = this.UISetZoneValues.values();
            int i2 = 0;
            while (i2 < zones.length()) {
                String hexVal = Integer.toHexString(zones.getInt(i2));
                String actualZoneStatus = userBase.ioGet(String.valueOf(this.name) + ".z" + (i2 + 1) + ".status");
                if (actualZoneStatus == null) {
                    actualZoneStatus = "";
                }
                this.ioWrite("z" + (i2 + 1) + ".status", hexVal);
                if (this.gui && !actualZoneStatus.equals(hexVal)) {
                    String UISetValue = this.UISetZoneValues.get(Integer.parseInt(hexVal));
                    for (String value : values) {
                        boolean visible = value.equals(UISetValue);
                        this.uiSet("z" + (i2 + 1) + "." + value, "visible", Boolean.toString(visible));
                    }
                }
                ++i2;
            }
        }
        catch (Exception e2) {
            throw new Exception(String.valueOf(this.name) + " - error reading JSON response in zone status - " + e2.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readRecordLog() throws Exception {
        int logStart = 1;
        int increment = 5;
        Log firstLog = null;
        boolean stop = false;
        this.templogs.clear();
        while (!stop && logStart <= 400) {
            Driver driver = this;
            synchronized (driver) {
                block13: {
                    this.httpResp = Driver.urlPost("http://" + this.host + "/sett/jsonrpc.json", "application/json", this.prepareStatusRequest("m_q_get_rec", "" + logStart, increment), this.username, this.password);
                    if (this.httpResp == null) {
                        throw new Exception(String.valueOf(this.name) + " - error in HTTP POST request - mQgetObj");
                    }
                    if (!this.httpResp.startsWith("200")) {
                        throw new Exception(String.valueOf(this.name) + " - " + this.httpResp.substring(4));
                    }
                    try {
                        JSONObject json = new JSONObject(this.httpResp.substring(4));
                        JSONObject result = json.getJSONObject("result");
                        JSONArray recs = result.getJSONArray("rec");
                        int i2 = 0;
                        while (i2 < recs.length()) {
                            JSONObject rec = recs.getJSONObject(i2);
                            JSONArray recInfo = rec.getJSONArray("r");
                            int[] rawLog = new int[20];
                            int j2 = 0;
                            while (j2 < recInfo.length()) {
                                rawLog[j2] = recInfo.getInt(j2);
                                ++j2;
                            }
                            Log log = new Log(rawLog);
                            if (this.mostRecentLog != null && this.mostRecentLog.equals(log)) {
                                stop = true;
                                break;
                            }
                            if (logStart == 1 && i2 == 0) {
                                firstLog = log;
                            }
                            this.templogs.add(log);
                            ++i2;
                        }
                    }
                    catch (Exception e2) {
                        if (!this.isVerboseLog()) break block13;
                        this.errorLog(String.valueOf(this.name) + " - error reading JSON response in record logs - " + e2.getMessage());
                    }
                }
            }
            this.sleep(100L);
            logStart += increment;
        }
        if (firstLog != null) {
            this.mostRecentLog = firstLog;
        }
        this.writeLogs();
    }

    private void writeLogs() {
        Collections.reverse(this.templogs);
        for (Log log : this.templogs) {
            String msg = log.decodeLogMessage();
            if (msg.isEmpty()) continue;
            this.securityLog(String.valueOf(log.getTime()) + " - " + msg);
        }
        if (this.mostRecentLog != null) {
            userBase.varSet(this.lastLogVar, this.mostRecentLog.writeMostRecentLog());
        }
    }

    private JSONObject getOrderedJSONObject(JSONObject jsonObject) {
        try {
            Field changeMap = jsonObject.getClass().getDeclaredField("map");
            changeMap.setAccessible(true);
            changeMap.set(jsonObject, new LinkedHashMap());
            changeMap.setAccessible(false);
        }
        catch (Exception e2) {
            this.errorLog(e2.getMessage());
        }
        return jsonObject;
    }
}

