/*
 * Decompiled with CFR 0.152.
 */
package drivers.telegram;

import drivers.telegram.ResponseError;
import drivers.telegram.requests.GetMeRequest;
import drivers.telegram.requests.GetUpdatesRequest;
import drivers.telegram.requests.Request;
import drivers.telegram.requests.SendFileRequest;
import drivers.telegram.types.Update;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TelegramBot {
    private final String baseUrl;

    public TelegramBot(String token) {
        if (token == null) {
            throw new NullPointerException("token null");
        }
        this.baseUrl = "https://api.telegram.org/bot" + token + "/";
    }

    public <T> T sendRequest(Request request, int timeout) throws IOException, ResponseError, JSONException {
        HttpURLConnection connection = null;
        try {
            String line;
            URL url = this.buildUrl(request);
            connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(timeout);
            connection.setReadTimeout(timeout);
            if (request instanceof SendFileRequest) {
                MultipartEntityBuilder builder = MultipartEntityBuilder.create();
                Path filePath = ((SendFileRequest)request).getFilePath();
                builder.addBinaryBody(((SendFileRequest)request).getFileParamName(), filePath.toFile());
                HttpEntity multipart = builder.build();
                connection.setRequestMethod("POST");
                connection.setDoOutput(true);
                connection.setRequestProperty("Content-Type", multipart.getContentType().getValue());
                connection.setRequestProperty("Content-Length", "" + multipart.getContentLength());
                OutputStream out = connection.getOutputStream();
                multipart.writeTo(out);
            } else {
                connection.setRequestMethod("GET");
                connection.setRequestProperty("Content-Length", "0");
            }
            boolean httpOk = connection.getResponseCode() == 200;
            InputStream in = httpOk ? connection.getInputStream() : connection.getErrorStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            StringBuffer sb = new StringBuffer();
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            br.close();
            JSONObject resp = new JSONObject(sb.toString());
            boolean ok = (Boolean)resp.get("ok");
            if (!ok) {
                String description = (String)resp.get("description");
                if (description == null) {
                    description = "ok=false";
                }
                throw new ResponseError(description);
            }
            Object object = resp.get("result");
            return (T)object;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private URL buildUrl(Request request) throws MalformedURLException, UnsupportedEncodingException {
        StringBuilder urlString = new StringBuilder(String.valueOf(this.baseUrl) + request.getMethodName());
        Map<String, String> params = request.getParameters();
        if (params != null && !params.isEmpty()) {
            int sep = 63;
            for (Map.Entry<String, String> param : params.entrySet()) {
                urlString.append((char)sep);
                urlString.append(param.getKey());
                urlString.append('=');
                urlString.append(URLEncoder.encode(param.getValue(), "UTF-8"));
                sep = 38;
            }
        }
        return new URL(urlString.toString());
    }

    public List<Update> pollUpdates(Integer offset, Integer limit, Integer timeout) throws IOException, ResponseError, JSONException {
        ArrayList<Update> r = new ArrayList<Update>();
        JSONArray updates = (JSONArray)this.sendRequest(new GetUpdatesRequest(offset, limit, timeout), (timeout == null ? 0 : timeout * 1000) + 5000);
        int i2 = 0;
        while (i2 < updates.length()) {
            r.add(new Update(updates.getJSONObject(i2)));
            ++i2;
        }
        return r;
    }

    public String getBotName(int timeout) throws IOException, ResponseError, JSONException {
        JSONObject result = (JSONObject)this.sendRequest(GetMeRequest.INSTANCE, timeout);
        return (String)result.get("username");
    }
}

